/*
 * Decompiled with CFR 0.152.
 */
package dap4.core.util;

import dap4.core.dmr.DapDimension;
import dap4.core.util.DapException;
import dap4.core.util.Index;
import dap4.core.util.Odometer;
import dap4.core.util.PowerSet;
import dap4.core.util.Slice;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;

public class MultiOdometer
extends Odometer {
    protected static boolean DEBUG = false;
    protected int current;
    protected long[] sizes;
    protected List<List<Slice>> slicesets;
    protected List<Odometer> odomset;

    public MultiOdometer() {
    }

    public MultiOdometer(List<Slice> set) throws DapException {
        this(set, null);
    }

    public MultiOdometer(List<Slice> set, List<DapDimension> dimset) throws DapException {
        super(set, dimset);
        this.ismulti = true;
        this.sizes = new long[this.rank];
        this.odomset = new ArrayList<Odometer>();
        for (int i = 0; i < this.rank; ++i) {
            Slice sl = set.get(i);
            List<Slice> subslices = sl.getSubSlices();
            this.sizes[i] = subslices.size();
        }
        int truerank = this.rank;
        if (truerank == 0) {
            this.slicesets = null;
            this.odomset = null;
        } else {
            PowerSet ps = new PowerSet(this.sizes);
            long pssize = ps.getTotalSize();
            long[][] setindices = ps.getPowerSet();
            assert ((long)setindices.length == pssize);
            this.slicesets = new ArrayList<List<Slice>>();
            if (DEBUG) {
                System.err.printf("Multi: |slicesets| = %d%n", setindices.length);
                System.err.println(ps.toString());
            }
            int i = 0;
            while ((long)i < pssize) {
                long[] indexset = setindices[i];
                assert (indexset.length == truerank);
                ArrayList<Slice> subset = new ArrayList<Slice>();
                for (int j = 0; j < this.rank; ++j) {
                    Slice s0 = set.get(j);
                    Slice ss = s0.getSubSlice((int)indexset[j]);
                    subset.add(ss);
                }
                this.slicesets.add(subset);
                ++i;
            }
            assert ((long)this.slicesets.size() == pssize);
            i = 0;
            while ((long)i < pssize) {
                Odometer sslodom = Odometer.factory(this.slicesets.get(i), dimset);
                this.odomset.add(sslodom);
                ++i;
            }
        }
        this.current = 0;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < this.rank; ++i) {
            Slice s = this.slice(i);
            if (i == this.current) {
                buf.append("*");
            }
            buf.append(s.toString());
            buf.append(String.format("(%d)", s.getCount()));
        }
        return buf.toString();
    }

    @Override
    public boolean hasNext() {
        if (this.current >= this.odomset.size()) {
            return false;
        }
        Odometer ocurrent = this.odomset.get(this.current);
        if (ocurrent.hasNext()) {
            return true;
        }
        ++this.current;
        return this.hasNext();
    }

    @Override
    public Index next() {
        if (this.current >= this.odomset.size()) {
            throw new NoSuchElementException();
        }
        Odometer ocurrent = this.odomset.get(this.current);
        assert (ocurrent.hasNext());
        return ocurrent.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long totalSize() {
        long size = 1L;
        for (int i = 0; i < this.rank; ++i) {
            size *= this.slice(i).getCount();
        }
        return size;
    }

    @Override
    public List<Odometer> getSubOdometers() {
        return this.odomset;
    }
}

