/*
 * Decompiled with CFR 0.152.
 */
package dap4.core.ce;

import dap4.core.ce.CEAST;
import dap4.core.ce.CECompiler;
import dap4.core.ce.Universal;
import dap4.core.ce.parser.CEParserImpl;
import dap4.core.data.Constraint;
import dap4.core.data.DataCursor;
import dap4.core.dmr.DapAttribute;
import dap4.core.dmr.DapDataset;
import dap4.core.dmr.DapDimension;
import dap4.core.dmr.DapEnumeration;
import dap4.core.dmr.DapGroup;
import dap4.core.dmr.DapNode;
import dap4.core.dmr.DapSequence;
import dap4.core.dmr.DapStructure;
import dap4.core.dmr.DapType;
import dap4.core.dmr.DapVariable;
import dap4.core.dmr.parser.ParseException;
import dap4.core.util.DapException;
import dap4.core.util.DapSort;
import dap4.core.util.DapUtil;
import dap4.core.util.Slice;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CEConstraint
implements Constraint {
    protected static final boolean PARSEDEBUG = false;
    protected static final boolean DEBUG = false;
    static final String LBRACE = "{";
    static final String RBRACE = "}";
    protected static Map<DapDataset, CEConstraint> universals = new HashMap<DapDataset, CEConstraint>();
    protected DapDataset dmr = null;
    protected List<Segment> segments = new ArrayList<Segment>();
    protected List<DapVariable> variables = new ArrayList<DapVariable>();
    protected Map<DapDimension, Slice> redefslice = new HashMap<DapDimension, Slice>();
    protected Map<DapNode, List<DapAttribute>> attributes = new HashMap<DapNode, List<DapAttribute>>();
    protected Map<DapDimension, DapDimension> redef = new HashMap<DapDimension, DapDimension>();
    protected List<DapDimension> dimrefs = new ArrayList<DapDimension>();
    protected List<DapEnumeration> enums = new ArrayList<DapEnumeration>();
    protected List<DapGroup> groups = new ArrayList<DapGroup>();
    protected List<DapDimension> refdims = new ArrayList<DapDimension>();
    protected boolean finished = false;
    protected Expand expansion = Expand.NONE;

    public static CEConstraint getUniversal(DapDataset dmr) {
        CEConstraint u = universals.get(dmr);
        if (u == null) {
            try {
                u = new Universal(dmr);
                universals.put(dmr, u);
            }
            catch (DapException de) {
                throw new IllegalArgumentException("DapDataSet has no universal");
            }
        }
        return u;
    }

    public static void release(DapDataset dmr) {
        universals.remove(dmr);
    }

    protected static DataCursor fieldValue(DapVariable sqvar, DapSequence seq, DataCursor record, String field) throws DapException {
        DapVariable dapv = seq.findByName(field);
        if (dapv == null) {
            throw new DapException("Unknown variable in filter: " + field);
        }
        if (!dapv.isAtomic()) {
            throw new DapException("Non-atomic variable in filter: " + field);
        }
        if (dapv.getRank() > 0) {
            throw new DapException("Non-scalar variable in filter: " + field);
        }
        int fieldindex = seq.indexByName(field);
        DataCursor da = record.readField(fieldindex);
        if (da == null) {
            throw new DapException("No such field: " + field);
        }
        return da;
    }

    protected static int compare(Object lvalue, Object rvalue) throws DapException {
        if (lvalue instanceof String && rvalue instanceof String) {
            return ((String)lvalue).compareTo((String)rvalue);
        }
        if (lvalue instanceof Boolean && rvalue instanceof Boolean) {
            return CEConstraint.compare((Boolean)lvalue != false ? 1 : 0, (Boolean)rvalue != false ? 1 : 0);
        }
        if (lvalue instanceof Double || lvalue instanceof Float || rvalue instanceof Double || rvalue instanceof Float) {
            double d1 = ((Number)lvalue).doubleValue();
            double d2 = ((Number)lvalue).doubleValue();
            return Double.compare(d1, d2);
        }
        long l1 = ((Number)lvalue).longValue();
        long l2 = ((Number)rvalue).longValue();
        return Long.compare(l1, l2);
    }

    protected Object eval(DapVariable var, DapSequence seq, DataCursor record, CEAST expr) throws DapException {
        switch (expr.sort) {
            case CONSTANT: {
                return expr.value;
            }
            case SEGMENT: {
                return CEConstraint.fieldValue(var, seq, record, expr.name);
            }
            case EXPR: {
                Object rhs;
                Object lhs = this.eval(var, seq, record, expr.lhs);
                Object object = rhs = expr.rhs == null ? null : this.eval(var, seq, record, expr.rhs);
                if (rhs != null) {
                    switch (expr.op) {
                        case LT: {
                            return CEConstraint.compare(lhs, rhs) < 0;
                        }
                        case LE: {
                            return CEConstraint.compare(lhs, rhs) <= 0;
                        }
                        case GT: {
                            return CEConstraint.compare(lhs, rhs) > 0;
                        }
                        case GE: {
                            return CEConstraint.compare(lhs, rhs) >= 0;
                        }
                        case EQ: {
                            return lhs.equals(rhs);
                        }
                        case NEQ: {
                            return !lhs.equals(rhs);
                        }
                        case REQ: {
                            return lhs.toString().matches(rhs.toString());
                        }
                        case AND: {
                            return (Boolean)lhs != false && (Boolean)rhs != false;
                        }
                    }
                    break;
                }
                switch (expr.op) {
                    case NOT: {
                        return (Boolean)lhs == false;
                    }
                }
            }
        }
        throw new DapException("Malformed Filter");
    }

    public CEConstraint() {
    }

    public CEConstraint(DapDataset dmr) {
        this.dmr = dmr;
    }

    public boolean isUniversal() {
        return false;
    }

    public DapDataset getDMR() {
        return this.dmr;
    }

    public DapDimension getRedefDim(DapDimension orig) {
        return this.redef.get(orig);
    }

    public void addRedef(DapDimension dim, Slice slice) {
        this.redefslice.put(dim, slice);
    }

    public void addVariable(DapVariable var, List<Slice> slices) throws DapException {
        if (this.findVariableIndex(var) < 0) {
            Segment segment = new Segment(var);
            segment.setSlices(slices);
            this.segments.add(segment);
            this.variables.add(var);
        }
    }

    public void addAttribute(DapNode node, DapAttribute attr) {
        List<DapAttribute> attrs = this.attributes.get(node);
        if (attrs == null) {
            attrs = new ArrayList<DapAttribute>();
            this.attributes.put(node, attrs);
        }
        attrs.add(attr);
    }

    public void setFilter(DapVariable var, CEAST filter) {
        Segment seg = this.findSegment(var);
        if (seg != null) {
            seg.filter = filter;
        }
    }

    public List<Slice> getConstrainedSlices(DapVariable var) throws DapException {
        List<Slice> slices = null;
        Segment seg = this.findSegment(var);
        if (seg != null) {
            slices = seg.slices;
        }
        if (slices == null) {
            slices = Universal.universalSlices(var);
        }
        return slices;
    }

    public List<DapDimension> getConstrainedDimensions(DapVariable var) {
        List<DapDimension> dimset = null;
        int index = this.findVariableIndex(var);
        if (index >= 0) {
            dimset = this.segments.get((int)index).dimset;
        }
        return dimset;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        boolean first = true;
        for (int i = 0; i < this.segments.size(); ++i) {
            Segment seg = this.segments.get(i);
            if (!seg.var.isTopLevel()) continue;
            if (!first) {
                buf.append(";");
            }
            first = false;
            this.dumpvar(seg, buf, false);
        }
        return buf.toString();
    }

    public CEConstraint finish() throws DapException {
        if (!this.finished) {
            this.finished = true;
            this.computeenums();
            this.computedimensions();
            this.computegroups();
        }
        return this;
    }

    public String toConstraintString() {
        StringBuilder buf = new StringBuilder();
        boolean first = true;
        for (int i = 0; i < this.segments.size(); ++i) {
            Segment seg = this.segments.get(i);
            if (!seg.var.isTopLevel()) continue;
            if (!first) {
                buf.append(";");
            }
            first = false;
            this.dumpvar(seg, buf, true);
        }
        return buf.toString();
    }

    protected void dumpvar(Segment seg, StringBuilder buf, boolean forconstraint) {
        if (seg.var.isTopLevel()) {
            buf.append(seg.var.getFQN());
        } else {
            buf.append(seg.var.getShortName());
        }
        List<DapDimension> dimset = seg.var.getDimensions();
        List<Slice> slices = seg.slices;
        if (slices == null) {
            dimset = new ArrayList<DapDimension>();
        } else assert (dimset.size() == 0 && DapUtil.isScalarSlices(slices) || dimset.size() == slices.size());
        for (int i = 0; i < dimset.size(); ++i) {
            Slice slice = slices.get(i);
            DapDimension dim = dimset.get(i);
            try {
                buf.append(forconstraint ? slice.toConstraintString() : slice.toString());
                continue;
            }
            catch (DapException dapException) {
                // empty catch block
            }
        }
        DapType basetype = seg.var.getBaseType();
        if (basetype.isAtomic()) {
            return;
        }
        if (basetype.getTypeSort().isCompound()) {
            DapStructure struct = (DapStructure)basetype;
            if (!this.isWholeCompound(struct)) {
                buf.append(LBRACE);
                boolean first = true;
                for (DapVariable field : struct.getFields()) {
                    if (!first) {
                        buf.append(";");
                    }
                    first = false;
                    Segment fseg = this.findSegment(field);
                    this.dumpvar(fseg, buf, forconstraint);
                }
                buf.append(RBRACE);
            }
            if (basetype.getTypeSort().isSeqType() && seg.filter != null) {
                buf.append("|");
                buf.append(seg.filter.toString());
            }
        }
    }

    public boolean references(DapNode node) {
        boolean isref = false;
        switch (node.getSort()) {
            case DIMENSION: {
                DapDimension dim = this.redef.get((DapDimension)node);
                if (dim == null) {
                    dim = (DapDimension)node;
                }
                isref = this.dimrefs.contains(dim);
                break;
            }
            case ENUMERATION: {
                isref = this.enums.contains((DapEnumeration)node);
                break;
            }
            case VARIABLE: {
                isref = this.findVariableIndex((DapVariable)node) >= 0;
                break;
            }
            case GROUP: 
            case DATASET: {
                isref = this.groups.contains((DapGroup)node);
                break;
            }
        }
        return isref;
    }

    public boolean match(DapVariable sqvar, DapSequence seq, DataCursor rec) throws DapException {
        Segment sseq = this.findSegment(sqvar);
        if (sseq == null) {
            return false;
        }
        CEAST filter = sseq.filter;
        if (filter == null) {
            return true;
        }
        return this.matches(sqvar, seq, rec, filter);
    }

    protected boolean matches(DapVariable var, DapSequence seq, DataCursor rec, CEAST filter) throws DapException {
        Object value = this.eval(var, seq, rec, filter);
        return (Boolean)value;
    }

    protected int findVariableIndex(DapVariable var) {
        for (int i = 0; i < this.variables.size(); ++i) {
            if (this.variables.get(i) != var) continue;
            return i;
        }
        return -1;
    }

    protected Segment findSegment(DapVariable var) {
        for (int i = 0; i < this.segments.size(); ++i) {
            if (this.segments.get((int)i).var != var) continue;
            return this.segments.get(i);
        }
        return null;
    }

    public void expand() {
        ArrayDeque<DapVariable> queue = new ArrayDeque<DapVariable>();
        for (int i = 0; i < this.variables.size(); ++i) {
            DapStructure struct;
            DapType base;
            DapVariable var = this.variables.get(i);
            if (!var.isTopLevel() || !(base = var.getBaseType()).getTypeSort().isCompound() || this.expansionCount(struct = (DapStructure)base) != 0) continue;
            queue.add(var);
        }
        while (queue.size() > 0) {
            DapVariable vvstruct = (DapVariable)queue.remove();
            DapStructure dstruct = (DapStructure)vvstruct.getBaseType();
            for (DapVariable field : dstruct.getFields()) {
                DapType fbase;
                if (this.findVariableIndex(field) < 0) {
                    this.segments.add(new Segment(field));
                    this.variables.add(field);
                }
                if (!(fbase = field.getBaseType()).getTypeSort().isCompound() || this.expansionCount((DapStructure)fbase) != 0) continue;
                queue.add(field);
            }
        }
        this.expansion = Expand.EXPANDED;
    }

    public void contract() {
        HashSet<DapStructure> contracted = new HashSet<DapStructure>();
        for (int i = 0; i < this.variables.size(); ++i) {
            DapType base;
            DapVariable var = this.variables.get(i);
            if (!var.isTopLevel() || !(base = var.getBaseType()).getTypeSort().isCompound()) continue;
            this.contractR((DapStructure)base, contracted);
        }
        this.expansion = Expand.CONTRACTED;
    }

    protected boolean contractR(DapStructure dstruct, Set<DapStructure> contracted) {
        if (contracted.contains(dstruct)) {
            return true;
        }
        int processed = 0;
        List<DapVariable> fields = dstruct.getFields();
        for (DapVariable field : fields) {
            DapType base;
            if (this.findVariableIndex(field) < 0 || (base = field.getBaseType()).getTypeSort().isCompound() && !contracted.contains(field) && !this.contractR((DapStructure)base, contracted)) break;
            ++processed;
        }
        if (processed < fields.size()) {
            return false;
        }
        contracted.add(dstruct);
        return true;
    }

    protected int expansionCount(DapStructure struct) {
        int count = 0;
        for (DapVariable field : struct.getFields()) {
            if (this.findVariableIndex(field) < 0) continue;
            ++count;
        }
        return count;
    }

    protected boolean isWholeCompound(DapStructure dstruct) {
        DapVariable field;
        Segment seg;
        int processed = 0;
        List<DapVariable> fields = dstruct.getFields();
        Iterator<DapVariable> iterator = fields.iterator();
        while (iterator.hasNext() && (seg = this.findSegment(field = iterator.next())) != null) {
            DapType base;
            List<Slice> slices = seg.slices;
            if (slices != null) {
                for (Slice slice : slices) {
                    if (slice.isConstrained().booleanValue()) break;
                }
            }
            if ((base = field.getBaseType()).getTypeSort().isCompound() && !this.isWholeCompound((DapStructure)base)) break;
            ++processed;
        }
        return processed == fields.size();
    }

    protected void computedimensions() throws DapException {
        for (DapDimension key : this.redefslice.keySet()) {
            Slice slice = this.redefslice.get(key);
            DapDimension newdim = (DapDimension)key.clone();
            newdim.setSize(slice.getCount());
            this.redef.put(key, newdim);
        }
        for (int i = 0; i < this.segments.size(); ++i) {
            Segment seg = this.segments.get(i);
            if (seg.var.getRank() == 0) continue;
            List<Slice> slices = seg.slices;
            List<DapDimension> orig = seg.var.getDimensions();
            ArrayList<DapDimension> newdims = new ArrayList<DapDimension>();
            if (slices == null) {
                slices = new ArrayList<Slice>();
            }
            while (slices.size() < orig.size()) {
                slices.add(new Slice().setConstrained(false));
            }
            assert (slices != null && slices.size() == orig.size());
            for (int j = 0; j < slices.size(); ++j) {
                Slice slice = slices.get(j);
                DapDimension dim0 = orig.get(j);
                DapDimension newdim = this.redef.get(dim0);
                if (newdim == null) {
                    newdim = dim0;
                }
                slice.setMaxSize(newdim.getSize());
                slice.finish();
                Slice newslice = null;
                if (slice.isConstrained().booleanValue()) {
                    newdim = new DapDimension(slice.getCount());
                } else {
                    newslice = new Slice(newdim);
                    if (newslice != null) {
                        if (!this.dimrefs.contains(dim0)) {
                            this.dimrefs.add(dim0);
                        }
                        slices.set(j, newslice);
                    }
                }
                newdims.add(newdim);
            }
            seg.setDimset(newdims);
        }
    }

    protected void computeenums() {
        for (int i = 0; i < this.variables.size(); ++i) {
            DapType daptype;
            DapVariable var = this.variables.get(i);
            if (var.getSort() != DapSort.VARIABLE || !(daptype = var.getBaseType()).isEnumType() || this.enums.contains((DapEnumeration)daptype)) continue;
            this.enums.add((DapEnumeration)daptype);
        }
    }

    protected void computegroups() {
        List<DapGroup> path;
        for (int i = 0; i < this.variables.size(); ++i) {
            DapVariable var = this.variables.get(i);
            path = var.getGroupPath();
            for (DapGroup group : path) {
                if (this.groups.contains(group)) continue;
                this.groups.add(group);
            }
        }
        for (DapDimension dim : this.dimrefs) {
            if (!dim.isShared()) continue;
            path = dim.getGroupPath();
            for (DapGroup group : path) {
                if (this.groups.contains(group)) continue;
                this.groups.add(group);
            }
        }
        for (DapEnumeration en : this.enums) {
            path = en.getGroupPath();
            for (DapGroup group : path) {
                if (this.groups.contains(group)) continue;
                this.groups.add(group);
            }
        }
    }

    public static CEConstraint compile(String sce, DapDataset dmr) throws DapException {
        boolean ok;
        if (sce == null || sce.length() == 0) {
            return CEConstraint.getUniversal(dmr);
        }
        CEParserImpl ceparser = new CEParserImpl(dmr);
        try {
            ok = ceparser.parse(sce);
        }
        catch (ParseException pe) {
            ok = false;
        }
        if (!ok) {
            throw new DapException("Constraint parse failed: " + sce);
        }
        CEAST root = ceparser.getCEAST();
        CECompiler compiler = new CECompiler();
        CEConstraint ce = compiler.compile(dmr, root);
        ce.expand();
        ce.finish();
        return ce;
    }

    protected static class Segment {
        DapVariable var;
        List<Slice> slices;
        List<DapDimension> dimset;
        CEAST filter;

        Segment(DapVariable var) {
            this.var = var;
            this.slices = null;
            this.filter = null;
            this.dimset = null;
        }

        void setDimset(List<DapDimension> dimset) {
            this.dimset = dimset;
        }

        void setSlices(List<Slice> slices) throws DapException {
            this.slices = slices;
            for (Slice sl : slices) {
                sl.finish();
            }
        }

        void setFilter(CEAST filter) {
            this.filter = filter;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append(this.var.getFQN());
            if (this.slices != null) {
                buf.append(this.slices.toString());
            }
            if (this.filter != null) {
                buf.append("|");
                buf.append(this.filter.toString());
            }
            return buf.toString();
        }
    }

    protected static enum Expand {
        NONE,
        EXPANDED,
        CONTRACTED;

    }
}

