/*
 * Decompiled with CFR 0.152.
 */
package dap4.core.data;

import dap4.core.data.DSP;
import dap4.core.util.DapContext;
import dap4.core.util.DapException;
import java.util.ArrayList;
import java.util.List;

public class DSPRegistry {
    public static final boolean LAST = true;
    public static final boolean FIRST = false;
    protected static ClassLoader loader = DSPRegistry.class.getClassLoader();
    protected List<Registration> registry = new ArrayList<Registration>();

    public static void setLoader(ClassLoader ldr) {
        loader = ldr;
    }

    public synchronized void register(String className, boolean last) throws DapException {
        try {
            Class<?> klass = loader.loadClass(className);
            this.register(klass, last);
        }
        catch (ClassNotFoundException e) {
            throw new DapException(e);
        }
    }

    public synchronized void register(Class<? extends DSP> klass, boolean last) {
        if (this.registered(klass)) {
            return;
        }
        if (last) {
            this.registry.add(new Registration(klass));
        } else {
            this.registry.add(0, new Registration(klass));
        }
    }

    public synchronized boolean registered(Class<? extends DSP> klass) {
        for (Registration r : this.registry) {
            if (r.dspclass != klass) continue;
            return true;
        }
        return false;
    }

    public synchronized void unregister(Class<? extends DSP> klass) {
        for (int i = 0; i < this.registry.size(); ++i) {
            if (this.registry.get((int)i).dspclass != klass) continue;
            this.registry.remove(i);
            break;
        }
    }

    public synchronized DSP findMatchingDSP(String path, DapContext cxt) throws DapException {
        for (int i = 0; i < this.registry.size(); ++i) {
            try {
                Registration tester = this.registry.get(i);
                boolean ismatch = tester.matcher.dspMatch(path, cxt);
                if (!ismatch) continue;
                DSP dsp = tester.dspclass.newInstance();
                return dsp;
            }
            catch (Exception e) {
                throw new DapException(e);
            }
        }
        throw new IllegalArgumentException("Cannot open " + path);
    }

    protected static class Registration {
        Class<? extends DSP> dspclass;
        DSP matcher;

        public Registration(Class<? extends DSP> cl) {
            this.dspclass = cl;
            try {
                this.matcher = this.dspclass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new IllegalArgumentException("DSPFactory: cannot create matching instance for Class: " + this.dspclass.getName());
            }
        }

        public String toString() {
            return this.dspclass.getName();
        }
    }
}

