/*
 * Decompiled with CFR 0.152.
 */
package dap4.core.dmr;

import dap4.core.dmr.DapDataset;
import dap4.core.dmr.DapDecl;
import dap4.core.dmr.DapEnumeration;
import dap4.core.dmr.DapNode;
import dap4.core.dmr.TypeSort;
import dap4.core.util.DapSort;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;

public class DapType
extends DapNode
implements DapDecl {
    public static final DapType CHAR;
    public static final DapType INT8;
    public static final DapType UINT8;
    public static final DapType INT16;
    public static final DapType UINT16;
    public static final DapType INT32;
    public static final DapType UINT32;
    public static final DapType INT64;
    public static final DapType UINT64;
    public static final DapType FLOAT32;
    public static final DapType FLOAT64;
    public static final DapType STRING;
    public static final DapType URL;
    public static final DapType OPAQUE;
    public static final DapType STRUCTURE;
    public static final DapType SEQUENCE;
    protected static final DapDataset pseudoroot;
    static final Map<TypeSort, DapType> typemap;
    protected TypeSort typesort = null;

    public static DapType lookup(TypeSort atomic) {
        if (atomic == TypeSort.Enum) {
            return null;
        }
        return typemap.get((Object)atomic);
    }

    protected DapType(TypeSort typesort) {
        this(typesort.name(), typesort);
    }

    public DapType(String name, TypeSort typesort) {
        super(name);
        if (this.sort == DapSort.ENUMERATION) {
            this.setTypeSort(TypeSort.Enum);
        } else {
            this.setTypeSort(typesort);
        }
    }

    public TypeSort getAtomicType() {
        if (this.typesort == TypeSort.Enum) {
            return ((DapEnumeration)this).getBaseType().getTypeSort();
        }
        return this.getTypeSort();
    }

    public TypeSort getTypeSort() {
        return this.typesort;
    }

    public String getTypeName() {
        return this.typesort == TypeSort.Enum ? this.getFQN() : this.getShortName();
    }

    protected void setTypeSort(TypeSort typesort) {
        this.typesort = typesort;
    }

    public boolean isUnsigned() {
        if (this.typesort == TypeSort.Enum) {
            return ((DapEnumeration)this).getBaseType().isUnsigned();
        }
        return this.typesort.isUnsigned();
    }

    public boolean isAtomic() {
        return this.getTypeSort().isAtomic();
    }

    public boolean isIntegerType() {
        return this.typesort.isIntegerType();
    }

    public boolean isFloatType() {
        return this.typesort.isFloatType();
    }

    public boolean isNumericType() {
        return this.typesort.isNumericType();
    }

    public boolean isStringType() {
        return this.typesort.isStringType();
    }

    public boolean isEnumType() {
        return this.typesort.isEnumType();
    }

    public boolean isCharType() {
        return this.typesort.isCharType();
    }

    public boolean isOpaqueType() {
        return this.typesort.isOpaqueType();
    }

    public boolean isFixedSize() {
        return this.typesort.isFixedSize();
    }

    public boolean isStructType() {
        return this.typesort.isStructType();
    }

    public boolean isSeqType() {
        return this.typesort.isSeqType();
    }

    public boolean isCompoundType() {
        return this.typesort.isCompoundType();
    }

    public boolean isLegalAttrType() {
        return this.typesort.isLegalAttrType();
    }

    public boolean isCompound() {
        return this.typesort.isCompound();
    }

    public int getSize() {
        return TypeSort.getSize(this.getAtomicType());
    }

    public Object vector(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        return Array.newInstance(this.getClass(), n);
    }

    public Object vectorget(Object vector, int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        assert (vector.getClass().isArray()) : "Attempt to apply index to non-vector";
        return Array.get(vector, n);
    }

    static {
        pseudoroot = new DapDataset("");
        typemap = new HashMap<TypeSort, DapType>();
        CHAR = new DapType(TypeSort.Char);
        INT8 = new DapType(TypeSort.Int8);
        UINT8 = new DapType(TypeSort.UInt8);
        INT16 = new DapType(TypeSort.Int16);
        UINT16 = new DapType(TypeSort.UInt16);
        INT32 = new DapType(TypeSort.Int32);
        UINT32 = new DapType(TypeSort.UInt32);
        INT64 = new DapType(TypeSort.Int64);
        UINT64 = new DapType(TypeSort.UInt64);
        FLOAT32 = new DapType(TypeSort.Float32);
        FLOAT64 = new DapType(TypeSort.Float64);
        STRING = new DapType(TypeSort.String);
        URL = new DapType(TypeSort.URL);
        OPAQUE = new DapType(TypeSort.Opaque);
        STRUCTURE = new DapType(TypeSort.Structure);
        SEQUENCE = new DapType(TypeSort.Sequence);
        typemap.put(TypeSort.Char, CHAR);
        typemap.put(TypeSort.Int8, INT8);
        typemap.put(TypeSort.UInt8, UINT8);
        typemap.put(TypeSort.Int16, INT16);
        typemap.put(TypeSort.UInt16, UINT16);
        typemap.put(TypeSort.Int32, INT32);
        typemap.put(TypeSort.UInt32, UINT32);
        typemap.put(TypeSort.Int64, INT64);
        typemap.put(TypeSort.UInt64, UINT64);
        typemap.put(TypeSort.Float32, FLOAT32);
        typemap.put(TypeSort.Float64, FLOAT64);
        typemap.put(TypeSort.String, STRING);
        typemap.put(TypeSort.URL, URL);
        typemap.put(TypeSort.Opaque, OPAQUE);
        typemap.put(TypeSort.Structure, STRUCTURE);
        typemap.put(TypeSort.Sequence, SEQUENCE);
        for (Map.Entry<TypeSort, DapType> entry : typemap.entrySet()) {
            entry.getValue().setDataset(pseudoroot);
            entry.getValue().setParent(pseudoroot);
        }
    }
}

