/*
 * Decompiled with CFR 0.152.
 */
package dap4.core.ce;

import dap4.core.ce.CEConstraint;
import dap4.core.dmr.DapDataset;
import dap4.core.dmr.DapDimension;
import dap4.core.dmr.DapEnumeration;
import dap4.core.dmr.DapGroup;
import dap4.core.dmr.DapNode;
import dap4.core.dmr.DapVariable;
import dap4.core.util.DapException;
import dap4.core.util.DapUtil;
import dap4.core.util.Slice;
import java.util.ArrayList;
import java.util.List;

public class Universal
extends CEConstraint {
    public Universal() {
    }

    public Universal(DapDataset dmr) throws DapException {
        super(dmr);
        this.build();
    }

    @Override
    public boolean isUniversal() {
        return true;
    }

    @Override
    public CEConstraint finish() throws DapException {
        this.finished = true;
        return this;
    }

    protected void build() throws DapException {
        List<DapVariable> top = this.dmr.getTopVariables();
        for (int i = 0; i < top.size(); ++i) {
            DapVariable var = top.get(i);
            List<Slice> slices = DapUtil.dimsetToSlices(var.getDimensions());
            super.addVariable(var, slices);
        }
        this.enums = new ArrayList<DapEnumeration>();
        this.enums.addAll(this.dmr.getEnums());
        this.dimrefs = new ArrayList<DapDimension>();
        this.dimrefs.addAll(this.dmr.getDimensions());
        this.groups = new ArrayList<DapGroup>();
        this.groups.addAll(this.dmr.getGroups());
        super.expand();
        super.finish();
    }

    @Override
    public boolean references(DapNode node) {
        switch (node.getSort()) {
            case DIMENSION: 
            case ENUMERATION: 
            case VARIABLE: 
            case GROUP: 
            case DATASET: {
                return true;
            }
        }
        return false;
    }

    @Override
    public List<Slice> getConstrainedSlices(DapVariable var) throws DapException {
        List<Slice> slices = super.getConstrainedSlices(var);
        if (slices != null) {
            return slices;
        }
        return Universal.universalSlices(var);
    }

    public static List<Slice> universalSlices(DapVariable var) throws DapException {
        return DapUtil.dimsetToSlices(var.getDimensions());
    }
}

