/*
 * Decompiled with CFR 0.152.
 */
package dap4.dap4lib.netcdf;

import com.sun.jna.Library;
import com.sun.jna.Native;
import dap4.dap4lib.DapLog;
import dap4.dap4lib.netcdf.DapNetcdf;
import java.io.IOException;

public abstract class NetcdfLoader {
    public static final boolean DEBUG = false;
    public static final String DFLAG_JNAPATH = "jna.library.path";
    public static final String ENV_JNAPATH = "JNA_PATH";
    static String DFALT_NETCDF4LIBNAME = "netcdf";
    protected static DapNetcdf nc4 = null;
    protected static String jnaPath = null;
    protected static String libName = DFALT_NETCDF4LIBNAME;

    public static synchronized void setLibraryAndPath(String jna_path, String lib_name) {
        if ((lib_name = NetcdfLoader.nullify(lib_name)) == null) {
            lib_name = DFALT_NETCDF4LIBNAME;
        }
        if ((jna_path = NetcdfLoader.nullify(jna_path)) == null) {
            jna_path = NetcdfLoader.nullify(System.getProperty(DFLAG_JNAPATH));
        }
        if (jna_path == null && (jna_path = NetcdfLoader.nullify(System.getenv(ENV_JNAPATH))) != null) {
            System.setProperty(DFLAG_JNAPATH, jna_path);
        }
        if (jna_path == null) {
            DapLog.warn(String.format("Neither -D%s nor getenv(%s) is defined", DFLAG_JNAPATH, ENV_JNAPATH));
        }
        libName = lib_name;
        jnaPath = jna_path;
    }

    public static synchronized DapNetcdf load() throws IOException {
        if (nc4 == null) {
            if (jnaPath == null) {
                NetcdfLoader.setLibraryAndPath(null, null);
            }
            try {
                nc4 = (DapNetcdf)Native.loadLibrary((String)libName, DapNetcdf.class);
                nc4 = (DapNetcdf)Native.synchronizedLibrary((Library)nc4);
                String message = String.format("NetCDF-4 C library loaded (jna_path='%s', libname='%s').", jnaPath, libName);
                String vermsg = String.format("Netcdf nc_inq_libvers='%s' isProtected=%s%n", nc4.nc_inq_libvers(), Native.isProtected());
                DapLog.info(message);
                DapLog.info(vermsg);
            }
            catch (Throwable t) {
                String message = String.format("NetCDF-4 C library not present (jna_path='%s', libname='%s'); %s.", jnaPath, libName, t.getMessage());
                DapLog.info(message);
                DapLog.info(t.getMessage());
                nc4 = null;
                throw new IOException(message);
            }
        }
        return nc4;
    }

    public static synchronized boolean isClibraryPresent() {
        return nc4 != null;
    }

    protected static String nullify(String s) {
        if (s != null && s.length() == 0) {
            s = null;
        }
        return s;
    }
}

