/*
 * Decompiled with CFR 0.152.
 */
package dap4.dap4lib;

import dap4.core.ce.CEConstraint;
import dap4.core.data.DSP;
import dap4.core.data.DataCursor;
import dap4.core.dmr.DapDataset;
import dap4.core.dmr.DapEnumConst;
import dap4.core.dmr.DapEnumeration;
import dap4.core.dmr.DapNode;
import dap4.core.dmr.DapSequence;
import dap4.core.dmr.DapStructure;
import dap4.core.dmr.DapType;
import dap4.core.dmr.DapVariable;
import dap4.core.dmr.TypeSort;
import dap4.core.util.Convert;
import dap4.core.util.CoreTypeFcns;
import dap4.core.util.DapException;
import dap4.core.util.DapUtil;
import dap4.core.util.Escape;
import dap4.core.util.IndentWriter;
import dap4.core.util.Index;
import dap4.core.util.Odometer;
import dap4.core.util.Slice;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.EnumSet;
import java.util.List;

public class DSPPrinter {
    protected static final int COLUMNS = 8;
    protected static final char LPAREN = '(';
    protected static final char RPAREN = ')';
    protected static final char LBRACE = '{';
    protected static final char RBRACE = '}';
    protected static final char LBRACKET = '[';
    protected static final char RBRACKET = ']';
    protected static final int NILFLAGS = 0;
    protected static final int PERLINE = 1;
    protected static final int NONAME = 2;
    protected static final int NONNIL = 4;
    protected PrintWriter writer = null;
    protected IndentWriter printer = null;
    protected DSP dsp = null;
    protected CEConstraint ce = null;
    protected EnumSet<Flags> flags = EnumSet.noneOf(Flags.class);

    protected DSPPrinter() {
    }

    public DSPPrinter(DSP dsp, Writer writer) {
        this(dsp, null, writer);
    }

    public DSPPrinter(DSP dsp, CEConstraint ce, Writer writer) {
        this.dsp = dsp;
        this.ce = ce;
        this.writer = new PrintWriter(writer);
        this.printer = new IndentWriter((Writer)this.writer);
    }

    public DSPPrinter flag(Flags flag) {
        this.flags.add(flag);
        return this;
    }

    public DSPPrinter flush() {
        this.printer.flush();
        return this;
    }

    public DSPPrinter close() {
        this.flush();
        return this;
    }

    public DSPPrinter print() throws DapException {
        DapDataset dmr = this.dsp.getDMR();
        if (this.ce == null) {
            this.ce = CEConstraint.getUniversal((DapDataset)dmr);
        }
        this.printer.setIndent(0);
        List topvars = dmr.getTopVariables();
        for (int i = 0; i < topvars.size(); ++i) {
            DapVariable top = (DapVariable)topvars.get(i);
            List slices = this.ce.getConstrainedSlices(top);
            if (!this.ce.references((DapNode)top)) continue;
            DataCursor data = this.dsp.getVariableData(top);
            this.printVariable(data, slices);
        }
        this.printer.eol();
        return this;
    }

    protected void printVariable(DataCursor data, List<Slice> slices) throws DapException {
        DapVariable dapv = (DapVariable)data.getTemplate();
        if (data.isScalar()) {
            assert (slices == Slice.SCALARSLICES);
            this.printScalar(data);
        } else {
            this.printArray(data, slices);
        }
    }

    protected void printScalar(DataCursor data) throws DapException {
        DapVariable dapv = (DapVariable)data.getTemplate();
        this.printer.marginPrint(dapv.getFQN() + " = ");
        switch (data.getScheme()) {
            case ATOMIC: {
                this.printAtomicInstance(data, Index.SCALAR);
                break;
            }
            case STRUCTARRAY: 
            case SEQARRAY: {
                DataCursor[] scalar = (DataCursor[])data.read(Index.SCALAR);
                assert (scalar.length == 1);
                data = scalar[0];
            }
            case STRUCTURE: 
            case SEQUENCE: 
            case RECORD: {
                this.printer.marginPrint("{");
                this.printer.eol();
                this.printer.indent();
                this.printCompoundInstance(data);
                this.printer.outdent();
                this.printer.marginPrint("}");
                this.printer.eol();
                break;
            }
            default: {
                throw new DapException("Unexpected data cursor type: " + data.getScheme());
            }
        }
    }

    protected void printArray(DataCursor data, List<Slice> slices) throws DapException {
        DapVariable dapv = (DapVariable)data.getTemplate();
        Odometer odom = Odometer.factory(slices);
        switch (data.getScheme()) {
            case ATOMIC: {
                if (DapUtil.isContiguous(slices)) {
                    this.printAtomicVector(data, slices, odom);
                    break;
                }
                while (odom.hasNext()) {
                    Index pos = odom.next();
                    String s = this.indicesToString(pos);
                    this.printer.marginPrint(dapv.getFQN() + s + " = ");
                    this.printAtomicInstance(data, pos);
                }
                break;
            }
            case STRUCTARRAY: 
            case SEQARRAY: {
                DapStructure ds = (DapStructure)((DapVariable)data.getTemplate()).getBaseType();
                DataCursor[] instances = (DataCursor[])data.read(slices);
                while (odom.hasNext()) {
                    Index pos = odom.next();
                    String s = this.indicesToString(pos);
                    this.printer.marginPrint(ds.getFQN() + s + " = {");
                    this.printer.eol();
                    this.printer.indent();
                    this.printCompoundInstance(instances[(int)pos.index()]);
                    this.printer.outdent();
                    this.printer.marginPrint("}");
                    this.printer.eol();
                }
                break;
            }
            default: {
                throw new DapException("Unexpected data cursor type: " + data.getScheme());
            }
        }
    }

    protected void printAtomicVector(DataCursor data, List<Slice> slices, Odometer odom) throws DapException {
        assert (data.getScheme() == DataCursor.Scheme.ATOMIC);
        Object values = data.read(slices);
        DapVariable atom = (DapVariable)data.getTemplate();
        String name = atom.getFQN();
        if (Array.getLength(values) == 0) {
            this.printer.marginPrint(name + " = <empty>");
            this.printer.eol();
        } else {
            int i = 0;
            while (odom.hasNext()) {
                Index index = odom.next();
                String prefix = odom.rank() == 0 ? name : name + this.indicesToString(index);
                this.printer.marginPrint(prefix + " = ");
                this.printer.print(this.valueString(values, i, atom.getBaseType()));
                this.printer.eol();
                ++i;
            }
        }
    }

    protected void printAtomicInstance(DataCursor datav, Index pos) throws DapException {
        assert (datav.getScheme() == DataCursor.Scheme.ATOMIC);
        Object value = datav.read(pos);
        DapVariable av = (DapVariable)datav.getTemplate();
        this.printer.print(this.valueString(value, 0L, av.getBaseType()));
        this.printer.eol();
    }

    protected void printCompoundInstance(DataCursor datav) throws DapException {
        DapStructure dstruct = (DapStructure)((DapVariable)datav.getTemplate()).getBaseType();
        switch (datav.getScheme()) {
            case STRUCTURE: 
            case RECORD: {
                List dfields = dstruct.getFields();
                for (int f = 0; f < dfields.size(); ++f) {
                    DapVariable field = (DapVariable)dfields.get(f);
                    List fieldslices = this.ce.getConstrainedSlices(field);
                    DataCursor fdata = datav.readField(f);
                    this.printVariable(fdata, fieldslices);
                }
                break;
            }
            case SEQUENCE: {
                DapSequence dseq = (DapSequence)dstruct;
                long count = datav.getRecordCount();
                for (long r = 0L; r < count; ++r) {
                    DataCursor dr = datav.readRecord(r);
                    this.printer.marginPrint("[");
                    this.printer.eol();
                    this.printer.indent();
                    this.printCompoundInstance(dr);
                    this.printer.outdent();
                    this.printer.marginPrint("]");
                }
                break;
            }
            default: {
                throw new DapException("Unexpected data cursor scheme:" + datav.getScheme());
            }
        }
    }

    protected String indicesToString(Index indices) throws DapException {
        StringBuilder buf = new StringBuilder();
        if (indices != null && indices.getRank() > 0) {
            for (int i = 0; i < indices.getRank(); ++i) {
                buf.append(i == 0 ? Character.valueOf('[') : ",");
                buf.append(String.format("%d", indices.get(i)));
            }
            buf.append(']');
        }
        return buf.toString();
    }

    protected String valueString(Object vector, long pos, DapType basetype) throws DapException {
        if (vector == null) {
            return "null";
        }
        TypeSort atype = basetype.getTypeSort();
        boolean unsigned = atype.isUnsigned();
        int ipos = (int)pos;
        switch (atype) {
            case Int8: 
            case UInt8: {
                long lvalue = ((byte[])vector)[ipos];
                if (unsigned) {
                    lvalue &= 0xFFL;
                }
                return String.format("%d", lvalue);
            }
            case Int16: 
            case UInt16: {
                long lvalue = ((short[])vector)[ipos];
                if (unsigned) {
                    lvalue &= 0xFFFFL;
                }
                return String.format("%d", lvalue);
            }
            case Int32: 
            case UInt32: {
                long lvalue = ((int[])vector)[ipos];
                if (unsigned) {
                    lvalue &= 0xFFFFFFFFL;
                }
                return String.format("%d", lvalue);
            }
            case Int64: 
            case UInt64: {
                long lvalue = ((long[])vector)[ipos];
                if (unsigned) {
                    BigInteger b = BigInteger.valueOf(lvalue);
                    b = b.and(DapUtil.BIG_UMASK64);
                    return b.toString();
                }
                return String.format("%d", lvalue);
            }
            case Float32: {
                return String.format("%f", Float.valueOf(((float[])vector)[ipos]));
            }
            case Float64: {
                return String.format("%f", ((double[])vector)[ipos]);
            }
            case Char: {
                return String.format("'%c'", Character.valueOf(((char[])vector)[ipos]));
            }
            case String: 
            case URL: {
                String s = ((String[])vector)[ipos];
                if (this.flags.contains((Object)Flags.CONTROLCHAR)) {
                    s = s.replace("\r", "\\r");
                    s = s.replace("\n", "\\n");
                    s = s.replace("\t", "\\t");
                }
                return "\"" + s + "\"";
            }
            case Opaque: {
                ByteBuffer opaque = ((ByteBuffer[])vector)[ipos];
                StringBuilder buf = new StringBuilder();
                buf.append("0x");
                for (int i = 0; i < opaque.limit(); ++i) {
                    byte b = opaque.get(i);
                    char c = DSPPrinter.hexchar(b >> 4 & 0xF);
                    buf.append(c);
                    c = DSPPrinter.hexchar(b & 0xF);
                    buf.append(c);
                }
                return buf.toString();
            }
            case Enum: {
                DapEnumeration de = (DapEnumeration)basetype;
                Object newvec = CoreTypeFcns.createVector((TypeSort)de.getBaseType().getTypeSort(), (long)1L);
                Object v = Array.get(vector, ipos);
                Array.set(newvec, 0, v);
                long[] lv = (long[])Convert.convert((DapType)DapType.INT64, (DapType)de, (Object)newvec);
                DapEnumConst dec = de.lookup(lv[0]);
                return dec.getShortName();
            }
        }
        throw new DapException("Unknown type: " + basetype);
    }

    protected static char hexchar(int i) {
        return "0123456789ABCDEF".charAt(i & 0xF);
    }

    protected static String getPrintValue(Object value) {
        if (value instanceof String) {
            return Escape.entityEscape((String)((String)value), null);
        }
        return value.toString();
    }

    public static enum Flags {
        CONTROLCHAR;

    }
}

