/*
 * Decompiled with CFR 0.152.
 */
package dap4.dap4lib.netcdf;

import com.sun.jna.Native;
import dap4.core.data.DataCursor;
import dap4.core.dmr.DapEnumeration;
import dap4.core.dmr.DapNode;
import dap4.core.dmr.DapSequence;
import dap4.core.dmr.DapStructure;
import dap4.core.dmr.DapType;
import dap4.core.dmr.DapVariable;
import dap4.core.dmr.TypeSort;
import dap4.core.util.DapException;
import dap4.core.util.DapSort;
import dap4.core.util.DapUtil;
import dap4.core.util.Index;
import dap4.core.util.Odometer;
import dap4.core.util.Slice;
import dap4.dap4lib.AbstractCursor;
import dap4.dap4lib.LibTypeFcns;
import dap4.dap4lib.netcdf.Nc4DSP;
import dap4.dap4lib.netcdf.Nc4Notes;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import ucar.nc2.jni.netcdf.Nc4prototypes;
import ucar.nc2.jni.netcdf.SizeT;

public class Nc4Cursor
extends AbstractCursor {
    public static boolean DEBUG = false;
    private static final boolean transcodeStrings = Charset.defaultCharset() != StandardCharsets.UTF_8;
    protected Nc4DSP.Nc4Pointer memory = null;

    public Nc4Cursor(DataCursor.Scheme scheme, Nc4DSP dsp, DapVariable template, Nc4Cursor container) throws DapException {
        super(scheme, dsp, (DapNode)template, container);
        if (DEBUG) {
            this.debug();
        }
    }

    public Nc4Cursor(Nc4Cursor c) {
        super(c);
        assert (false);
        this.memory = c.getMemory();
    }

    @Override
    public Object read(Index index) throws DapException {
        return this.read(DapUtil.indexToSlices((Index)index));
    }

    @Override
    public Object read(List<Slice> slices) throws DapException {
        switch (this.scheme) {
            case ATOMIC: {
                return this.readAtomic(slices);
            }
            case STRUCTURE: 
            case SEQUENCE: {
                if (((DapVariable)this.getTemplate()).getRank() > 0 || DapUtil.isScalarSlices(slices)) {
                    throw new DapException("Cannot slice a scalar variable");
                }
                return this;
            }
            case STRUCTARRAY: {
                Odometer odom = Odometer.factory(slices);
                DataCursor[] instances = new DataCursor[(int)odom.totalSize()];
                int i = 0;
                while (odom.hasNext()) {
                    instances[i] = this.readStructure(odom.next());
                    ++i;
                }
                return instances;
            }
            case SEQARRAY: {
                Odometer odom = Odometer.factory(slices);
                DataCursor[] instances = new DataCursor[(int)odom.totalSize()];
                int i = 0;
                while (odom.hasNext()) {
                    instances[i] = this.readSequence(odom.next());
                    ++i;
                }
                return instances;
            }
        }
        throw new DapException("Attempt to slice a scalar object");
    }

    @Override
    public Nc4Cursor readField(int findex) throws DapException {
        DapVariable template = (DapVariable)this.getTemplate();
        DapStructure struct = (DapStructure)template.getBaseType();
        if (findex < 0 || findex >= struct.getFields().size()) {
            throw new DapException("Field index out of range: " + findex);
        }
        DapVariable field = struct.getField(findex);
        Nc4Notes.VarNotes fi = (Nc4Notes.VarNotes)((Nc4DSP)this.getDSP()).find((DapNode)field);
        Nc4Notes.TypeNotes ti = fi.getBaseType();
        Nc4Cursor cursor = new Nc4Cursor(Nc4Cursor.schemeFor(field), (Nc4DSP)this.dsp, field, this);
        Nc4DSP.Nc4Pointer mem = this.getMemory();
        if (this.scheme != DataCursor.Scheme.STRUCTURE) {
            if (this.getScheme() == DataCursor.Scheme.RECORD) {
                if (findex != 0) {
                    throw new DapException("Field index out of range: " + findex);
                }
            } else {
                throw new DapException("readfield expected STRUCTURE or RECORD cursor");
            }
        }
        cursor.setMemory(mem);
        return cursor;
    }

    @Override
    public long getRecordCount() {
        assert (this.scheme == DataCursor.Scheme.SEQUENCE);
        if (this.recordcount < 0L) {
            throw new IllegalStateException("Sequence has no record count");
        }
        return this.recordcount;
    }

    @Override
    public Nc4Cursor readRecord(long recno) throws DapException {
        assert (this.scheme == DataCursor.Scheme.SEQUENCE);
        DapVariable template = (DapVariable)this.getTemplate();
        if (recno < 0L || recno >= this.getRecordCount()) {
            throw new ArrayIndexOutOfBoundsException("Illegal record id: " + recno);
        }
        Nc4Notes.VarNotes vn = (Nc4Notes.VarNotes)((Nc4DSP)this.getDSP()).find((DapNode)template);
        Nc4Notes.TypeNotes ti = vn.getBaseType();
        assert (ti.isVlen());
        DapStructure ds = (DapStructure)template.getBaseType();
        DapVariable field = ds.getField(0);
        DapType ftype = field.getBaseType();
        Nc4Notes.TypeNotes fnotes = (Nc4Notes.TypeNotes)((Nc4DSP)this.getDSP()).find((DapNode)ftype);
        Nc4DSP.Nc4Pointer record = this.getMemory();
        long recsize = this.getElementSize(fnotes);
        record = record.share(recno * recsize, recsize);
        Nc4Cursor rec = new Nc4Cursor(DataCursor.Scheme.RECORD, (Nc4DSP)this.getDSP(), (DapVariable)this.getTemplate(), this);
        rec.setMemory(record).setRecordIndex(recno);
        return rec;
    }

    @Override
    public Index getIndex() throws DapException {
        if (this.scheme != DataCursor.Scheme.STRUCTURE && this.scheme != DataCursor.Scheme.SEQUENCE) {
            throw new DapException("Not a Sequence|Structure instance");
        }
        return this.arrayindex;
    }

    protected Object readAtomic(List<Slice> slices) throws DapException {
        if (slices == null) {
            throw new DapException("DataCursor.read: null set of slices");
        }
        assert (this.scheme == DataCursor.Scheme.ATOMIC);
        DapVariable atomvar = (DapVariable)this.getTemplate();
        int rank = atomvar.getRank();
        assert (slices != null && (rank == 0 && slices.size() == 1 || slices.size() == rank));
        Nc4Notes.Notes n = ((Nc4DSP)this.dsp).find(this.template);
        Object result = null;
        long count = DapUtil.sliceProduct(slices);
        Nc4Notes.VarNotes vn = (Nc4Notes.VarNotes)n;
        Nc4Notes.TypeNotes ti = vn.getBaseType();
        if (this.getContainer() == null) {
            result = rank == 0 ? this.readAtomicScalar(vn, ti) : this.readAtomicVector(vn, ti, count, slices);
        } else {
            long elemsize = ti.get().getSize();
            assert (this.container != null);
            long trueoffset = this.computeTrueOffset(this);
            Nc4DSP.Nc4Pointer varmem = this.getMemory();
            Nc4DSP.Nc4Pointer mem = varmem.share(trueoffset, count * elemsize);
            result = this.getatomicdata(ti.getType(), count, elemsize, mem);
        }
        return result;
    }

    protected Object readAtomicScalar(Nc4Notes.VarNotes vi, Nc4Notes.TypeNotes ti) throws DapException {
        DapVariable atomvar = (DapVariable)this.getTemplate();
        Nc4prototypes nc4 = ((Nc4DSP)this.dsp).getJNI();
        DapType basetype = ti.getType();
        Object result = null;
        if (basetype.isFixedSize()) {
            long memsize = ti.get().getSize();
            Nc4DSP.Nc4Pointer mem = Nc4DSP.Nc4Pointer.allocate(memsize);
            int ret = nc4.nc_get_var(vi.gid, vi.id, mem.p);
            Nc4Cursor.readcheck(nc4, ret);
            this.setMemory(mem);
            result = this.getatomicdata(ti.getType(), 1L, mem.size, mem);
        } else if (basetype.isStringType()) {
            String[] s = new String[1];
            int ret = nc4.nc_get_var_string(vi.gid, vi.id, s);
            Nc4Cursor.readcheck(nc4, ret);
            if (transcodeStrings) {
                s = this.transcodeString(s);
            }
            result = s;
        } else if (basetype.isOpaqueType()) {
            Nc4DSP.Nc4Pointer mem = Nc4DSP.Nc4Pointer.allocate(ti.getSize());
            int ret = nc4.nc_get_var(vi.gid, vi.id, mem.p);
            Nc4Cursor.readcheck(nc4, ret);
            this.setMemory(mem);
            ByteBuffer[] buf = new ByteBuffer[]{mem.p.getByteBuffer(0L, ti.getSize())};
            result = buf;
        } else {
            throw new DapException("Unexpected atomic type: " + basetype);
        }
        return result;
    }

    protected Object readAtomicVector(Nc4Notes.VarNotes vi, Nc4Notes.TypeNotes ti, long count, List<Slice> slices) throws DapException {
        DapVariable atomvar = (DapVariable)this.getTemplate();
        DapType basetype = ti.getType();
        if (atomvar.getCount() == 0L) {
            return LibTypeFcns.newVector(basetype, 0L);
        }
        int rank = atomvar.getRank();
        List dimset = atomvar.getDimensions();
        Odometer odom = Odometer.factory(slices, (List)dimset);
        List subodoms = odom.getSubOdometers();
        long totalsize = 0L;
        for (int i = 0; i < subodoms.size(); ++i) {
            Odometer ithodom = (Odometer)subodoms.get(i);
            totalsize += ithodom.totalSize();
        }
        Nc4prototypes nc4 = ((Nc4DSP)this.dsp).getJNI();
        SizeT[] startp = new SizeT[rank];
        SizeT[] countp = new SizeT[rank];
        SizeT[] stridep = new SizeT[rank];
        Object result = LibTypeFcns.newVector(basetype, totalsize);
        int pos = 0;
        for (int i = 0; i < subodoms.size(); ++i) {
            Object partialresult;
            int ret;
            Nc4DSP.Nc4Pointer mem;
            long memsize;
            Odometer ithodom = (Odometer)subodoms.get(i);
            long edgecount = Nc4Cursor.odomToEdges(ithodom, startp, countp, stridep);
            if (basetype.isFixedSize()) {
                long elemsize = ti.getSize();
                memsize = edgecount * elemsize;
                mem = Nc4DSP.Nc4Pointer.allocate(memsize);
                ret = nc4.nc_get_vars(vi.gid, vi.id, startp, countp, stridep, mem.p);
                Nc4Cursor.readcheck(nc4, ret);
                partialresult = this.getatomicdata(ti.getType(), edgecount, elemsize, mem);
            } else if (basetype.isStringType()) {
                String[] ss = new String[(int)edgecount];
                ret = nc4.nc_get_vars_string(vi.gid, vi.id, startp, countp, stridep, ss);
                Nc4Cursor.readcheck(nc4, ret);
                if (transcodeStrings) {
                    ss = this.transcodeString(ss);
                }
                partialresult = ss;
            } else if (basetype.isOpaqueType()) {
                long elemsize = ti.getSize();
                edgecount = Nc4Cursor.odomToEdges(ithodom, startp, countp, stridep);
                memsize = edgecount * elemsize;
                mem = Nc4DSP.Nc4Pointer.allocate(memsize);
                ret = nc4.nc_get_vars(vi.gid, vi.id, startp, countp, stridep, mem.p);
                Nc4Cursor.readcheck(nc4, ret);
                partialresult = new ByteBuffer[(int)edgecount];
                int ec = 0;
                while ((long)ec < edgecount) {
                    byte[] buf = mem.p.getByteArray((long)ec * ti.getSize(), (int)ti.getSize());
                    ((ByteBuffer[])partialresult)[ec] = ByteBuffer.wrap(buf);
                    ++ec;
                }
            } else {
                throw new DapException("Unexpected atomic type: " + basetype);
            }
            int len = Array.getLength(partialresult);
            System.arraycopy(partialresult, 0, result, pos, len);
            pos += len;
        }
        return result;
    }

    protected Nc4Cursor readStructure(Index index) throws DapException {
        Nc4DSP.Nc4Pointer mem;
        assert (index != null);
        assert (this.scheme == DataCursor.Scheme.STRUCTARRAY);
        DapVariable template = (DapVariable)this.getTemplate();
        Nc4Notes.VarNotes vi = (Nc4Notes.VarNotes)((Nc4DSP)this.dsp).find((DapNode)template);
        Nc4Notes.TypeNotes ti = vi.basetype;
        Nc4Cursor cursor = null;
        if (template.isTopLevel()) {
            mem = Nc4DSP.Nc4Pointer.allocate(ti.getSize());
            Nc4prototypes nc4 = ((Nc4DSP)this.dsp).getJNI();
            if (index.getRank() == 0) {
                int ret = nc4.nc_get_var(vi.gid, vi.id, mem.p);
                Nc4Cursor.readcheck(nc4, ret);
            } else {
                SizeT[] sizes = Nc4Cursor.indexToSizes(index);
                int ret = nc4.nc_get_var1(vi.gid, vi.id, sizes, mem.p);
                Nc4Cursor.readcheck(nc4, ret);
            }
            cursor = new Nc4Cursor(DataCursor.Scheme.STRUCTURE, (Nc4DSP)this.dsp, template, this);
        } else {
            long pos = index.index();
            if (pos < 0L || pos >= template.getCount()) {
                throw new IndexOutOfBoundsException("read: " + index);
            }
            cursor = new Nc4Cursor(DataCursor.Scheme.STRUCTURE, (Nc4DSP)this.dsp, template, this);
            mem = ((Nc4Cursor)this.getContainer()).getMemory().share(pos * ti.getSize(), ti.getSize());
        }
        cursor.setIndex(index);
        cursor.setMemory(mem);
        return cursor;
    }

    protected Nc4Cursor readSequence(Index index) throws DapException {
        assert (index != null);
        assert (this.scheme == DataCursor.Scheme.SEQARRAY);
        DapVariable template = (DapVariable)this.getTemplate();
        Nc4Notes.VarNotes vi = (Nc4Notes.VarNotes)((Nc4DSP)this.dsp).find((DapNode)template);
        Nc4Notes.TypeNotes ti = vi.basetype;
        Nc4Cursor cursor = null;
        Nc4prototypes.Vlen_t[] vlen = new Nc4prototypes.Vlen_t[1];
        if (template.isTopLevel()) {
            Nc4prototypes nc4 = ((Nc4DSP)this.dsp).getJNI();
            SizeT[] extents = Nc4Cursor.indexToSizes(index);
            int ret = nc4.nc_get_var1(vi.gid, vi.id, extents, vlen);
            Nc4Cursor.readcheck(nc4, ret);
        } else {
            long pos = index.index();
            if (pos < 0L || pos >= template.getCount()) {
                throw new IndexOutOfBoundsException("read: " + index);
            }
            Nc4DSP.Nc4Pointer pp = this.getMemory();
            int vlensize = Nc4prototypes.Vlen_t.VLENSIZE;
            pp = pp.share(pos * (long)vlensize, vlensize);
            vlen[0] = new Nc4prototypes.Vlen_t(pp.p);
            vlen[0].read();
        }
        cursor = new Nc4Cursor(DataCursor.Scheme.SEQUENCE, (Nc4DSP)this.dsp, template, this);
        cursor.setRecordCount(vlen[0].len);
        long memsize = ti.getSize() * cursor.getRecordCount();
        Nc4DSP.Nc4Pointer mem = new Nc4DSP.Nc4Pointer(vlen[0].p, memsize);
        cursor.setMemory(mem);
        cursor.setIndex(index);
        return cursor;
    }

    public long getOffset() {
        DapVariable dv = (DapVariable)this.getTemplate();
        Nc4Notes.Notes n = ((Nc4DSP)this.dsp).find((DapNode)dv);
        return n.getOffset();
    }

    public long getElementSize() {
        DapVariable dv = (DapVariable)this.getTemplate();
        Nc4Notes.Notes n = ((Nc4DSP)this.dsp).find((DapNode)dv);
        return n.getSize();
    }

    public Nc4DSP.Nc4Pointer getMemory() {
        return this.memory;
    }

    public Nc4Cursor setMemory(Nc4DSP.Nc4Pointer p) {
        this.memory = p;
        return this;
    }

    protected long getElementSize(Nc4Notes.TypeNotes ti) {
        DapType type = ti.getType();
        switch (type.getTypeSort()) {
            case Structure: 
            case Sequence: {
                return ti.getSize();
            }
            case String: 
            case URL: {
                return Native.POINTER_SIZE;
            }
            case Enum: {
                return this.getElementSize((Nc4Notes.TypeNotes)((Nc4DSP)this.getDSP()).find(ti.enumbase, Nc4Notes.NoteSort.TYPE));
            }
            case Opaque: {
                return ti.getSize();
            }
        }
        return type.getSize();
    }

    protected Object getatomicdata(DapType basetype, long lcount, long elemsize, Nc4DSP.Nc4Pointer mem) {
        Object result = null;
        TypeSort sort = basetype.getTypeSort();
        int icount = (int)lcount;
        switch (sort) {
            case Char: {
                byte[] bresult = mem.p.getByteArray(0L, icount);
                char[] cresult = new char[bresult.length];
                for (int i = 0; i < icount; ++i) {
                    int ascii = bresult[i];
                    cresult[i] = (char)(ascii &= 0x7F);
                }
                result = cresult;
                break;
            }
            case UInt8: 
            case Int8: {
                result = mem.p.getByteArray(0L, icount);
                break;
            }
            case Int16: 
            case UInt16: {
                result = mem.p.getShortArray(0L, icount);
                break;
            }
            case Int32: 
            case UInt32: {
                result = mem.p.getIntArray(0L, icount);
                break;
            }
            case Int64: 
            case UInt64: {
                result = mem.p.getLongArray(0L, icount);
                break;
            }
            case Float32: {
                result = mem.p.getFloatArray(0L, icount);
                break;
            }
            case Float64: {
                result = mem.p.getDoubleArray(0L, icount);
                break;
            }
            case String: 
            case URL: {
                result = mem.p.getStringArray(0L, icount);
                break;
            }
            case Opaque: {
                ByteBuffer[] ops;
                result = ops = new ByteBuffer[icount];
                for (int i = 0; i < icount; ++i) {
                    ops[i] = mem.p.getByteBuffer((long)i * elemsize, elemsize);
                }
                break;
            }
            case Enum: {
                DapEnumeration de = (DapEnumeration)basetype;
                result = this.getatomicdata(de.getBaseType(), lcount, elemsize, mem);
            }
        }
        return result;
    }

    static long odomToEdges(Odometer odom, SizeT[] startp, SizeT[] countp, SizeT[] stridep) {
        assert (!odom.isMulti());
        int rank = odom.rank();
        List slices = odom.getSlices();
        for (int i = 0; i < rank; ++i) {
            Slice slice = (Slice)slices.get(i);
            startp[i] = new SizeT(slice.getFirst());
            countp[i] = new SizeT(slice.getCount());
            stridep[i] = new SizeT(slice.getStride());
        }
        return DapUtil.sliceProduct((List)slices);
    }

    public static void errcheck(Nc4prototypes nc4, int ret) throws DapException {
        if (ret != 0) {
            String msg = String.format("Netcdf: errno=%d; %s", ret, nc4.nc_strerror(ret));
            throw new DapException(msg);
        }
    }

    public static void readcheck(Nc4prototypes nc4, int ret) throws DapException {
        try {
            Nc4Cursor.errcheck(nc4, ret);
        }
        catch (DapException de) {
            throw new DapException((Throwable)de);
        }
    }

    static SizeT[] indexToSizes(Index index) {
        SizeT[] sizes = new SizeT[index.getRank()];
        for (int i = 0; i < sizes.length; ++i) {
            sizes[i] = new SizeT(index.get(i));
        }
        return sizes;
    }

    long computeTrueOffset(Nc4Cursor f) throws DapException {
        List<Nc4Cursor> path = Nc4Cursor.getCursorPath(f);
        long totaloffset = 0L;
        for (int i = 1; i < path.size() - 1; ++i) {
            Nc4Cursor current = path.get(i);
            DapVariable template = (DapVariable)current.getTemplate();
            Nc4Notes.VarNotes vi = (Nc4Notes.VarNotes)((Nc4DSP)this.getDSP()).find((DapNode)template);
            long size = vi.getSize();
            long offset = current.getOffset();
            long pos = 0L;
            switch (current.getScheme()) {
                case STRUCTURE: 
                case SEQUENCE: {
                    pos = current.getIndex().index();
                    break;
                }
                case RECORD: {
                    pos = 0L;
                    break;
                }
                default: {
                    throw new DapException("Illegal cursor type: " + current.getScheme());
                }
            }
            long delta = size * pos + offset;
            totaloffset += delta;
        }
        assert (path.get(path.size() - 1) == f);
        return totaloffset += f.getOffset();
    }

    static List<Nc4Cursor> getCursorPath(Nc4Cursor cursor) {
        ArrayList<Nc4Cursor> path = new ArrayList<Nc4Cursor>();
        while (true) {
            if (!cursor.getScheme().isCompoundArray()) {
                path.add(0, cursor);
            }
            if (cursor.getScheme() == DataCursor.Scheme.SEQUENCE) break;
            Nc4Cursor next = (Nc4Cursor)cursor.getContainer();
            if (next == null) {
                assert (cursor.getTemplate().isTopLevel());
                break;
            }
            assert (next.getTemplate().getSort() == DapSort.VARIABLE);
            cursor = next;
        }
        return path;
    }

    static Nc4DSP.Nc4Pointer getVarMemory(Nc4Cursor cursor) {
        while (cursor.getContainer() != null) {
            cursor = (Nc4Cursor)cursor.getContainer();
        }
        return cursor.getMemory();
    }

    public Nc4Notes.TypeNotes getVlenType(DapVariable v) {
        DapType t = v.getBaseType();
        if (t.getSort() != DapSort.SEQUENCE || ((DapSequence)t).getFields().size() != 1) {
            throw new IllegalArgumentException(t.getFQN());
        }
        DapSequence ds = (DapSequence)t;
        DapVariable f0 = ds.getField(0);
        DapType f0type = f0.getBaseType();
        return (Nc4Notes.TypeNotes)((Nc4DSP)this.dsp).find((DapNode)f0type);
    }

    private String[] transcodeString(String[] systemStrings) {
        return (String[])Arrays.stream(systemStrings).map(systemString -> {
            byte[] byteArray = systemString.getBytes(Charset.defaultCharset());
            return new String(byteArray, StandardCharsets.UTF_8);
        }).toArray(String[]::new);
    }

    protected void debug() {
        System.err.printf("CURSOR: %s%n", this.toString());
    }
}

