/*
 * Decompiled with CFR 0.152.
 */
package dap4.dap4lib.netcdf;

import com.sun.jna.Native;
import com.sun.jna.ptr.IntByReference;
import dap4.core.dmr.DMRFactory;
import dap4.core.dmr.DapAttribute;
import dap4.core.dmr.DapDataset;
import dap4.core.dmr.DapDimension;
import dap4.core.dmr.DapEnumConst;
import dap4.core.dmr.DapEnumeration;
import dap4.core.dmr.DapGroup;
import dap4.core.dmr.DapNode;
import dap4.core.dmr.DapSequence;
import dap4.core.dmr.DapStructure;
import dap4.core.dmr.DapType;
import dap4.core.dmr.DapVariable;
import dap4.core.dmr.TypeSort;
import dap4.core.util.Convert;
import dap4.core.util.DapContext;
import dap4.core.util.DapException;
import dap4.core.util.DapUtil;
import dap4.dap4lib.netcdf.Nc4DSP;
import dap4.dap4lib.netcdf.Nc4Notes;
import ucar.nc2.ffi.netcdf.NetcdfClibrary;
import ucar.nc2.jni.netcdf.Nc4prototypes;
import ucar.nc2.jni.netcdf.SizeTByReference;

public class Nc4DMRCompiler {
    public static final boolean DEBUG = false;
    public static final String UCARTAGVLEN = "_edu.ucar.isvlen";
    public static final String UCARTAGOPAQUE = "_edu.ucar.opaque.size";
    static final int NC_FALSE = 0;
    static final int NC_TRUE = 1;
    public static final int NC_GRPNULL = 0;
    public static final int NC_IDNULL = -1;
    public static final int NC_NOERR = 0;
    static int NC_INT_BYTES = 4;
    static int NC_LONG_BYTES = Native.LONG_SIZE;
    static int NC_POINTER_BYTES = Native.POINTER_SIZE;
    static int NC_SIZET_BYTES = Native.SIZE_T_SIZE;
    protected static Nc4prototypes nc4 = NetcdfClibrary.getForeignFunctionInterface();
    protected boolean trace = false;
    protected boolean closed = false;
    protected int ncid = -1;
    protected int format = 0;
    protected int mode = 0;
    protected String path = null;
    protected String pathprefix = null;
    protected DMRFactory factory = null;
    protected Nc4DSP dsp = null;
    protected DapDataset dmr = null;

    public static boolean dspMatch(String path, DapContext context) {
        for (String s : Nc4DSP.EXTENSIONS) {
            if (!path.endsWith(s)) continue;
            return true;
        }
        return false;
    }

    public Nc4DMRCompiler(Nc4DSP dsp, int ncid, DMRFactory factory) throws DapException {
        this.dsp = dsp;
        this.path = dsp.getLocation();
        this.ncid = ncid;
        this.factory = factory;
    }

    public DapDataset compile() throws DapException {
        this.buildrootgroup(this.ncid);
        if (this.dmr != null) {
            this.dmr.finish();
        }
        return this.dmr;
    }

    protected void buildrootgroup(int ncid) throws DapException {
        byte[] namep = new byte[257];
        int ret = nc4.nc_inq_grpname(ncid, namep);
        this.errcheck(ret);
        String[] pieces = DapUtil.canonicalpath((String)this.path).split("[/]");
        DapDataset g = this.factory.newDataset(pieces[pieces.length - 1]);
        Nc4Notes.GroupNotes gi = (Nc4Notes.GroupNotes)Nc4Notes.factory(Nc4Notes.NoteSort.GROUP, ncid, ncid, this.dsp);
        gi.set((DapNode)g);
        this.dsp.note(gi);
        this.dmr = g;
        this.fillgroup(ncid);
    }

    protected void fillgroup(int gid) throws DapException {
        int[] groupids;
        String[] gattnames;
        int[] varids;
        int[] dims = this.getDimensions(gid);
        int[] udims = this.getUnlimitedDimensions(gid);
        for (int dimid : dims) {
            this.builddim(gid, dimid, udims);
        }
        int[] typeids = this.getUserTypes(gid);
        for (int i = 0; i < typeids.length; ++i) {
            for (int j = 0; j < i; ++j) {
                if (typeids[i] == typeids[j]) assert (false);
            }
        }
        for (int typeid : typeids) {
            this.buildusertype(gid, typeid);
        }
        for (int varid : varids = this.getVars(gid)) {
            this.buildvar(gid, varid);
        }
        for (String ga : gattnames = this.getAttributes(gid, -1)) {
            this.buildattr(gid, -1, ga);
        }
        for (int groupid : groupids = this.getGroups(gid)) {
            this.buildgroup(gid, groupid);
        }
    }

    protected void buildgroup(int parent, int gid) throws DapException {
        byte[] namep = new byte[257];
        int ret = nc4.nc_inq_grpname(gid, namep);
        this.errcheck(ret);
        DapGroup g = this.factory.newGroup(Nc4DSP.makeString(namep));
        Nc4Notes.GroupNotes gi = (Nc4Notes.GroupNotes)Nc4Notes.factory(Nc4Notes.NoteSort.GROUP, parent, gid, this.dsp);
        gi.set((DapNode)g);
        this.dsp.note(gi);
        Nc4Notes.GroupNotes gp = (Nc4Notes.GroupNotes)this.dsp.find(parent, Nc4Notes.NoteSort.GROUP);
        gp.get().addDecl((DapNode)g);
        this.fillgroup(gid);
    }

    protected void builddim(int gid, int did, int[] udims) throws DapException {
        int ret = 0;
        byte[] namep = new byte[257];
        SizeTByReference lenp = new SizeTByReference();
        ret = nc4.nc_inq_dim(gid, did, namep, lenp);
        this.errcheck(ret);
        String name = Nc4DSP.makeString(namep);
        int len = lenp.intValue();
        boolean isunlimited = this.contains(udims, did);
        DapDimension dim = this.factory.newDimension(name, lenp.longValue());
        dim.setUnlimited(isunlimited);
        Nc4Notes.DimNotes di = (Nc4Notes.DimNotes)Nc4Notes.factory(Nc4Notes.NoteSort.DIM, gid, did, this.dsp);
        di.set((DapNode)dim);
        this.dsp.note(di);
        Nc4Notes.GroupNotes gp = (Nc4Notes.GroupNotes)this.dsp.find(gid, Nc4Notes.NoteSort.GROUP);
        gp.get().addDecl((DapNode)dim);
        if (this.trace) {
            System.out.printf("Nc4DSP: dimension: %s size=%d%n", name, dim.getSize());
        }
    }

    protected void buildusertype(int gid, int tid) throws DapException {
        int ret = 0;
        byte[] namep = new byte[257];
        SizeTByReference lenp = new SizeTByReference();
        IntByReference basetypep = new IntByReference();
        IntByReference classp = new IntByReference();
        SizeTByReference nfieldsp = new SizeTByReference();
        ret = nc4.nc_inq_user_type(gid, tid, namep, lenp, basetypep, nfieldsp, classp);
        this.errcheck(ret);
        String name = Nc4DSP.makeString(namep);
        int basetype = basetypep.getValue();
        long len = lenp.longValue();
        long nfields = nfieldsp.longValue();
        Nc4Notes.TypeNotes ti = (Nc4Notes.TypeNotes)Nc4Notes.factory(Nc4Notes.NoteSort.TYPE, gid, tid, this.dsp);
        switch (classp.getValue()) {
            case 14: {
                this.buildopaquetype(ti, name, len);
                break;
            }
            case 15: {
                this.buildenumtype(ti, name, basetype);
                break;
            }
            case 16: {
                this.buildcompoundtype(ti, name, nfields, len);
                break;
            }
            case 13: {
                this.buildvlentype(ti, name, basetype, len);
                break;
            }
            default: {
                throw new DapException("Unknown class: " + classp.getValue());
            }
        }
    }

    protected void buildopaquetype(Nc4Notes.TypeNotes ti, String name, long len) throws DapException {
        ti.setOpaque(len);
        DapType dt = DapType.lookup((TypeSort)TypeSort.Opaque);
        ti.set((DapNode)dt);
        this.dsp.note(ti);
    }

    protected void buildenumtype(Nc4Notes.TypeNotes ti, String name, int basetype) throws DapException {
        SizeTByReference nmembersp = new SizeTByReference();
        SizeTByReference sizep = new SizeTByReference();
        byte[] namep = new byte[257];
        IntByReference basetypep = new IntByReference();
        IntByReference valuep = new IntByReference();
        Nc4Notes.TypeNotes base = (Nc4Notes.TypeNotes)this.dsp.find(basetype, Nc4Notes.NoteSort.TYPE);
        if (!this.isintegertype(base)) {
            throw new DapException("Enum base type must be integer type");
        }
        int ret = nc4.nc_inq_enum(ti.gid, ti.id, namep, basetypep, sizep, nmembersp);
        this.errcheck(ret);
        DapEnumeration de = this.factory.newEnumeration(name, DapType.lookup((TypeSort)base.getType().getTypeSort()));
        ti.set((DapNode)de);
        this.dsp.note(ti);
        ti.setEnumBaseType(basetype);
        ti.group().addDecl((DapNode)de);
        int nconsts = nmembersp.intValue();
        for (int i = 0; i < nconsts; ++i) {
            ret = nc4.nc_inq_enum_member(ti.gid, ti.id, i, namep, valuep);
            this.errcheck(ret);
            String ecname = Nc4DSP.makeString(namep);
            long ecval = valuep.getValue();
            DapEnumConst dec = this.factory.newEnumConst(ecname, ecval);
            de.addEnumConst(dec);
        }
    }

    protected void buildcompoundtype(Nc4Notes.TypeNotes ti, String name, long nfields, long len) throws DapException {
        DapStructure ds = this.factory.newStructure(name);
        ti.set((DapNode)ds);
        this.dsp.note(ti);
        ti.group().addDecl((DapNode)ds);
        int i = 0;
        while ((long)i < nfields) {
            this.buildfield(ti, i, ds);
            ++i;
        }
        SizeTByReference sizep = new SizeTByReference();
        SizeTByReference nfieldsp = new SizeTByReference();
        byte[] namep = new byte[257];
        int ret = nc4.nc_inq_compound(ti.gid, ti.id, namep, sizep, nfieldsp);
        this.errcheck(ret);
        ti.setSize(sizep.longValue());
        assert (len == sizep.longValue());
        assert (name.equals(Nc4DSP.makeString(namep)));
        ds.addXMLAttribute("_edu.ucar.orig.type", name);
    }

    protected void buildfield(Nc4Notes.TypeNotes ti, int fid, DapStructure container) throws DapException {
        byte[] namep = new byte[257];
        SizeTByReference offsetp = new SizeTByReference();
        IntByReference fieldtypep = new IntByReference();
        IntByReference ndimsp = new IntByReference();
        int ret = nc4.nc_inq_compound_field(ti.gid, ti.id, fid, namep, offsetp, fieldtypep, ndimsp, null);
        this.errcheck(ret);
        int fieldtype = fieldtypep.getValue();
        Nc4Notes.TypeNotes baset = (Nc4Notes.TypeNotes)this.dsp.find(fieldtype, Nc4Notes.NoteSort.TYPE);
        if (baset == null) {
            throw new DapException("Undefined field base type: " + fieldtype);
        }
        int[] dimsizes = this.getFieldDimsizes(ti.gid, ti.id, fid, ndimsp.getValue());
        Nc4Notes.VarNotes fieldnotes = this.makeField(ti, fid, Nc4DSP.makeString(namep), baset, offsetp.intValue(), dimsizes);
        assert (baset.getSize() > 0L);
    }

    protected Nc4Notes.VarNotes makeField(Nc4Notes.TypeNotes container, int fieldid, String name, Nc4Notes.TypeNotes baset, int offset, int[] dimsizes) throws DapException {
        DapStructure ds = (DapStructure)container.getType();
        DapVariable field = this.factory.newVariable(name, baset.getType());
        field.setParent((DapNode)ds);
        field.setFieldIndex(fieldid);
        Nc4Notes.VarNotes notes = (Nc4Notes.VarNotes)Nc4Notes.factory(Nc4Notes.NoteSort.VAR, container.gid, container.id, this.dsp);
        notes.setOffset(offset).setBaseType(baset).setContainer(container);
        notes.set((DapNode)field);
        this.dsp.note(notes);
        if (dimsizes.length > 0) {
            for (int i = 0; i < dimsizes.length; ++i) {
                DapDimension dim = this.factory.newDimension(null, (long)dimsizes[i]);
                field.addDimension(dim);
            }
        }
        ds.addField(field);
        return notes;
    }

    protected DapVariable buildvar(int gid, int vid) throws DapException {
        String[] attnames;
        DapVariable var;
        byte[] namep = new byte[257];
        IntByReference ndimsp = new IntByReference();
        IntByReference xtypep = new IntByReference();
        IntByReference nattsp = new IntByReference();
        int ret = nc4.nc_inq_var(gid, vid, namep, xtypep, ndimsp, null, nattsp);
        this.errcheck(ret);
        String name = Nc4DSP.makeString(namep);
        Nc4Notes.TypeNotes xtype = (Nc4Notes.TypeNotes)this.dsp.find(xtypep.getValue(), Nc4Notes.NoteSort.TYPE);
        if (xtype == null) {
            throw new DapException("Unknown type id: " + xtype.id);
        }
        switch (((DapType)xtype.node).getTypeSort()) {
            default: {
                var = this.factory.newVariable(name, xtype.getType());
                break;
            }
            case Enum: {
                var = this.factory.newVariable(name, xtype.getType());
                break;
            }
            case Structure: {
                DapStructure st = (DapStructure)xtype.get();
                var = this.factory.newVariable(name, xtype.getType());
                break;
            }
            case Sequence: {
                DapSequence seq = (DapSequence)xtype.get();
                var = this.factory.newVariable(name, xtype.getType());
            }
        }
        Nc4Notes.VarNotes vi = (Nc4Notes.VarNotes)Nc4Notes.factory(Nc4Notes.NoteSort.VAR, gid, vid, this.dsp);
        vi.set((DapNode)var);
        this.dsp.note(vi);
        vi.setBaseType(xtype);
        vi.group().addDecl((DapNode)var);
        int[] dimids = this.getVardims(gid, vid, ndimsp.getValue());
        for (int i = 0; i < dimids.length; ++i) {
            Nc4Notes.DimNotes di = (Nc4Notes.DimNotes)this.dsp.find(dimids[i], Nc4Notes.NoteSort.DIM);
            if (di == null) {
                throw new DapException("Undefined variable dimension id: " + dimids[i]);
            }
            var.addDimension(di.get());
        }
        if (xtype.isOpaque()) {
            var.addXMLAttribute(UCARTAGOPAQUE, Long.toString(xtype.getSize()));
        }
        for (String a : attnames = this.getAttributes(gid, vid)) {
            this.buildattr(gid, vid, a);
        }
        return var;
    }

    protected void buildvlentype(Nc4Notes.TypeNotes ti, String vname, int basetypeid, long len) throws DapException {
        DapSequence ds = this.factory.newSequence(vname);
        ti.set((DapNode)ds);
        this.dsp.note(ti);
        ti.group().addDecl((DapNode)ds);
        ti.markVlen();
        Nc4Notes.TypeNotes fieldtype = (Nc4Notes.TypeNotes)this.dsp.find(basetypeid, Nc4Notes.NoteSort.TYPE);
        if (fieldtype == null) {
            throw new DapException("Undefined vlen basetype: " + basetypeid);
        }
        Nc4Notes.VarNotes fieldnotes = this.makeField(ti, 0, vname, fieldtype, 0, new int[0]);
        ds.addXMLAttribute(UCARTAGVLEN, "1");
        ds.addXMLAttribute("_edu.ucar.orig.type", ds.getFQN());
        ti.setRecordSize(fieldtype.getSize());
        ti.setSize(Nc4prototypes.Vlen_t.VLENSIZE);
    }

    protected void buildattr(int gid, int vid, String name) throws DapException {
        boolean isglobal = vid == -1;
        IntByReference basetypep = new IntByReference();
        int ret = nc4.nc_inq_atttype(gid, vid, name, basetypep);
        this.errcheck(ret);
        int basetype = basetypep.getValue();
        Nc4Notes.TypeNotes base = (Nc4Notes.TypeNotes)this.dsp.find(basetype, Nc4Notes.NoteSort.TYPE);
        if (!this.islegalattrtype(base)) {
            throw new DapException("Non-atomic attribute types not supported: " + name);
        }
        SizeTByReference countp = new SizeTByReference();
        ret = nc4.nc_inq_attlen(gid, vid, name, countp);
        this.errcheck(ret);
        String[] values = this.getAttributeValues(gid, vid, name, base, countp.intValue());
        DapAttribute da = this.factory.newAttribute(name, base.getType());
        da.setValues(values);
        if (isglobal) {
            Nc4Notes.GroupNotes gi = (Nc4Notes.GroupNotes)this.dsp.find(gid, Nc4Notes.NoteSort.GROUP);
            gi.get().addAttribute(da);
        } else {
            Nc4Notes.VarNotes vi = this.dsp.findVar(gid, vid);
            vi.get().addAttribute(da);
        }
    }

    int[] getGroups(int gid) throws DapException {
        IntByReference ip = new IntByReference();
        int ret = nc4.nc_inq_grps(gid, ip, null);
        this.errcheck(ret);
        int n = ip.getValue();
        int[] grpids = null;
        if (n > 0) {
            grpids = new int[n];
            ret = nc4.nc_inq_grps(gid, ip, grpids);
            this.errcheck(ret);
        } else {
            grpids = new int[]{};
        }
        return grpids;
    }

    int[] getDimensions(int gid) throws DapException {
        IntByReference ip = new IntByReference();
        int ret = nc4.nc_inq_ndims(gid, ip);
        this.errcheck(ret);
        int n = ip.getValue();
        int[] dimids = new int[n];
        if (n > 0) {
            ret = nc4.nc_inq_dimids(gid, ip, dimids, 0);
            this.errcheck(ret);
        }
        return dimids;
    }

    int[] getUnlimitedDimensions(int gid) throws DapException {
        IntByReference ip = new IntByReference();
        int ret = nc4.nc_inq_unlimdims(gid, ip, null);
        this.errcheck(ret);
        int n = ip.getValue();
        int[] dimids = new int[n];
        if (n > 0) {
            ret = nc4.nc_inq_unlimdims(gid, ip, dimids);
            this.errcheck(ret);
        }
        return dimids;
    }

    int[] getUserTypes(int gid) throws DapException {
        IntByReference ip = new IntByReference();
        int ret = nc4.nc_inq_typeids(gid, ip, null);
        this.errcheck(ret);
        int n = ip.getValue();
        int[] typeids = new int[n];
        if (n > 0) {
            ret = nc4.nc_inq_typeids(gid, ip, typeids);
            this.errcheck(ret);
        }
        return typeids;
    }

    int[] getVars(int gid) throws DapException {
        IntByReference ip = new IntByReference();
        int ret = nc4.nc_inq_nvars(gid, ip);
        this.errcheck(ret);
        int n = ip.getValue();
        int[] ids = new int[n];
        if (n > 0) {
            ret = nc4.nc_inq_varids(gid, ip, ids);
            this.errcheck(ret);
        }
        return ids;
    }

    int[] getVardims(int gid, int vid, int ndims) throws DapException {
        int[] dimids = new int[ndims];
        if (ndims > 0) {
            byte[] namep = new byte[257];
            IntByReference ndimsp = new IntByReference();
            int ret = nc4.nc_inq_var(gid, vid, null, null, ndimsp, dimids, null);
            this.errcheck(ret);
        }
        return dimids;
    }

    int[] getFieldDimsizes(int gid, int tid, int fid, int ndims) throws DapException {
        int[] dimsizes = new int[ndims];
        if (ndims > 0) {
            IntByReference ndimsp = new IntByReference();
            int ret = nc4.nc_inq_compound_field(gid, tid, fid, null, null, null, ndimsp, dimsizes);
            this.errcheck(ret);
        }
        return dimsizes;
    }

    String[] getAttributes(int gid, int vid) throws DapException {
        int ret;
        boolean isglobal = vid == -1;
        IntByReference nattsp = new IntByReference();
        byte[] namep = new byte[257];
        IntByReference ndimsp = new IntByReference();
        IntByReference xtypep = new IntByReference();
        if (isglobal) {
            ret = nc4.nc_inq_natts(gid, nattsp);
            this.errcheck(ret);
        } else {
            ret = nc4.nc_inq_var(gid, vid, namep, xtypep, ndimsp, null, nattsp);
            this.errcheck(ret);
        }
        int n = nattsp.getValue();
        String[] names = new String[n];
        for (int i = 0; i < n; ++i) {
            ret = nc4.nc_inq_attname(gid, vid, i, namep);
            this.errcheck(ret);
            names[i] = Nc4DSP.makeString(namep);
        }
        return names;
    }

    String[] getAttributeValues(int gid, int vid, String name, Nc4Notes.TypeNotes tn, int count) throws DapException {
        if (!this.islegalattrtype(tn)) {
            throw new DapException("Unsupported attribute type: " + tn.getType().getShortName());
        }
        if (this.isenumtype(tn)) {
            tn = this.enumbasetype(tn);
        }
        Object vector = this.getRawAttributeValues(tn, count, gid, vid, name);
        DapType basetype = tn.getType();
        if (basetype.isCharType()) {
            byte[] data = (byte[])vector;
            String sdata = new String(data, DapUtil.UTF8);
            char[] cdata = sdata.toCharArray();
            count = cdata.length;
            vector = cdata;
        }
        String[] values = (String[])Convert.convert((DapType)DapType.STRING, (DapType)basetype, (Object)vector);
        return values;
    }

    Object getRawAttributeValues(Nc4Notes.TypeNotes base, int count, int gid, int vid, String name) throws DapException {
        int nativetypesize = base.getType().getSize();
        if (this.isstringtype(base)) {
            nativetypesize = NC_POINTER_BYTES;
        } else if (nativetypesize == 0) {
            throw new DapException("Illegal Type Sort:" + base.get().getShortName());
        }
        Object[] values = null;
        if (count > 0) {
            long totalsize = nativetypesize * count;
            Nc4DSP.Nc4Pointer mem = Nc4DSP.Nc4Pointer.allocate(totalsize);
            int ret = nc4.nc_get_att(gid, vid, name, mem.p);
            this.errcheck(ret);
            switch (base.getType().getTypeSort()) {
                case Char: {
                    values = mem.p.getByteArray(0L, count);
                    break;
                }
                case Int8: {
                    values = mem.p.getByteArray(0L, count);
                    break;
                }
                case UInt8: {
                    values = mem.p.getByteArray(0L, count);
                    break;
                }
                case Int16: {
                    values = mem.p.getShortArray(0L, count);
                    break;
                }
                case UInt16: {
                    values = mem.p.getShortArray(0L, count);
                    break;
                }
                case Int32: {
                    values = mem.p.getIntArray(0L, count);
                    break;
                }
                case UInt32: {
                    values = mem.p.getIntArray(0L, count);
                    break;
                }
                case Int64: {
                    values = mem.p.getLongArray(0L, count);
                    break;
                }
                case UInt64: {
                    values = mem.p.getLongArray(0L, count);
                    break;
                }
                case Float32: {
                    values = mem.p.getFloatArray(0L, count);
                    break;
                }
                case Float64: {
                    values = mem.p.getDoubleArray(0L, count);
                    break;
                }
                case String: {
                    values = mem.p.getStringArray(0L, count);
                    break;
                }
                case Opaque: {
                    values = mem.p.getByteArray(0L, (int)totalsize);
                    break;
                }
                case Enum: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected sort: " + base.getType().getShortName());
                }
            }
        }
        return values;
    }

    protected void errcheck(int ret) throws DapException {
        if (ret != 0) {
            String msg = String.format("TestNetcdf: errno=%d; %s", ret, nc4.nc_strerror(ret));
            throw new DapException(msg);
        }
    }

    boolean contains(int[] list, int value) {
        for (int i = 0; i < list.length; ++i) {
            if (list[i] != value) continue;
            return true;
        }
        return false;
    }

    boolean islegalattrtype(Nc4Notes.TypeNotes nctype) {
        return this.isatomictype(nctype) || this.isenumtype(nctype) || nctype.isOpaque();
    }

    boolean isatomictype(Nc4Notes.TypeNotes t) {
        return t.id <= 12;
    }

    boolean isstringtype(Nc4Notes.TypeNotes nctype) {
        return nctype.id == 12;
    }

    boolean ischartype(Nc4Notes.TypeNotes t) {
        return t.id == 2;
    }

    boolean isintegertype(Nc4Notes.TypeNotes t) {
        return t.id <= 11 && t.id != 2;
    }

    boolean isenumtype(Nc4Notes.TypeNotes nctype) {
        return nctype == null ? false : nctype.getType().isEnumType();
    }

    Nc4Notes.TypeNotes enumbasetype(Nc4Notes.TypeNotes etype) {
        if (etype == null || !etype.getType().isEnumType()) {
            return null;
        }
        DapType dt = ((DapEnumeration)etype.getType()).getBaseType();
        return (Nc4Notes.TypeNotes)this.dsp.find((DapNode)dt);
    }

    protected String Nc4FQN(Nc4Notes.TypeNotes t) throws DapException {
        int ret = 0;
        SizeTByReference lenp = new SizeTByReference();
        ret = nc4.nc_inq_grpname_len(t.gid, lenp);
        this.errcheck(ret);
        byte[] namep = new byte[lenp.intValue() + 1];
        ret = nc4.nc_inq_grpname_full(t.gid, lenp, namep);
        this.errcheck(ret);
        return Nc4DSP.makeString(namep);
    }
}

