/*
 * Decompiled with CFR 0.152.
 */
package dap4.dap4lib.serial;

import dap4.core.dmr.DapDataset;
import dap4.core.util.DapDump;
import dap4.core.util.DapException;
import dap4.dap4lib.AbstractDSP;
import dap4.dap4lib.serial.D4DataCompiler;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public abstract class D4DSP
extends AbstractDSP {
    public static boolean DEBUG = false;
    public static boolean DUMPDMR = false;
    public static boolean DUMPDAP = false;
    protected static final String DAPVERSION = "4.0";
    protected static final String DMRVERSION = "1.0";
    protected ByteBuffer databuffer = null;

    ByteBuffer getBuffer() {
        return this.databuffer;
    }

    protected void build(String document, byte[] serialdata, ByteOrder order) throws DapException {
        DapDataset dmr = this.parseDMR(document);
        if (DEBUG || DUMPDMR) {
            System.err.println("\n+++++++++++++++++++++");
            System.err.println(dmr);
            System.err.println("+++++++++++++++++++++\n");
        }
        if (DEBUG || DUMPDAP) {
            ByteBuffer data = ByteBuffer.wrap(serialdata);
            System.err.println("+++++++++++++++++++++");
            System.err.println("\n---------------------");
            DapDump.dumpbytes((ByteBuffer)data, (boolean)false);
            System.err.println("\n---------------------\n");
        }
        this.build(dmr, serialdata, order);
    }

    protected void build(DapDataset dmr, byte[] serialdata, ByteOrder order) throws DapException {
        this.setDMR(dmr);
        this.databuffer = ByteBuffer.wrap(serialdata).order(order);
        D4DataCompiler compiler = new D4DataCompiler(this, this.getChecksumMode(), this.getOrder(), this.databuffer);
        compiler.compile();
    }
}

