/*
 * Decompiled with CFR 0.152.
 */
package dap4.dap4servlet;

import dap4.ce.CEConstraint;
import dap4.ce.parser.CEAST;
import dap4.ce.parser.CECompiler;
import dap4.ce.parser.CEParser;
import dap4.core.dmr.DapDataset;
import dap4.core.dmr.ErrorResponse;
import dap4.core.util.DapException;
import dap4.core.util.DapUtil;
import dap4.core.util.ResponseFormat;
import dap4.dap4shared.DSP;
import dap4.dap4shared.DapProtocol;
import dap4.dap4shared.RequestMode;
import dap4.servlet.ChunkWriter;
import dap4.servlet.DMRPrint;
import dap4.servlet.DapCache;
import dap4.servlet.DapDSR;
import dap4.servlet.DapLog;
import dap4.servlet.DapRequest;
import dap4.servlet.DapSerializer;
import dap4.servlet.ServletInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class Dap4Servlet
extends HttpServlet {
    static final boolean DEBUG = true;
    static final boolean PARSEDEBUG = false;
    static final String SERVLETNAME = "Dap4";
    static final String TESTDATADIR = "testfiles";
    static final String BIG_ENDIAN = "Big-Endian";
    static final String LITTLE_ENDIAN = "Little-Endian";
    static boolean IS_BIG_ENDIAN = ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN;
    static final String DMREXT = ".dmr";
    static final String DATAEXT = ".dap";
    static final String DSREXT = ".dsr";
    static final String FAVICON = "favicon.ico";
    boolean compress = true;
    String datasetprefix = null;
    ByteOrder byteorder = ByteOrder.nativeOrder();
    DapDSR dsrbuilder = new DapDSR();
    ServletInfo svcinfo = null;

    public void init() throws ServletException {
        super.init();
        DapLog.info((String)(((Object)((Object)this)).getClass().getName() + " initialization start"));
        try {
            this.svcinfo = new ServletInfo((HttpServlet)this);
        }
        catch (Exception ioe) {
            throw new ServletException((Throwable)ioe);
        }
        try {
            System.setProperty("file.encoding", "UTF-8");
            Field charset = Charset.class.getDeclaredField("defaultCharset");
            charset.setAccessible(true);
            charset.set(null, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        DapLog.debug((String)("doGet(): User-Agent = " + req.getHeader("User-Agent")));
        String url = req.getRequestURL().toString();
        String query = req.getQueryString();
        DapLog.debug((String)("doGet(): url = " + url + (query == null || query.length() == 0 ? "" : "?" + query)));
        DapRequest drq = this.getRequestState(this.svcinfo, req, resp);
        System.err.println("Dap4Servlet: processing url: " + drq.getOriginalURL());
        if (url.endsWith(FAVICON)) {
            this.doFavicon(drq);
            return;
        }
        String datasetpath = drq.getDataset();
        if (datasetpath != null && datasetpath.length() == 0) {
            datasetpath = null;
        }
        try {
            if (datasetpath == null) {
                this.doCapabilities(drq);
            } else {
                RequestMode mode = drq.getMode();
                if (mode == null) {
                    throw new DapException("Unrecognized request extension").setCode(400);
                }
                switch (mode) {
                    case DMR: {
                        this.doDMR(drq, datasetpath);
                        break;
                    }
                    case DAP: {
                        this.doData(drq, datasetpath);
                        break;
                    }
                    case DSR: {
                        this.doDSR(drq, datasetpath);
                        break;
                    }
                    default: {
                        throw new DapException("Unrecognized request extension").setCode(400);
                    }
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            int code = 400;
            if (t instanceof FileNotFoundException) {
                code = 404;
            } else if (t instanceof UnsupportedOperationException) {
                code = 403;
            } else if (t instanceof MalformedURLException) {
                code = 404;
            } else if (t instanceof IOException) {
                code = ((DapException)t).getCode();
                if (code <= 0) {
                    code = 400;
                }
            } else {
                code = 500;
            }
            this.senderror(drq, code, t);
        }
    }

    protected void doCapabilities(DapRequest drq) throws IOException {
        throw new IOException("Unsupported operation: get capabilities");
    }

    protected void doFavicon(DapRequest drq) throws IOException {
        try {
            String favfile = this.getResourceFile(drq, FAVICON, false);
            if (favfile != null) {
                FileInputStream fav = new FileInputStream(favfile);
                byte[] content = DapUtil.readbinaryfile((InputStream)fav);
                OutputStream out = drq.getOutputStream();
                out.write(content);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void doDSR(DapRequest drq, String datasetname) throws IOException {
        try {
            String dsr = this.dsrbuilder.generate(drq.getURL());
            OutputStream out = drq.getOutputStream();
            this.addCommonHeaders(drq);
            ChunkWriter cw = new ChunkWriter(out, RequestMode.DSR, this.byteorder);
            cw.writeDSR(dsr);
            cw.close();
        }
        catch (IOException ioe) {
            throw new DapException("DSR generation error", (Throwable)ioe).setCode(500);
        }
    }

    protected void doDMR(DapRequest drq, String datasetname) throws IOException {
        String datasetpath = this.getResourceFile(drq, datasetname, false);
        DSP dsp = DapCache.open((String)datasetpath);
        CEConstraint ce = null;
        String sce = drq.queryLookup("dap4.ce");
        ce = this.buildconstraint(drq, sce, dsp.getDMR());
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        DMRPrint dapprinter = new DMRPrint(pw);
        dapprinter.printDMR(ce);
        pw.close();
        sw.close();
        String dmr = sw.toString();
        System.err.println("Sending: DMR:\n" + dmr);
        this.addCommonHeaders(drq);
        OutputStream out = drq.getOutputStream();
        ChunkWriter cw = new ChunkWriter(out, RequestMode.DMR, this.byteorder);
        cw.writeDMR(dmr);
        cw.close();
    }

    protected void doData(DapRequest drq, String datasetname) throws IOException {
        String datasetpath = this.getResourceFile(drq, datasetname, false);
        DSP dsp = DapCache.open((String)datasetpath);
        CEConstraint ce = null;
        String sce = drq.queryLookup("dap4.ce");
        ce = this.buildconstraint(drq, sce, dsp.getDMR());
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        DMRPrint dapprinter = new DMRPrint(pw);
        dapprinter.printDMR(ce);
        pw.close();
        sw.close();
        String dmr = sw.toString();
        System.err.println("Sending: Data DMR:\n" + dmr);
        OutputStream out = drq.getOutputStream();
        ChunkWriter cw = new ChunkWriter(out, RequestMode.DAP, this.byteorder);
        cw.writeDMR(dmr);
        cw.flush();
        this.addCommonHeaders(drq);
        DapSerializer writer = new DapSerializer(dsp, ce, (OutputStream)cw, this.byteorder);
        writer.write();
        cw.flush();
        cw.close();
    }

    protected void addCommonHeaders(DapRequest drq) throws IOException {
        DapProtocol.ContentType contentheaders;
        String header;
        ResponseFormat format = drq.getFormat();
        if (format == null) {
            format = ResponseFormat.NONE;
        }
        if ((header = (contentheaders = (DapProtocol.ContentType)DapProtocol.contenttypes.get(drq.getMode())).getFormat(format)) != null) {
            header = header + "; charset=utf-8";
            drq.setResponseHeader("Content-Type", header);
        } else {
            DapLog.error((String)"Cannot determine response Content-Type");
        }
        drq.setResponseHeader("Content-Encoding", IS_BIG_ENDIAN ? BIG_ENDIAN : LITTLE_ENDIAN);
    }

    ServletInfo getRequestState(HttpServlet svc) throws IOException {
        return new ServletInfo(svc);
    }

    DapRequest getRequestState(ServletInfo info, HttpServletRequest rq, HttpServletResponse rsp) throws IOException {
        return new DapRequest(info, rq, rsp);
    }

    String getResourceFile(DapRequest drq, String datasetname, boolean isdir) throws IOException {
        String resourcedir = drq.getResourcePath();
        String datasetfilepath = DapUtil.locateRelative((String)datasetname, (String)resourcedir, (boolean)isdir);
        if (datasetfilepath == null) {
            throw new FileNotFoundException("Cannot locate file:" + datasetfilepath);
        }
        File dataset = new File(datasetfilepath);
        if (!dataset.exists()) {
            throw new DapException("Requested file does not exist").setCode(404);
        }
        if (!dataset.canRead()) {
            throw new DapException("Requested file not readable").setCode(403);
        }
        if (isdir && !dataset.isDirectory()) {
            throw new DapException("Requested file not a directory").setCode(403);
        }
        return datasetfilepath;
    }

    void senderror(DapRequest drq, int httpcode, Throwable t) throws IOException {
        if (httpcode == 0) {
            httpcode = 400;
        }
        ErrorResponse err = new ErrorResponse();
        err.setCode(httpcode);
        err.setMessage(t == null ? "Servlet Error: " + t.getClass().getName() : t.getMessage());
        err.setContext(drq.getURL());
        String errormsg = err.buildXML();
        drq.getResponse().sendError(httpcode, errormsg);
    }

    protected CEConstraint buildconstraint(DapRequest drq, String sce, DapDataset dmr) throws IOException {
        if (sce == null || sce.length() == 0) {
            return CEConstraint.getUniversal((DapDataset)dmr);
        }
        CEParser ceparser = new CEParser(dmr);
        System.err.println("Dap4Servlet: parsing constraint: |" + sce + "|");
        boolean parseok = ceparser.parse(sce);
        if (!parseok) {
            throw new IOException("Constraint Parse failed: " + sce);
        }
        CEAST root = ceparser.getConstraint();
        CECompiler compiler = new CECompiler();
        CEConstraint ce = compiler.compile(dmr, root);
        ce.finish(true);
        return ce;
    }
}

