/*
 * Decompiled with CFR 0.152.
 */
package dap4.servlet;

import dap4.core.ce.CEConstraint;
import dap4.core.data.ChecksumMode;
import dap4.core.data.DSP;
import dap4.core.dmr.DapAttribute;
import dap4.core.dmr.DapDataset;
import dap4.core.dmr.DapType;
import dap4.core.dmr.ErrorResponse;
import dap4.core.util.DapContext;
import dap4.core.util.DapDump;
import dap4.core.util.DapException;
import dap4.core.util.DapUtil;
import dap4.core.util.ResponseFormat;
import dap4.dap4lib.DMRPrinter;
import dap4.dap4lib.DapLog;
import dap4.dap4lib.DapProtocol;
import dap4.dap4lib.RequestMode;
import dap4.servlet.ChunkWriter;
import dap4.servlet.DapCache;
import dap4.servlet.DapDSR;
import dap4.servlet.DapRequest;
import dap4.servlet.DapSerializer;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DapController
extends HttpServlet {
    public static boolean TESTING = false;
    public static boolean DEBUG = false;
    public static boolean DUMPDMR = false;
    public static boolean DUMPDATA = false;
    public static boolean PARSEDEBUG = false;
    protected static final String BIG_ENDIAN = "Big-Endian";
    protected static final String LITTLE_ENDIAN = "Little-Endian";
    protected static boolean IS_BIG_ENDIAN = ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN;
    protected static final String DMREXT = ".dmr";
    protected static final String DATAEXT = ".dap";
    protected static final String DSREXT = ".dsr";
    protected static final String[] ENDINGS = new String[]{".dmr", ".dap", ".dsr"};
    protected static final String FAVICON = "favicon.ico";
    public static final long DEFAULTBINARYWRITELIMIT = 100000000L;
    protected static DapCache cache = null;
    protected boolean initialized = false;

    protected static void setCache(DapCache cache) {
        DapController.cache = cache;
    }

    protected static DapCache getCache() {
        return cache;
    }

    public DapController() {
        ChunkWriter.DUMPDATA = DUMPDATA;
    }

    protected abstract void doFavicon(String var1, DapContext var2) throws IOException;

    protected abstract void doCapabilities(DapRequest var1, DapContext var2) throws IOException;

    public abstract String getResourcePath(DapRequest var1, String var2) throws DapException;

    public abstract long getBinaryWriteLimit();

    public abstract String getServletID();

    public void init() throws ServletException {
        Logger logServerStartup = LoggerFactory.getLogger((String)"serverStartup");
        logServerStartup.info(((Object)((Object)this)).getClass().getName() + " initialization start");
        try {
            System.setProperty("file.encoding", "UTF-8");
            Field charset = Charset.class.getDeclaredField("defaultCharset");
            charset.setAccessible(true);
            charset.set(null, null);
            this.initialize();
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void initialize() {
        this.initialized = true;
    }

    public void handleRequest(HttpServletRequest req, HttpServletResponse res) throws IOException {
        DapLog.debug((String)("doGet(): User-Agent = " + req.getHeader("User-Agent")));
        if (!this.initialized) {
            this.initialize();
        }
        DapRequest daprequest = this.getRequestState(req, res);
        String url = daprequest.getOriginalURL();
        StringBuilder info = new StringBuilder("doGet():");
        info.append(" dataset = ");
        info.append(" url = ");
        info.append(url);
        if (DEBUG) {
            System.err.println("DAP4 Servlet: processing url: " + daprequest.getOriginalURL());
        }
        DapContext dapcxt = new DapContext();
        dapcxt.put(HttpServletRequest.class, (Object)req);
        dapcxt.put(HttpServletResponse.class, (Object)res);
        dapcxt.put(DapRequest.class, (Object)daprequest);
        ByteOrder order = daprequest.getOrder();
        ChecksumMode checksummode = daprequest.getChecksumMode();
        dapcxt.put((Object)"ucar.littleendian", (Object)order);
        dapcxt.put((Object)"ucar.checksummode", (Object)checksummode);
        Map<String, String> queries = daprequest.getQueries();
        for (Map.Entry<String, String> entry : queries.entrySet()) {
            if (dapcxt.get((Object)entry.getKey()) != null) continue;
            dapcxt.put((Object)entry.getKey(), (Object)entry.getValue());
        }
        if (url.endsWith(FAVICON)) {
            this.doFavicon(FAVICON, dapcxt);
            return;
        }
        String datasetpath = DapUtil.nullify((String)DapUtil.canonicalpath((String)daprequest.getDataset()));
        try {
            if (datasetpath == null) {
                this.doCapabilities(daprequest, dapcxt);
            } else {
                RequestMode mode = daprequest.getMode();
                if (mode == null) {
                    throw new DapException("Unrecognized request extension").setCode(400);
                }
                switch (mode) {
                    case DMR: {
                        this.doDMR(daprequest, dapcxt);
                        break;
                    }
                    case DAP: {
                        this.doData(daprequest, dapcxt);
                        break;
                    }
                    case DSR: {
                        this.doDSR(daprequest, dapcxt);
                        break;
                    }
                    default: {
                        throw new DapException("Unrecognized request extension").setCode(400);
                    }
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            int code = 400;
            if (t instanceof DapException) {
                DapException e = (DapException)t;
                code = e.getCode();
                if (code <= 0) {
                    code = 400;
                }
                e.setCode(code);
            } else {
                code = t instanceof FileNotFoundException ? 404 : (t instanceof UnsupportedOperationException ? 403 : (t instanceof MalformedURLException ? 404 : (t instanceof IOException ? 400 : 500)));
            }
            this.senderror(daprequest, code, t);
        }
    }

    protected void doDSR(DapRequest drq, DapContext cxt) throws IOException {
        try {
            DapDSR dsrbuilder = new DapDSR();
            String dsr = dsrbuilder.generate(drq.getURL());
            OutputStream out = drq.getOutputStream();
            this.addCommonHeaders(drq);
            ByteOrder order = (ByteOrder)cxt.get((Object)"ucar.littleendian");
            ChunkWriter cw = new ChunkWriter(out, RequestMode.DSR, order);
            cw.writeDSR(dsr);
            cw.close();
        }
        catch (IOException ioe) {
            throw new DapException("DSR generation error", (Throwable)ioe).setCode(500);
        }
    }

    protected void doDMR(DapRequest drq, DapContext cxt) throws IOException {
        String realpath = this.getResourcePath(drq, drq.getDatasetPath());
        DSP dsp = DapCache.open(realpath, cxt);
        DapDataset dmr = dsp.getDMR();
        ByteOrder order = (ByteOrder)cxt.get((Object)"ucar.littleendian");
        this.setEndianness(dmr, order);
        CEConstraint ce = null;
        String sce = drq.queryLookup("dap4.ce");
        ce = CEConstraint.compile((String)sce, (DapDataset)dmr);
        this.setConstraint(dmr, ce);
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        DMRPrinter dapprinter = new DMRPrinter(dmr, ce, pw, drq.getFormat());
        if (cxt.get((Object)"ucar.testing") != null) {
            dapprinter.testprint();
        } else {
            dapprinter.print();
        }
        pw.close();
        sw.close();
        String sdmr = sw.toString();
        if (DEBUG) {
            System.err.println("Sending: DMR:\n" + sdmr);
        }
        this.addCommonHeaders(drq);
        OutputStream out = drq.getOutputStream();
        ChunkWriter cw = new ChunkWriter(out, RequestMode.DMR, order);
        cw.cacheDMR(sdmr);
        cw.close();
    }

    protected void doData(DapRequest drq, DapContext cxt) throws IOException {
        byte[] data;
        String realpath = this.getResourcePath(drq, drq.getDatasetPath());
        DSP dsp = DapCache.open(realpath, cxt);
        if (dsp == null) {
            throw new DapException("No such file: " + drq.getResourceRoot());
        }
        DapDataset dmr = dsp.getDMR();
        if (DUMPDMR) {
            DapController.printDMR(dmr);
            System.err.println(DapController.printDMR(dmr));
            System.err.flush();
        }
        ByteOrder order = (ByteOrder)cxt.get((Object)"ucar.littleendian");
        this.setEndianness(dmr, order);
        CEConstraint ce = null;
        String sce = drq.queryLookup("dap4.ce");
        ce = CEConstraint.compile((String)sce, (DapDataset)dmr);
        this.setConstraint(dmr, ce);
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        DMRPrinter dapprinter = new DMRPrinter(dmr, ce, pw, drq.getFormat());
        dapprinter.print();
        pw.close();
        sw.close();
        String sdmr = sw.toString();
        if (DEBUG || DUMPDMR) {
            System.err.println("Sending: Data DMR:\n" + sdmr);
        }
        OutputStream out = drq.getOutputStream();
        ChunkWriter cw = new ChunkWriter(out, RequestMode.DAP, order);
        cw.setWriteLimit(this.getBinaryWriteLimit());
        cw.cacheDMR(sdmr);
        cw.flush();
        this.addCommonHeaders(drq);
        switch (drq.getFormat()) {
            case TEXT: 
            case XML: 
            case HTML: {
                throw new IOException("Unsupported return format: " + drq.getFormat());
            }
        }
        DapSerializer writer = new DapSerializer(dsp, ce, cw, order, drq.getChecksumMode());
        writer.write(dsp.getDMR());
        cw.flush();
        cw.close();
        if (DUMPDATA && (data = cw.getDump()) != null) {
            DapDump.dumpbytestream((byte[])data, (ByteOrder)cw.getWriteOrder(), (String)"ChunkWriter.write");
        }
    }

    protected void addCommonHeaders(DapRequest drq) throws IOException {
        DapProtocol.ContentType contentheaders;
        String header;
        ResponseFormat format = drq.getFormat();
        if (format == null) {
            format = ResponseFormat.NONE;
        }
        if ((header = (contentheaders = (DapProtocol.ContentType)DapProtocol.contenttypes.get(drq.getMode())).getFormat(format)) != null) {
            header = header + "; charset=utf-8";
            drq.setResponseHeader("Content-Type", header);
        } else {
            DapLog.error((String)"Cannot determine response Content-Type");
        }
    }

    protected DapRequest getRequestState(HttpServletRequest rq, HttpServletResponse rsp) throws IOException {
        return new DapRequest(this, rq, rsp);
    }

    protected void senderror(DapRequest drq, int httpcode, Throwable t) throws IOException {
        if (httpcode == 0) {
            httpcode = 400;
        }
        ErrorResponse err = new ErrorResponse();
        err.setCode(httpcode);
        if (t == null) {
            err.setMessage("Servlet error: " + drq.getURL());
        } else {
            StringWriter sw = new StringWriter();
            PrintWriter p = new PrintWriter(sw);
            t.printStackTrace(p);
            p.close();
            sw.close();
            err.setMessage(sw.toString());
        }
        err.setContext(drq.getURL());
        String errormsg = err.buildXML();
        drq.getResponse().sendError(httpcode, errormsg);
    }

    void setEndianness(DapDataset dmr, ByteOrder order) throws DapException {
        DapAttribute a = dmr.findAttribute("_DAP4_Little_Endian");
        if (a == null) {
            a = new DapAttribute("_DAP4_Little_Endian", DapType.UINT8);
            dmr.addAttribute(a);
        }
        String oz = order == ByteOrder.BIG_ENDIAN ? "0" : "1";
        a.setValues(new String[]{oz});
    }

    void setConstraint(DapDataset dmr, CEConstraint ce) throws DapException {
        if (ce == null) {
            return;
        }
        if (ce.isUniversal()) {
            return;
        }
        DapAttribute a = dmr.findAttribute("_dap4.ce");
        if (a == null) {
            a = new DapAttribute("_dap4.ce", DapType.STRING);
            dmr.addAttribute(a);
        }
        String sce = ce.toConstraintString();
        a.setValues(new String[]{sce});
    }

    public static String printDMR(DapDataset dmr) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        DMRPrinter printer = new DMRPrinter(dmr, pw);
        try {
            printer.print();
            pw.close();
            sw.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sw.toString();
    }
}

