/*
 * Decompiled with CFR 0.152.
 */
package dap4.servlet;

import dap4.core.dmr.DapNode;
import dap4.core.dmr.DapSequence;
import dap4.core.dmr.DapStructure;
import dap4.core.dmr.DapType;
import dap4.core.dmr.DapVariable;
import dap4.core.interfaces.ArrayScheme;
import dap4.core.util.DapException;
import dap4.core.util.DapSort;
import dap4.core.util.DapUtil;
import dap4.core.util.Slice;
import dap4.dap4lib.D4Index;
import dap4.dap4lib.cdm.CDMTypeFcns;
import dap4.dap4lib.cdm.CDMUtil;
import dap4.servlet.CDMWrap;
import dap4.servlet.Odometer;
import dap4.servlet.OdometerFactory;
import java.util.List;
import ucar.ma2.Array;
import ucar.ma2.ArrayStructure;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.StructureData;
import ucar.ma2.StructureMembers;

public class CDMData {
    protected ArrayScheme scheme;
    protected CDMWrap cdmwrap;
    protected DapNode template;
    protected CDMData container;
    protected Array array = null;
    protected StructureData structdata = null;
    StructureMembers.Member member = null;
    protected long recordindex = -1L;
    protected long recordcount = -1L;
    protected Index index = null;

    public CDMData(ArrayScheme scheme, CDMWrap c4, DapNode template, CDMData container) throws DapException {
        this.scheme = scheme;
        this.cdmwrap = c4;
        this.template = template;
        this.container = container;
    }

    public CDMData(CDMData c) {
        assert (false);
        this.array = c.array;
        this.structdata = c.structdata;
        this.member = c.member;
    }

    public ArrayScheme getScheme() {
        return this.scheme;
    }

    public CDMWrap getCDMWrap() {
        return this.cdmwrap;
    }

    public DapNode getTemplate() {
        return this.template;
    }

    public CDMData getContainer() {
        return this.container;
    }

    public long getRecordIndex() {
        return this.recordindex;
    }

    public long getRecordCount() {
        return this.recordcount;
    }

    public Index getIndex() {
        return this.index;
    }

    public CDMData setRecordIndex(long index) {
        this.recordindex = index;
        return this;
    }

    public CDMData setRecordCount(long count) {
        this.recordcount = count;
        return this;
    }

    public CDMData setIndex(Index count) {
        this.index = count;
        return this;
    }

    public Object read(List<Slice> slices) throws DapException {
        switch (this.scheme) {
            case ATOMIC: {
                return this.readAtomic(slices);
            }
            case STRUCTURE: {
                if (((DapVariable)this.getTemplate()).getRank() > 0 || DapUtil.isScalarSlices(slices)) {
                    throw new DapException("Cannot slice a scalar variable");
                }
                CDMData[] instances = new CDMData[]{this};
                return instances;
            }
            case SEQUENCE: {
                if (((DapVariable)this.getTemplate()).getRank() > 0 || DapUtil.isScalarSlices(slices)) {
                    throw new DapException("Cannot slice a scalar variable");
                }
                CDMData[] instances = new CDMData[]{this};
                return instances;
            }
            case STRUCTARRAY: {
                Odometer odom = OdometerFactory.factory(slices, ((DapVariable)this.getTemplate()).getDimensions());
                CDMData[] instances = new CDMData[(int)odom.totalSize()];
                int i = 0;
                while (odom.hasNext()) {
                    instances[i] = this.readStructure((Index)odom.next());
                    ++i;
                }
                return instances;
            }
            case SEQARRAY: {
                CDMData[] instances = this.readSequence(slices);
                return instances;
            }
        }
        throw new DapException("Attempt to slice a scalar object");
    }

    public Object read(Index index) throws DapException {
        return this.read(D4Index.indexToSlices((Index)index));
    }

    public CDMData readField(int findex) throws DapException {
        if (this.scheme != ArrayScheme.RECORD) {
            if (this.scheme != ArrayScheme.STRUCTURE) {
                throw new DapException("Illegal cursor scheme for readfield()");
            }
        }
        DapVariable var = (DapVariable)this.getTemplate();
        DapStructure basetype = (DapStructure)var.getBaseType();
        if (findex < 0 || findex >= basetype.getFields().size()) {
            throw new DapException("Field index out of range: " + findex);
        }
        CDMData fieldcursor = null;
        if (this.scheme == ArrayScheme.RECORD) {
            DapSequence seq = (DapSequence)basetype;
            DapVariable field = seq.getField(0);
            DapType fieldtype = field.getBaseType();
            switch (fieldtype.getTypeSort()) {
                default: {
                    DataType cdmfieldtype = CDMTypeFcns.daptype2cdmtype((DapType)fieldtype);
                    if (cdmfieldtype == null) {
                        throw new DapException("Unknown field type: " + fieldtype);
                    }
                    int ri = (int)this.recordindex;
                    Object o = this.array.getObject(ri);
                    Array fielddata = CDMTypeFcns.arrayify((DataType)cdmfieldtype, (Object)o);
                    fieldcursor = new CDMData(ArrayScheme.ATOMIC, this.getCDMWrap(), (DapNode)field, this);
                    fieldcursor.setArray(fielddata);
                }
                case Sequence: 
                case Structure: 
            }
        } else {
            assert (this.structdata != null);
            fieldcursor = this.getFieldCursor(this, findex);
        }
        return fieldcursor;
    }

    protected CDMData getFieldCursor(CDMData container, int findex) throws DapException {
        DapVariable var = (DapVariable)this.getTemplate();
        DapStructure type = (DapStructure)var.getBaseType();
        DapVariable field = (DapVariable)type.getFields().get(findex);
        DapType ftype = field.getBaseType();
        ArrayScheme scheme = CDMData.schemeFor(field);
        CDMData fc = new CDMData(scheme, this.getCDMWrap(), (DapNode)field, this);
        StructureMembers.Member member = this.structdata.getStructureMembers().getMember(findex);
        fc.setMember(member);
        fc.setArray(this.structdata.getArray(fc.member));
        return fc;
    }

    public boolean isScalar() {
        if (this.getTemplate().getSort().isVar()) {
            return ((DapVariable)this.getTemplate()).getRank() == 0;
        }
        return false;
    }

    public boolean isField() {
        return this.getTemplate().getContainer() != null;
    }

    public boolean isAtomic() {
        boolean is;
        boolean bl = is = this.scheme == ArrayScheme.ATOMIC;
        assert (!is || this.getTemplate().getSort() == DapSort.ATOMICTYPE || this.getTemplate().getSort() == DapSort.VARIABLE && ((DapVariable)this.getTemplate()).getBaseType().getTypeSort().isAtomic());
        return is;
    }

    public boolean isCompound() {
        boolean is;
        boolean bl = is = this.scheme == ArrayScheme.SEQUENCE || this.scheme == ArrayScheme.STRUCTURE;
        assert (!is || this.getTemplate().getSort() == DapSort.SEQUENCE || this.getTemplate().getSort() == DapSort.STRUCTURE || this.getTemplate().getSort() == DapSort.VARIABLE && ((DapVariable)this.getTemplate()).getBaseType().getTypeSort().isCompoundType());
        return is;
    }

    public boolean isCompoundArray() {
        boolean is;
        boolean bl = is = this.scheme == ArrayScheme.SEQARRAY || this.scheme == ArrayScheme.STRUCTARRAY;
        assert (!is || this.getTemplate().getSort() == DapSort.SEQUENCE || this.getTemplate().getSort() == DapSort.STRUCTURE || this.getTemplate().getSort() == DapSort.VARIABLE && ((DapVariable)this.getTemplate()).getBaseType().getTypeSort().isCompoundType());
        return is;
    }

    protected static ArrayScheme schemeFor(DapVariable field) {
        boolean isscalar;
        DapType ftype = field.getBaseType();
        ArrayScheme scheme = null;
        boolean bl = isscalar = field.getRank() == 0;
        if (ftype.getTypeSort().isAtomic()) {
            scheme = ArrayScheme.ATOMIC;
        } else if (ftype.getTypeSort().isStructType()) {
            scheme = ArrayScheme.STRUCTARRAY;
        } else if (ftype.getTypeSort().isSeqType()) {
            scheme = ArrayScheme.SEQARRAY;
        }
        return scheme;
    }

    public CDMData readRecord(long i) throws DapException {
        if (this.scheme != ArrayScheme.SEQUENCE) {
            throw new DapException("Attempt to read record from non-sequence cursor");
        }
        if (i < 0L || i >= this.recordcount) {
            throw new DapException("Record index out of bounds");
        }
        DapVariable var = (DapVariable)this.getTemplate();
        CDMData c = new CDMData(ArrayScheme.RECORD, this.getCDMWrap(), (DapNode)var, this);
        c.setArray(this.array);
        c.setRecordIndex(i);
        return c;
    }

    public int fieldIndex(String name) throws DapException {
        DapStructure ds;
        if (this.getTemplate().getSort().isCompound()) {
            ds = (DapStructure)this.getTemplate();
        } else if (this.getTemplate().getSort().isVar() && ((DapVariable)this.getTemplate()).getBaseType().getSort().isCompound()) {
            ds = (DapStructure)((DapVariable)this.getTemplate()).getBaseType();
        } else {
            throw new DapException("Attempt to get field name on non-compound object");
        }
        int i = ds.indexByName(name);
        if (i < 0) {
            throw new DapException("Unknown field name: " + name);
        }
        return i;
    }

    protected Object readAtomic(List<Slice> slices) throws DapException {
        if (slices == null) {
            throw new DapException("CDMCursor.read: null set of slices");
        }
        assert (this.scheme == ArrayScheme.ATOMIC);
        DapVariable atomvar = (DapVariable)this.getTemplate();
        assert (slices != null && (atomvar.getRank() == 0 && slices.size() == 1 || slices.size() == atomvar.getRank()));
        return this.sliceAtomic(slices, this.array, atomvar);
    }

    protected Object sliceAtomic(List<Slice> slices, Array array, DapVariable var) throws DapException {
        List dimset = var.getDimensions();
        DapType basetype = var.getBaseType();
        DataType datatype = CDMTypeFcns.daptype2cdmtype((DapType)basetype);
        if (datatype == null) {
            throw new DapException("Unknown basetype: " + basetype);
        }
        Object content = array.get1DJavaArray(datatype);
        Odometer odom = OdometerFactory.factory(slices, dimset);
        Object data = CDMTypeFcns.createVector((DataType)datatype, (long)odom.totalSize());
        int dstoffset = 0;
        while (odom.hasNext()) {
            D4Index index = odom.next();
            long srcoffset = index.index();
            CDMTypeFcns.vectorcopy((DapType)basetype, (Object)content, (Object)data, (long)srcoffset, (long)dstoffset);
            ++dstoffset;
        }
        return data;
    }

    protected CDMData readStructure(Index index) throws DapException {
        assert (index != null);
        DapVariable var = (DapVariable)this.getTemplate();
        DapStructure type = (DapStructure)var.getBaseType();
        int pos = index.currentElement();
        if (pos < 0 || (long)pos > var.getCount()) {
            throw new IndexOutOfBoundsException("read: " + index);
        }
        ArrayStructure sarray = (ArrayStructure)this.array;
        assert (this.scheme == ArrayScheme.STRUCTARRAY);
        StructureData sd = sarray.getStructureData(pos);
        assert (sd != null);
        CDMData instance = new CDMData(ArrayScheme.STRUCTURE, this.getCDMWrap(), (DapNode)var, null).setStructureData(sd);
        instance.setIndex(index);
        return instance;
    }

    protected CDMData[] readSequence(List<Slice> slices) throws DapException {
        assert (this.scheme == ArrayScheme.SEQARRAY);
        DapVariable var = (DapVariable)this.getTemplate();
        DapSequence type = (DapSequence)var.getBaseType();
        CDMData[] instances = new CDMData[(int)DapUtil.sliceProduct(slices)];
        Array seqarray = this.array;
        if (var.getRank() == 0) {
            if (!DapUtil.isScalarSlices(slices)) {
                throw new DapException("Non-scalar slice set applied to scalar variable");
            }
            instances[0] = new CDMData(ArrayScheme.SEQUENCE, this.getCDMWrap(), (DapNode)var, this);
            instances[0].setArray(seqarray);
            instances[0].setRecordCount(seqarray.getSize());
        } else {
            Array instancearray;
            List rlist = CDMUtil.createCDMRanges(slices);
            try {
                instancearray = seqarray.section(rlist);
            }
            catch (InvalidRangeException e) {
                throw new DapException("Illegal slice set", (Throwable)e);
            }
            int slicecount = (int)DapUtil.sliceProduct(slices);
            for (int i = 0; i < slicecount; ++i) {
                Array ao = (Array)instancearray.getObject(i);
                CDMData c = new CDMData(ArrayScheme.SEQUENCE, this.getCDMWrap(), (DapNode)var, this);
                c.setArray(ao);
                long rcount = ao.getSize();
                c.setRecordCount(rcount);
                instances[i] = c;
            }
        }
        return instances;
    }

    public CDMData setArray(Array a) {
        this.array = a;
        return this;
    }

    public Array getArray() {
        return this.array;
    }

    public CDMData setStructureData(StructureData sd) {
        this.structdata = sd;
        return this;
    }

    public CDMData setMember(StructureMembers.Member m) {
        this.member = m;
        return this;
    }
}

