/*
 * Decompiled with CFR 0.152.
 */
package dap4.servlet;

import dap4.core.util.ChecksumMode;
import dap4.core.util.DapException;
import dap4.core.util.DapUtil;
import dap4.core.util.Escape;
import dap4.core.util.ResponseFormat;
import dap4.core.util.XURI;
import dap4.dap4lib.RequestMode;
import dap4.servlet.DapController;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.nio.ByteOrder;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DapRequest {
    static final boolean DEBUG = false;
    protected static final String WEBINFPATH = "WEB-INF";
    protected static final String RESOURCEDIRNAME = "resources";
    protected DapController controller = null;
    protected HttpServletRequest request = null;
    protected HttpServletResponse response = null;
    protected XURI xuri = null;
    protected RequestMode mode = null;
    protected ResponseFormat format = null;
    protected ByteOrder order = ByteOrder.nativeOrder();
    protected ChecksumMode checksummode = null;
    protected String datasetpath = null;
    protected String dataset = null;

    public DapRequest(DapController controller, HttpServletRequest request, HttpServletResponse response) throws DapException {
        this.request = request;
        this.response = response;
        this.controller = controller;
        try {
            this.parseURI();
        }
        catch (IOException ioe) {
            throw new DapException((Throwable)ioe);
        }
    }

    protected void parseURI() throws IOException {
        String p;
        try {
            StringBuffer fullurl = this.request.getRequestURL();
            if (this.request.getQueryString() != null) {
                fullurl.append("?");
                fullurl.append(Escape.urlDecode((String)this.request.getQueryString()));
            }
            this.xuri = new XURI(fullurl.toString());
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
        this.datasetpath = this.request.getServletPath();
        if (this.datasetpath.equals("/") || this.datasetpath.equals("")) {
            this.datasetpath = null;
        }
        if (this.datasetpath == null) {
            this.mode = RequestMode.CAPABILITIES;
        } else {
            String path = this.datasetpath;
            int index = path.lastIndexOf(47);
            if (index < 0) {
                index = 0;
            }
            String prefix = path.substring(0, index);
            String file = path.substring(index, path.length());
            file = DapUtil.relativize((String)file);
            while (true) {
                String extension;
                if ((index = file.lastIndexOf(46)) < 0) {
                    index = file.length();
                }
                if ((extension = file.substring(index, file.length())) == null || extension.equals("")) break;
                boolean modepos = false;
                RequestMode mode = RequestMode.modeFor((String)extension);
                ResponseFormat format = ResponseFormat.formatFor((String)extension);
                if (mode == null && format == null) break;
                if (mode != null) {
                    if (this.mode != null) {
                        throw new DapException("Multiple request modes specified: " + extension).setCode(400);
                    }
                    this.mode = mode;
                } else if (format != null) {
                    if (this.format != null) {
                        throw new DapException("Multiple response formats specified: " + extension).setCode(400);
                    }
                    this.format = format;
                }
                file = file.substring(0, index);
            }
            this.dataset = file;
            this.datasetpath = prefix + "/" + this.dataset;
        }
        if (this.mode == null) {
            this.mode = RequestMode.DSR;
        }
        if (this.format == null) {
            this.format = ResponseFormat.NONE;
        }
        if ((p = this.queryLookup("ucar.littleendian")) != null) {
            Integer oz = DapUtil.stringToInteger((String)p);
            if (oz == null) {
                this.order = ByteOrder.LITTLE_ENDIAN;
            } else {
                ByteOrder byteOrder = this.order = oz != 0 ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
            }
        }
        if ((p = this.queryLookup("dap4.checksum")) != null) {
            this.checksummode = ChecksumMode.modeFor((String)p);
        }
    }

    public ByteOrder getOrder() {
        return this.order;
    }

    public ChecksumMode getChecksumMode() {
        return this.checksummode;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public String getWebContentRoot() throws DapException {
        return this.controller.getWebContentRoot(this);
    }

    public String getServletID() throws DapException {
        return this.controller.getServletID();
    }

    public String getResourcePath(String location) throws DapException {
        return this.controller.getResourcePath(this, location);
    }

    public String getWebContentPath(String location) throws DapException {
        Object path = this.getWebContentRoot();
        path = DapUtil.canonicalpath((String)path);
        location = DapUtil.relativize((String)location);
        path = (String)path + "/" + location;
        return path;
    }

    public OutputStream getOutputStream() throws IOException {
        return this.response.getOutputStream();
    }

    public String getURL() {
        return this.xuri.toString();
    }

    public String getDatasetPath() {
        return this.datasetpath;
    }

    public String getDataset() {
        return this.dataset;
    }

    public RequestMode getMode() {
        return this.mode;
    }

    public ResponseFormat getFormat() {
        return this.format;
    }

    public void setResponseHeader(String name, String value) {
        this.response.setHeader(name, value);
    }

    public String queryLookup(String name) {
        return (String)this.xuri.getQueryFields().get(name.toLowerCase());
    }

    public Map<String, String> getQueries() {
        return this.xuri.getQueryFields();
    }

    static String makeQueryString(HttpServletRequest req) {
        Map map = req.getParameterMap();
        if (map == null || map.size() == 0) {
            return null;
        }
        StringBuilder q = new StringBuilder();
        for (Map.Entry entry : map.entrySet()) {
            String[] values = (String[])entry.getValue();
            if (values == null || values.length == 0) {
                q.append("&");
                q.append((String)entry.getKey());
                continue;
            }
            for (int i = 0; i < values.length; ++i) {
                q.append("&");
                q.append((String)entry.getKey());
                q.append("=");
                q.append(values[i]);
            }
        }
        if (q.length() > 0) {
            q.deleteCharAt(0);
        }
        return q.toString();
    }
}

