/*
 * Decompiled with CFR 0.152.
 */
package dap4.servlet;

import dap4.core.ce.CEConstraint;
import dap4.core.dmr.DMRPrinter;
import dap4.core.dmr.DapDataset;
import dap4.core.dmr.DapVariable;
import dap4.core.dmr.ErrorResponse;
import dap4.core.util.ChecksumMode;
import dap4.core.util.DapContext;
import dap4.core.util.DapException;
import dap4.core.util.DapUtil;
import dap4.core.util.ResponseFormat;
import dap4.dap4lib.DapLog;
import dap4.dap4lib.DapProtocol;
import dap4.dap4lib.RequestMode;
import dap4.servlet.CDMWrap;
import dap4.servlet.ChunkWriter;
import dap4.servlet.DapDSR;
import dap4.servlet.DapRequest;
import dap4.servlet.DapSerializer;
import dap4.servlet.NullOutputStream;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.nio.ByteOrder;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DapController
extends HttpServlet {
    public static boolean DEBUG = false;
    protected static final String BIG_ENDIAN = "Big-Endian";
    protected static final String LITTLE_ENDIAN = "Little-Endian";
    protected static boolean IS_BIG_ENDIAN = ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN;
    protected static final String DMREXT = ".dmr";
    protected static final String DATAEXT = ".dap";
    protected static final String DSREXT = ".dsr";
    protected static final String[] ENDINGS = new String[]{".dmr", ".dap", ".dsr"};
    protected static final String FAVICON = "favicon.ico";
    public static final long DEFAULTBINARYWRITELIMIT = 100000000L;
    protected boolean initialized = false;
    protected String webContentRoot = null;
    protected String testDataRoot = null;

    public static String printDMR(DapDataset dmr) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        DMRPrinter printer = new DMRPrinter(dmr, pw);
        try {
            printer.print();
            pw.close();
            sw.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sw.toString();
    }

    protected abstract void doFavicon(String var1, DapContext var2) throws IOException;

    protected abstract void doCapabilities(DapRequest var1, DapContext var2) throws IOException;

    public abstract long getBinaryWriteLimit();

    public abstract String getServletID();

    protected abstract String getWebContentRoot(DapRequest var1) throws DapException;

    protected abstract String getResourcePath(DapRequest var1, String var2) throws DapException;

    public void init() {
        Logger logServerStartup = LoggerFactory.getLogger((String)"serverStartup");
        logServerStartup.info(((Object)((Object)this)).getClass().getName() + " initialization start");
        this.initialize();
    }

    public void initialize() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
    }

    public void handleRequest(HttpServletRequest req, HttpServletResponse res) throws IOException {
        String url;
        DapLog.debug((String)("doGet(): User-Agent = " + req.getHeader("User-Agent")));
        if (!this.initialized) {
            this.initialize();
        }
        DapRequest daprequest = this.getRequestState(req, res);
        DapContext dapcxt = this.buildDapContext(daprequest);
        if (this.webContentRoot == null) {
            this.webContentRoot = this.getWebContentRoot(daprequest);
            this.webContentRoot = DapUtil.canonicalpath((String)this.webContentRoot);
        }
        if ((url = daprequest.getURL()).endsWith(FAVICON)) {
            this.doFavicon(FAVICON, dapcxt);
            return;
        }
        String datasetpath = daprequest.getDatasetPath();
        datasetpath = DapUtil.nullify((String)DapUtil.canonicalpath((String)datasetpath));
        try {
            if (datasetpath == null) {
                this.doCapabilities(daprequest, dapcxt);
            } else {
                RequestMode mode = daprequest.getMode();
                if (mode == null) {
                    throw new DapException("Unrecognized request extension").setCode(400);
                }
                switch (mode) {
                    case DMR: {
                        this.doDMR(daprequest, dapcxt);
                        break;
                    }
                    case DAP: {
                        this.doData(daprequest, dapcxt);
                        break;
                    }
                    case DSR: {
                        this.doDSR(daprequest, dapcxt);
                        break;
                    }
                    default: {
                        throw new DapException("Unrecognized request extension").setCode(400);
                    }
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            int code = 400;
            if (t instanceof DapException) {
                DapException e = (DapException)t;
                code = e.getCode();
                if (code <= 0) {
                    code = 400;
                }
                e.setCode(code);
            } else {
                code = t instanceof FileNotFoundException ? 404 : (t instanceof UnsupportedOperationException ? 403 : (t instanceof MalformedURLException ? 404 : (t instanceof IOException ? 400 : 500)));
            }
            this.senderror(daprequest, code, t);
        }
    }

    protected void doDSR(DapRequest drq, DapContext cxt) throws IOException {
        try {
            DapDSR dsrbuilder = new DapDSR(drq, cxt);
            String dsr = dsrbuilder.generate(drq.getFormat(), drq.getDatasetPath(), drq.getDataset());
            OutputStream out = drq.getOutputStream();
            this.addCommonHeaders(drq);
            ByteOrder order = (ByteOrder)cxt.get((Object)"ucar.littleendian");
            ChunkWriter cw = new ChunkWriter(out, RequestMode.DSR, order);
            cw.writeDSR(dsr);
            cw.close();
        }
        catch (IOException ioe) {
            throw new DapException("DSR generation error", (Throwable)ioe).setCode(500);
        }
    }

    protected void doDMR(DapRequest drq, DapContext cxt) throws IOException {
        String realpath = drq.getResourcePath(drq.getDatasetPath());
        CDMWrap c4 = new CDMWrap().open(realpath);
        DapDataset dmr = c4.getDMR();
        CEConstraint ce = this.constrainDapContext(cxt, dmr);
        ChecksumMode csummode = (ChecksumMode)cxt.get((Object)"dap4.checksum");
        ByteOrder order = (ByteOrder)cxt.get((Object)"ucar.littleendian");
        if (csummode == ChecksumMode.TRUE) {
            Map<DapVariable, Long> checksummap = this.computeDMRChecksums(c4, cxt);
            cxt.put((Object)"checksummap", checksummap);
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        DMRPrinter dapprinter = new DMRPrinter(dmr, ce, pw, drq.getFormat(), cxt);
        dapprinter.print();
        pw.close();
        sw.close();
        String sdmr = sw.toString();
        if (DEBUG) {
            System.err.println("Sending: DMR:\n" + sdmr);
        }
        this.addCommonHeaders(drq);
        OutputStream out = drq.getOutputStream();
        ChunkWriter cw = new ChunkWriter(out, RequestMode.DMR, order);
        cw.cacheDMR(sdmr);
        cw.close();
        c4.close();
    }

    protected void doData(DapRequest drq, DapContext cxt) throws IOException {
        String realpath = drq.getResourcePath(drq.getDatasetPath());
        CDMWrap c4 = new CDMWrap().open(realpath);
        if (c4 == null) {
            throw new DapException("No such file: " + realpath);
        }
        DapDataset dmr = c4.getDMR();
        CEConstraint ce = this.constrainDapContext(cxt, dmr);
        ChecksumMode csummode = (ChecksumMode)cxt.get((Object)"dap4.checksum");
        ByteOrder order = (ByteOrder)cxt.get((Object)"ucar.littleendian");
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        if (csummode == ChecksumMode.TRUE) {
            Map<DapVariable, Long> checksummap = this.computeDMRChecksums(c4, cxt);
            cxt.put((Object)"checksummap", checksummap);
        }
        DMRPrinter dapprinter = new DMRPrinter(dmr, ce, pw, drq.getFormat(), cxt);
        dapprinter.print();
        pw.close();
        sw.close();
        OutputStream out = drq.getOutputStream();
        ChunkWriter cw = new ChunkWriter(out, RequestMode.DAP, order);
        cw.setWriteLimit(this.getBinaryWriteLimit());
        String sdmr = sw.toString();
        cw.cacheDMR(sdmr);
        cw.flush();
        this.addCommonHeaders(drq);
        switch (drq.getFormat()) {
            case TEXT: 
            case XML: 
            case HTML: {
                throw new IOException("Unsupported return format: " + drq.getFormat());
            }
        }
        DapSerializer writer = new DapSerializer(c4, ce, cw, order, drq.getChecksumMode());
        writer.write(c4.getDMR());
        cw.flush();
        cw.close();
        c4.close();
    }

    protected void addCommonHeaders(DapRequest drq) throws DapException {
        DapProtocol.ContentType contenttype;
        RequestMode mode;
        ResponseFormat format = drq.getFormat();
        if (format == null) {
            format = ResponseFormat.NONE;
        }
        if ((mode = drq.getMode()) == null) {
            mode = RequestMode.CAPABILITIES;
        }
        if ((contenttype = (DapProtocol.ContentType)DapProtocol.contenttypes.get(DapProtocol.contentKey((RequestMode)mode, (ResponseFormat)format))) == null) {
            throw new DapException("Cannot find Content-Type for: " + mode.id() + "," + format.id()).setCode(400);
        }
        drq.setResponseHeader("Content-Description", contenttype.contenttype);
        Object header = contenttype.mimetype;
        header = (String)header + "; charset=utf-8";
        drq.setResponseHeader("Content-Type", (String)header);
    }

    protected DapRequest getRequestState(HttpServletRequest rq, HttpServletResponse rsp) throws IOException {
        return new DapRequest(this, rq, rsp);
    }

    protected void senderror(DapRequest drq, int httpcode, Throwable t) throws IOException {
        if (httpcode == 0) {
            httpcode = 400;
        }
        ErrorResponse err = new ErrorResponse();
        err.setCode(httpcode);
        if (t == null) {
            err.setMessage("Servlet error: " + drq.getURL());
        } else {
            StringWriter sw = new StringWriter();
            PrintWriter p = new PrintWriter(sw);
            t.printStackTrace(p);
            p.close();
            sw.close();
            err.setMessage(sw.toString());
        }
        err.setContext(drq.getURL());
        String errormsg = err.buildXML();
        OutputStream out = drq.getOutputStream();
        PrintWriter prw = new PrintWriter(new OutputStreamWriter(out, DapUtil.UTF8));
        prw.println(errormsg);
        prw.flush();
    }

    public DapContext buildDapContext(DapRequest daprequest) throws DapException {
        DapContext dapcxt = new DapContext();
        dapcxt.put(DapRequest.class, (Object)daprequest);
        ByteOrder order = daprequest.getOrder();
        if (order != null) {
            dapcxt.put((Object)"ucar.littleendian", (Object)order);
            ChecksumMode checksummode = daprequest.getChecksumMode();
            if (checksummode != null) {
                dapcxt.put((Object)"dap4.checksum", (Object)ChecksumMode.asTrueFalse((ChecksumMode)checksummode));
            }
            Map<String, String> queries = daprequest.getQueries();
            for (Map.Entry<String, String> entry : queries.entrySet()) {
                if (dapcxt.get((Object)entry.getKey()) != null) continue;
                dapcxt.put((Object)entry.getKey(), (Object)entry.getValue());
            }
        }
        return dapcxt;
    }

    public CEConstraint constrainDapContext(DapContext dapcxt, DapDataset dmr) throws DapException {
        DapRequest drq = (DapRequest)dapcxt.get(DapRequest.class);
        String sce = drq.queryLookup("dap4.ce");
        CEConstraint ce = CEConstraint.compile((String)sce, (DapDataset)dmr);
        dapcxt.put(CEConstraint.class, (Object)ce);
        return ce;
    }

    protected Map<DapVariable, Long> computeDMRChecksums(CDMWrap c4, DapContext cxt) throws DapException {
        ByteOrder order = (ByteOrder)cxt.get((Object)"ucar.littleendian");
        ChecksumMode csum = (ChecksumMode)cxt.get((Object)"dap4.checksum");
        CEConstraint ce = (CEConstraint)cxt.get(CEConstraint.class);
        NullOutputStream out = new NullOutputStream();
        DapDataset dmr = ce.getDMR();
        try {
            ChunkWriter cw = new ChunkWriter(out, RequestMode.DAP, order);
            cw.cacheDMR(dmr, cxt);
            cw.setWriteLimit(1000000000L);
            DapSerializer writer = new DapSerializer(c4, ce, cw, order, csum);
            writer.write(dmr);
            cw.flush();
            cw.close();
            return writer.getChecksums();
        }
        catch (IOException ioe) {
            throw new DapException((Throwable)ioe);
        }
    }
}

