/*
 * Decompiled with CFR 0.152.
 */
package dap4.servlet;

import dap4.core.ce.CEConstraint;
import dap4.core.dmr.DapDataset;
import dap4.core.dmr.DapNode;
import dap4.core.dmr.DapSequence;
import dap4.core.dmr.DapStructure;
import dap4.core.dmr.DapType;
import dap4.core.dmr.DapVariable;
import dap4.core.interfaces.ArrayScheme;
import dap4.core.util.ChecksumMode;
import dap4.core.util.DapException;
import dap4.dap4lib.D4Index;
import dap4.servlet.CDMData;
import dap4.servlet.CDMWrap;
import dap4.servlet.Odometer;
import dap4.servlet.OdometerFactory;
import dap4.servlet.SerialWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ucar.ma2.Index;

public class DapSerializer {
    protected OutputStream stream = null;
    protected SerialWriter writer = null;
    protected CDMWrap cdmwrap = null;
    protected CEConstraint ce = null;
    protected ByteOrder order = null;
    protected ChecksumMode checksummode = null;
    protected Map<DapVariable, Long> checksums = null;

    public DapSerializer() {
    }

    public DapSerializer(CDMWrap c4, CEConstraint constraint, OutputStream stream, ByteOrder order, ChecksumMode mode) throws IOException {
        this.cdmwrap = c4;
        this.order = order;
        this.checksummode = mode;
        this.stream = stream;
        this.ce = constraint;
    }

    public Map<DapVariable, Long> getChecksums() {
        return this.checksums;
    }

    public void write(DapDataset dmr) throws IOException {
        this.writer = new SerialWriter(this.stream, this.order, this.checksummode);
        this.writer.flush();
        for (DapVariable var : dmr.getTopVariables()) {
            if (!this.ce.references((DapNode)var) || var.getCount() == 0L) continue;
            CDMData vardata = this.cdmwrap.getVariableData(var);
            if (vardata == null) {
                throw new DapException("DapSerializer: cannot find  Variable data " + var.getFQN());
            }
            this.writeVariable(vardata, this.writer);
        }
    }

    protected void writeVariable(CDMData data, SerialWriter dst) throws IOException {
        DapVariable template = (DapVariable)data.getTemplate();
        dst.startVariable();
        switch (data.getScheme()) {
            case ATOMIC: {
                this.writeAtomicVariable(data, dst);
                break;
            }
            case STRUCTARRAY: {
                this.writeStructure(data, dst);
                break;
            }
            case SEQARRAY: {
                this.writeSequence(data, dst);
                break;
            }
            default: {
                assert (false) : "Unexpected variable type: " + data.toString();
                break;
            }
        }
        dst.endVariable();
        if (this.checksummode == ChecksumMode.TRUE) {
            if (this.checksums == null) {
                this.checksums = new HashMap<DapVariable, Long>();
            }
            long checksum = dst.getLastChecksum();
            this.checksums.put(template, checksum);
        }
    }

    protected void writeAtomicVariable(CDMData data, SerialWriter dst) throws IOException {
        DapVariable template = (DapVariable)data.getTemplate();
        assert (this.ce.references((DapNode)template));
        DapType basetype = template.getBaseType();
        List slices = this.ce.getConstrainedSlices(template);
        if (slices == null) {
            throw new DapException("Unknown variable: " + template.getFQN());
        }
        Object values = data.read(slices);
        dst.writeAtomicArray(basetype, values);
    }

    protected void writeStructure(CDMData data, SerialWriter dst) throws IOException {
        DapVariable template = (DapVariable)data.getTemplate();
        DapStructure ds = (DapStructure)template.getBaseType();
        assert (this.ce.references((DapNode)template));
        List slices = this.ce.getConstrainedSlices(template);
        Odometer odom = OdometerFactory.factory(slices, template.getDimensions());
        while (odom.hasNext()) {
            D4Index index = odom.next();
            CDMData[] instance = (CDMData[])data.read((Index)index);
            this.writeStructure1(instance[0], dst);
        }
    }

    protected void writeStructure1(CDMData instance, SerialWriter dst) throws IOException {
        assert (instance.getScheme() == ArrayScheme.STRUCTURE);
        DapVariable template = (DapVariable)instance.getTemplate();
        assert (this.ce.references((DapNode)template));
        DapStructure ds = (DapStructure)template.getBaseType();
        List fields = ds.getFields();
        for (int i = 0; i < fields.size(); ++i) {
            DapVariable field = (DapVariable)fields.get(i);
            if (!this.ce.references((DapNode)field)) continue;
            CDMData df = instance.readField(i);
            this.writeVariable(df, dst);
        }
    }

    protected void writeSequence(CDMData data, SerialWriter dst) throws IOException {
        DapVariable template = (DapVariable)data.getTemplate();
        DapSequence ds = (DapSequence)template.getBaseType();
        assert (this.ce.references((DapNode)template));
        List slices = this.ce.getConstrainedSlices(template);
        Odometer odom = OdometerFactory.factory(slices, template.getDimensions());
        CDMData[] instances = (CDMData[])data.read(slices);
        for (int i = 0; i < instances.length; ++i) {
            this.writeSequence1(instances[i], dst);
        }
    }

    protected void writeSequence1(CDMData instance, SerialWriter dst) throws IOException {
        DapVariable template = (DapVariable)instance.getTemplate();
        DapSequence seq = (DapSequence)template.getBaseType();
        assert (this.ce.references((DapNode)template));
        long nrecs = instance.getRecordCount();
        dst.writeCount(nrecs);
        for (long i = 0L; i < nrecs; ++i) {
            CDMData record = instance.readRecord(i);
            this.writeRecord(record, dst);
        }
    }

    protected void writeRecord(CDMData record, SerialWriter dst) throws IOException {
        DapVariable template = (DapVariable)record.getTemplate();
        DapSequence seq = (DapSequence)template.getBaseType();
        List fields = seq.getFields();
        for (int i = 0; i < fields.size(); ++i) {
            DapVariable field = (DapVariable)fields.get(i);
            if (!this.ce.references((DapNode)field)) continue;
            CDMData df = record.readField(i);
            this.writeVariable(df, dst);
        }
    }
}

