/*
 * Decompiled with CFR 0.152.
 */
package dap4.servlet;

import dap4.core.util.DapContext;
import dap4.core.util.DapException;
import dap4.core.util.DapUtil;
import dap4.core.util.ResponseFormat;
import dap4.servlet.DapRequest;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.commons.lang3.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DapDSR {
    static final boolean DEBUG = false;
    static final String DSRXMLTEMPLATE = "/templates/dap4.dsr.xml.template";
    static final String DSRHTMLTEMPLATE = "/templates/dap4.dsr.html.template";
    static final String URL_FORMAT = "://%s/%s/%s";
    Logger logger = LoggerFactory.getLogger(DapDSR.class);
    private static String dap4TestServerPropName = "d4ts";
    public static String dap4TestServer = null;
    protected static String servletprefix = null;
    protected static String servletsuffix = null;
    DapRequest drq;
    DapContext cxt;

    public DapDSR(DapRequest drq, DapContext cxt) throws IOException {
        this.drq = drq;
        this.cxt = cxt;
        if (dap4TestServer == null) {
            try {
                URL url = new URL(drq.getRequest().getRequestURL().toString());
                dap4TestServer = url.getHost();
                if (url.getPort() > 0) {
                    dap4TestServer = dap4TestServer + ":" + url.getPort();
                }
                servletprefix = drq.getRequest().getContextPath();
                servletprefix = DapUtil.relativize((String)servletprefix);
                servletsuffix = drq.getRequest().getServletPath();
            }
            catch (MalformedURLException mue) {
                throw new DapException((Throwable)mue).setCode(500);
            }
        }
        if (dap4TestServer == null) {
            throw new DapException("Cannot determine test server host").setCode(500);
        }
        if (servletprefix == null) {
            throw new DapException("Cannot determine test servlet prefix").setCode(500);
        }
        if (servletsuffix == null) {
            throw new DapException("Cannot determine test servlet suffix").setCode(500);
        }
    }

    public String generate(ResponseFormat format, String datasetpath, String dataset) throws IOException {
        datasetpath = DapUtil.relativize((String)datasetpath);
        String template = this.getTemplate(format);
        StringBuilder dsr = new StringBuilder(template);
        this.substitute(dsr, "DAP_VERSION", "4.0");
        this.substitute(dsr, "DAP_SERVER", "TDS-5");
        this.substitute(dsr, "DATASET", dataset);
        String scheme = "http";
        try {
            scheme = new URI(this.drq.getRequest().getRequestURL().toString()).getScheme();
        }
        catch (URISyntaxException e) {
            this.logger.debug("error determining scheme from request url - defaulting to http");
        }
        Object[] objectArray = new Object[3];
        objectArray[0] = dap4TestServer;
        objectArray[1] = servletprefix;
        objectArray[2] = datasetpath;
        String url = String.format(scheme + URL_FORMAT, objectArray);
        this.substitute(dsr, "URL", url);
        return dsr.toString();
    }

    protected String getTemplate(ResponseFormat format) throws IOException {
        StringBuilder buf = new StringBuilder();
        String template = null;
        switch (format) {
            case XML: {
                template = DSRXMLTEMPLATE;
                break;
            }
            case NONE: 
            case HTML: {
                template = DSRHTMLTEMPLATE;
                break;
            }
            default: {
                throw new IOException("Unsupported DSR Response Format: " + format.toString());
            }
        }
        String templatepath = this.drq.getWebContentPath(template);
        try (FileInputStream stream = new FileInputStream(templatepath);){
            int ch;
            while ((ch = ((InputStream)stream).read()) >= 0) {
                buf.append((char)ch);
            }
        }
        return buf.toString();
    }

    protected void substitute(StringBuilder buf, String macro, String value) {
        int index;
        value = StringEscapeUtils.escapeHtml4((String)value);
        int from = 0;
        String tag = "${" + macro + "}";
        int taglen = tag.length();
        int valuelen = value.length();
        while ((index = buf.indexOf(tag, from)) >= 0) {
            buf.replace(index, index + taglen, value);
            from = index + valuelen;
        }
    }

    static {
        String d4ts = System.getProperty(dap4TestServerPropName);
        if (d4ts != null && d4ts.length() > 0) {
            dap4TestServer = d4ts;
        }
    }
}

