/*
 * Decompiled with CFR 0.152.
 */
package dap4.servlet;

import dap4.core.dmr.DapDimension;
import dap4.core.util.DapException;
import dap4.core.util.DapUtil;
import dap4.core.util.Slice;
import dap4.servlet.MultiOdometer;
import dap4.servlet.Odometer;
import dap4.servlet.ScalarOdometer;
import java.util.List;

public abstract class OdometerFactory {
    public static Odometer factoryScalar() {
        return new ScalarOdometer();
    }

    public static Odometer factory(List<Slice> slices) throws DapException {
        return OdometerFactory.factory(slices, null);
    }

    public static Odometer factory(List<Slice> slices, List<DapDimension> dimset) throws DapException {
        if (dimset != null && dimset.size() == 0) {
            if (!DapUtil.isScalarSlices(slices)) {
                throw new DapException("Cannot build scalar odometer with non-scalar slices");
            }
            return OdometerFactory.factoryScalar();
        }
        boolean multi = false;
        if (slices != null) {
            for (int i = 0; i < slices.size(); ++i) {
                if (slices.get(i).getSort() != Slice.Sort.Multi) continue;
                multi = true;
                break;
            }
        }
        if (slices == null || slices.size() == 0) {
            return OdometerFactory.factoryScalar();
        }
        if (multi) {
            return new MultiOdometer(slices, dimset);
        }
        return new Odometer(slices, dimset);
    }
}

