/*
 * Decompiled with CFR 0.152.
 */
package dap4.ce;

import dap4.core.dmr.DapAttribute;
import dap4.core.dmr.DapDataset;
import dap4.core.dmr.DapDimension;
import dap4.core.dmr.DapEnum;
import dap4.core.dmr.DapGroup;
import dap4.core.dmr.DapNode;
import dap4.core.dmr.DapStructure;
import dap4.core.dmr.DapType;
import dap4.core.dmr.DapVariable;
import dap4.core.util.DapException;
import dap4.core.util.DapSort;
import dap4.core.util.DapUtil;
import dap4.core.util.Slice;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CEConstraint {
    public static final boolean EXPAND = true;
    static final String LBRACE = "{";
    static final String RBRACE = "}";
    protected DapDataset dmr = null;
    protected List<Segment> variables = new ArrayList<Segment>();
    protected Map<DapDimension, Slice> redefslice = new HashMap<DapDimension, Slice>();
    protected Map<DapNode, List<DapAttribute>> attributes = new HashMap<DapNode, List<DapAttribute>>();
    protected Map<DapDimension, DapDimension> redef = new HashMap<DapDimension, DapDimension>();
    protected List<DapDimension> dimrefs = new ArrayList<DapDimension>();
    protected List<DapEnum> enums = new ArrayList<DapEnum>();
    protected List<DapGroup> groups = new ArrayList<DapGroup>();
    protected List<DapDimension> refdims = new ArrayList<DapDimension>();
    protected boolean finished = false;

    public static CEConstraint getUniversal(DapDataset dmr) {
        return new Universal(dmr);
    }

    public CEConstraint() {
    }

    public CEConstraint(DapDataset dmr) {
        this.dmr = dmr;
    }

    public DapDataset getDMR() {
        return this.dmr;
    }

    public void addRedef(DapDimension dim, Slice slice) {
        this.redefslice.put(dim, slice);
    }

    public void addVariable(DapVariable var, List<Slice> slices) {
        if (this.findVariable(var) < 0) {
            this.variables.add(new Segment(var, slices));
        }
    }

    public void addAttribute(DapNode node, DapAttribute attr) {
        List<DapAttribute> attrs = this.attributes.get(node);
        if (attrs == null) {
            attrs = new ArrayList<DapAttribute>();
            this.attributes.put(node, attrs);
        }
        attrs.add(attr);
    }

    public DapDimension getRedefDim(DapDimension orig) {
        return this.redef.get(orig);
    }

    public List<Slice> getVariableSlices(DapVariable var) {
        int index = this.findVariable(var);
        if (index < 0) {
            return null;
        }
        return this.variables.get((int)index).slices;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        boolean first = true;
        for (int i = 0; i < this.variables.size(); ++i) {
            Segment seg = this.variables.get(i);
            if (!seg.var.isTopLevel()) continue;
            if (!first) {
                buf.append(";");
            }
            first = false;
            this.dumpvar(seg, buf, false);
        }
        return buf.toString();
    }

    public boolean references(DapNode node) {
        boolean isref = false;
        switch (node.getSort()) {
            case DIMENSION: {
                DapDimension dim = this.redef.get((DapDimension)node);
                if (dim == null) {
                    dim = (DapDimension)node;
                }
                isref = this.dimrefs.contains(dim);
                break;
            }
            case ENUMERATION: {
                isref = this.enums.contains((DapEnum)node);
                break;
            }
            case ATOMICVARIABLE: 
            case GRID: 
            case SEQUENCE: 
            case STRUCTURE: {
                isref = this.findVariable((DapVariable)node) >= 0;
                break;
            }
            case GROUP: 
            case DATASET: {
                isref = this.groups.contains((DapGroup)node);
                break;
            }
        }
        return isref;
    }

    public CEConstraint finish(boolean expand) throws DapException {
        if (!this.finished) {
            this.finished = true;
            this.expandCompoundTypes();
            this.computeenums();
            this.computedimensions();
            this.computegroups();
        }
        return this;
    }

    public String toConstraintString() {
        StringBuilder buf = new StringBuilder();
        boolean first = true;
        for (int i = 0; i < this.variables.size(); ++i) {
            Segment seg = this.variables.get(i);
            if (!seg.var.isTopLevel()) continue;
            if (!first) {
                buf.append(";");
            }
            first = false;
            this.dumpvar(seg, buf, true);
        }
        return buf.toString();
    }

    protected void dumpvar(Segment seg, StringBuilder buf, boolean forconstraint) {
        if (seg.var.isTopLevel()) {
            buf.append(seg.var.getFQN());
        } else {
            buf.append(seg.var.getShortName());
        }
        List<Slice> slices = seg.slices;
        List dimset = seg.var.getDimensions();
        if (slices != null) assert (dimset.size() == slices.size());
        for (int i = 0; i < dimset.size(); ++i) {
            Slice slice = slices.get(i);
            DapDimension dim = (DapDimension)dimset.get(i);
            if (!slice.isConstrained().booleanValue() && slice.isWhole().booleanValue()) {
                buf.append("[]");
                continue;
            }
            buf.append(forconstraint ? slice.toConstraintString() : slice.toString());
        }
        if (seg.var.getSort() == DapSort.ATOMICVARIABLE) {
            return;
        }
        if (seg.var.getSort() == DapSort.STRUCTURE && this.isWholeStructure((DapStructure)seg.var)) {
            return;
        }
        buf.append(LBRACE);
        DapStructure struct = (DapStructure)seg.var;
        boolean first = true;
        for (DapVariable field : struct.getFields()) {
            if (!first) {
                buf.append(";");
            }
            first = false;
            Segment fseg = this.getVariable(field);
            this.dumpvar(fseg, buf, forconstraint);
        }
        buf.append(RBRACE);
    }

    protected int findVariable(DapVariable var) {
        for (int i = 0; i < this.variables.size(); ++i) {
            if (this.variables.get((int)i).var != var) continue;
            return i;
        }
        return -1;
    }

    protected Segment getVariable(DapVariable var) {
        for (int i = 0; i < this.variables.size(); ++i) {
            if (this.variables.get((int)i).var != var) continue;
            return this.variables.get(i);
        }
        return null;
    }

    protected boolean isWholeStructure(DapStructure struct) {
        for (DapVariable field : struct.getFields()) {
            if (this.findVariable(field) < 0) {
                return false;
            }
            if (field.getSort() != DapSort.STRUCTURE || this.isWholeStructure((DapStructure)field)) continue;
            return false;
        }
        return true;
    }

    protected void expandCompoundTypes() {
        ArrayDeque<DapVariable> queue = new ArrayDeque<DapVariable>();
        for (int i = 0; i < this.variables.size(); ++i) {
            DapStructure struct;
            Segment seg = this.variables.get(i);
            if (!seg.var.isTopLevel() || seg.var.getSort() != DapSort.STRUCTURE && seg.var.getSort() != DapSort.SEQUENCE || this.expansionCount(struct = (DapStructure)seg.var) != 0) continue;
            queue.add(seg.var);
        }
        while (queue.size() > 0) {
            DapVariable vvstruct = (DapVariable)queue.remove();
            DapStructure dstruct = (DapStructure)vvstruct;
            for (DapVariable field : dstruct.getFields()) {
                if (this.findVariable(field) < 0) {
                    this.variables.add(new Segment(field, null));
                }
                if (field.getSort() != DapSort.STRUCTURE && field.getSort() != DapSort.SEQUENCE || this.expansionCount((DapStructure)field) != 0) continue;
                queue.add(field);
            }
        }
    }

    protected int expansionCount(DapStructure struct) {
        int count = 0;
        for (DapVariable field : struct.getFields()) {
            if (this.findVariable(field) < 0) continue;
            ++count;
        }
        return count;
    }

    protected void computedimensions() throws DapException {
        for (DapDimension key : this.redefslice.keySet()) {
            Slice slice = this.redefslice.get(key);
            DapDimension newdim = (DapDimension)key.clone();
            newdim.setSize(slice.getCount());
            this.redef.put(key, newdim);
        }
        for (int i = 0; i < this.variables.size(); ++i) {
            Segment seg = this.variables.get(i);
            if (seg.var.getRank() == 0) continue;
            List<Slice> slices = seg.slices;
            List orig = seg.var.getDimensions();
            if (slices == null) {
                slices = new ArrayList<Slice>();
            }
            while (slices.size() < orig.size()) {
                slices.add(new Slice().setConstrained(Boolean.valueOf(false)));
            }
            assert (slices != null && slices.size() == orig.size());
            for (int j = 0; j < slices.size(); ++j) {
                Slice slice = slices.get(j);
                DapDimension dim0 = (DapDimension)orig.get(j);
                DapDimension newdim = this.redef.get(dim0);
                if (newdim == null) {
                    newdim = dim0;
                }
                if (slice.incomplete()) {
                    slice.complete(newdim);
                }
                Slice newslice = null;
                if (slice.isConstrained().booleanValue() || (newslice = new Slice().fill(newdim)) == null) continue;
                if (!this.dimrefs.contains(dim0)) {
                    this.dimrefs.add(dim0);
                }
                slices.set(j, newslice);
            }
        }
    }

    protected void computeenums() {
        for (int i = 0; i < this.variables.size(); ++i) {
            DapType daptype;
            Segment seg = this.variables.get(i);
            if (seg.var.getSort() != DapSort.ATOMICVARIABLE || !(daptype = seg.var.getBaseType()).isEnumType() || this.enums.contains((DapEnum)daptype)) continue;
            this.enums.add((DapEnum)daptype);
        }
    }

    protected void computegroups() {
        List path;
        for (int i = 0; i < this.variables.size(); ++i) {
            DapVariable var = this.variables.get((int)i).var;
            path = var.getGroupPath();
            for (DapGroup group : path) {
                if (this.groups.contains(group)) continue;
                this.groups.add(group);
            }
        }
        for (DapDimension dim : this.dimrefs) {
            if (!dim.isShared()) continue;
            path = dim.getGroupPath();
            for (DapGroup group : path) {
                if (this.groups.contains(group)) continue;
                this.groups.add(group);
            }
        }
        for (DapEnum en : this.enums) {
            path = en.getGroupPath();
            for (DapGroup group : path) {
                if (this.groups.contains(group)) continue;
                this.groups.add(group);
            }
        }
    }

    protected static class Segment {
        DapVariable var;
        List<Slice> slices;

        Segment(DapVariable var, List<Slice> slices) {
            this.var = var;
            this.slices = slices;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append(this.var.getFQN());
            if (this.slices != null) {
                for (int i = 0; i < this.slices.size(); ++i) {
                    buf.append(this.slices.get(i).toString());
                }
            }
            return buf.toString();
        }
    }

    protected static class Universal
    extends CEConstraint {
        public Universal(DapDataset dmr) {
            super(dmr);
        }

        @Override
        public void addRedef(DapDimension dim, Slice slice) {
        }

        @Override
        public void addVariable(DapVariable var, List<Slice> slices) {
        }

        @Override
        public void addAttribute(DapNode node, DapAttribute attr) {
        }

        @Override
        public DapDimension getRedefDim(DapDimension orig) {
            return null;
        }

        @Override
        public List<Slice> getVariableSlices(DapVariable var) {
            try {
                return DapUtil.dimsetSlices((List)var.getDimensions());
            }
            catch (DapException de) {
                return null;
            }
        }

        @Override
        public boolean references(DapNode node) {
            switch (node.getSort()) {
                case DIMENSION: 
                case ENUMERATION: 
                case ATOMICVARIABLE: 
                case GRID: 
                case SEQUENCE: 
                case STRUCTURE: 
                case GROUP: 
                case DATASET: {
                    return true;
                }
            }
            return false;
        }
    }
}

