/*
 * Decompiled with CFR 0.152.
 */
package dap4.ce.parser;

import dap4.core.util.Slice;
import java.util.ArrayList;
import java.util.Map;

public class CEAST {
    Sort sort = null;
    NodeList clauses = null;
    Map<String, Slice> dimdefs = null;
    CEAST tree = null;
    String name = null;
    boolean isleaf = true;
    SliceList slices = null;
    NodeList subnodes = null;
    CEAST projection = null;
    CEAST filter = null;
    Operator op = null;
    CEAST lhs = null;
    CEAST rhs = null;
    Constant kind = null;
    Object value = null;
    Slice slice = null;

    public CEAST(Sort sort) {
        this.sort = sort;
    }

    void addSegment(CEAST segment) {
        assert (this.sort == Sort.SEGMENT);
        if (this.subnodes == null) {
            this.subnodes = new NodeList();
        }
        this.subnodes.add(segment);
    }

    static void toString(CEAST node, StringBuilder buf) {
        if (node == null) {
            return;
        }
        switch (node.sort) {
            case CONSTRAINT: {
                boolean first = true;
                for (CEAST elem : node.clauses) {
                    if (!first) {
                        buf.append(";");
                    }
                    CEAST.toString(elem, buf);
                    first = false;
                }
                break;
            }
            case PROJECTION: {
                CEAST.toString(node.tree, buf);
                break;
            }
            case SELECTION: {
                CEAST.toString(node.projection, buf);
                buf.append("|");
                CEAST.toString(node.filter, buf);
                break;
            }
            case SEGMENT: {
                buf.append(node.name);
                if (node.slice != null) {
                    buf.append(node.slice.toString());
                }
                if (node.subnodes == null) break;
                buf.append(".{");
                boolean first = true;
                for (CEAST subnode : node.subnodes) {
                    if (!first) {
                        buf.append(",");
                    } else {
                        first = false;
                    }
                    buf.append(subnode.toString());
                }
                buf.append("}");
                break;
            }
            case EXPR: 
            case CONSTANT: 
            case DEFINE: {
                buf.append(node.name);
                if (node.slice == null) break;
                buf.append(node.slice.toString());
            }
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        CEAST.toString(this, buf);
        return buf.toString();
    }

    public static enum Constant {
        STRING,
        LONG,
        DOUBLE,
        BOOLEAN;

    }

    public static enum Operator {
        LT,
        LE,
        GT,
        GE,
        EQ,
        NEQ,
        REQ,
        AND;

    }

    public static enum Sort {
        CONSTRAINT,
        PROJECTION,
        SEGMENT,
        SELECTION,
        EXPR,
        CONSTANT,
        DEFINE;

    }

    public static class SliceList
    extends ArrayList<Slice> {
    }

    public static class StringList
    extends ArrayList<String> {
    }

    public static class Path
    extends NodeList {
    }

    public static class NodeList
    extends ArrayList<CEAST> {
    }
}

