/*
 * Decompiled with CFR 0.152.
 */
package dap4.ce.parser;

import dap4.ce.CEConstraint;
import dap4.ce.parser.CEAST;
import dap4.core.dmr.DapDataset;
import dap4.core.dmr.DapDimension;
import dap4.core.dmr.DapNode;
import dap4.core.dmr.DapSequence;
import dap4.core.dmr.DapStructure;
import dap4.core.dmr.DapVariable;
import dap4.core.util.DapException;
import dap4.core.util.DapSort;
import dap4.core.util.Slice;
import java.util.EnumSet;
import java.util.List;
import java.util.Stack;

public class CECompiler {
    protected Stack<DapVariable> scopestack = null;
    protected DapDataset dataset = null;
    protected CEConstraint ce = null;
    protected CEAST root = null;

    public CEConstraint compile(DapDataset template, CEAST root) throws DapException {
        this.dataset = template;
        this.root = root;
        this.ce = new CEConstraint(this.dataset);
        this.scopestack = new Stack();
        this.compileAST(root);
        return this.ce;
    }

    void compileAST(CEAST ast) throws DapException {
        switch (ast.sort) {
            case CONSTRAINT: {
                for (CEAST clause : ast.clauses) {
                    this.compileAST(clause);
                }
                this.ce.finish(true);
                break;
            }
            case PROJECTION: {
                this.scopestack.clear();
                this.compileAST(ast.tree);
                break;
            }
            case SEGMENT: {
                this.compilesegment(ast);
                break;
            }
            case SELECTION: {
                break;
            }
            case EXPR: {
                break;
            }
            case CONSTANT: {
                break;
            }
            case DEFINE: {
                this.dimredef(ast);
                break;
            }
            default: {
                assert (false) : "uknown CEAST node type";
                break;
            }
        }
    }

    void compilesegment(CEAST ast) throws DapException {
        DapVariable parent = this.getParent();
        Object node = null;
        if (parent == null) {
            List matches = this.dataset.findByFQN(ast.name, EnumSet.of(DapSort.ATOMICVARIABLE, DapSort.SEQUENCE, DapSort.STRUCTURE));
            if (matches.size() > 1) {
                throw new DapException("Multiply defined variable name: " + ast.name);
            }
            node = matches.size() == 0 ? null : (DapNode)matches.get(0);
        } else if (parent.getSort() == DapSort.STRUCTURE) {
            DapStructure struct = (DapStructure)parent;
            node = struct.findByName(ast.name);
        } else if (parent.getSort() == DapSort.SEQUENCE) {
            DapSequence seq = (DapSequence)parent;
            node = seq.findByName(ast.name);
        } else {
            throw new DapException("Attempt to treat non-structure object as structure: " + parent.getFQN());
        }
        if (node == null) {
            throw new DapException("Constraint projection does not reference a known variable: " + ast.name);
        }
        if (!(node instanceof DapVariable)) {
            throw new DapException("Attempt to use non-variable in projection: " + node.getFQN());
        }
        DapVariable var = node;
        this.ce.addVariable(var, ast.slices);
        this.scopestack.push(var);
    }

    void dimredef(CEAST node) throws DapException {
        DapDimension dim = (DapDimension)this.dataset.findByFQN(node.name, DapSort.DIMENSION);
        if (dim == null) {
            throw new DapException("Constraint dim redef: no dimension name: " + node.name);
        }
        Slice slice = node.slice;
        slice.validate();
        this.ce.addRedef(dim, slice);
    }

    DapVariable getParent() {
        if (this.scopestack.size() > 0) {
            return this.scopestack.peek();
        }
        return null;
    }
}

