/*
 * Decompiled with CFR 0.152.
 */
package dap4.ce.parser;

import dap4.ce.parser.CEParser;
import dap4.ce.parser.CEParserBody;
import dap4.core.dmr.parser.ParseException;

class CELexer
implements CEParserBody.Lexer {
    static final String DELIMS = "[].:,;";
    static final char ESCAPE = '\\';
    static final char EOS = '\u0000';
    static final int CONTEXTLEN = 20;
    static final String hexdigits = "0123456789abcdefABCDEF";
    static final String[] keywords = new String[0];
    static final int[] keytokens = new int[0];
    CEParser parsestate = null;
    Object lval = null;
    TextStream text = new TextStream();
    int charno = 0;
    int lineno = 0;
    StringBuilder yytext = new StringBuilder();

    public CELexer(CEParser state) {
        this();
        this.setParser(state);
    }

    public CELexer() {
    }

    void setParser(CEParser state) {
        this.parsestate = state;
    }

    void setText(String text) {
        this.text.setText(text);
    }

    public String getInput() {
        return this.text.getText();
    }

    @Override
    public int yylex() throws ParseException {
        int c = 0;
        int token = 0;
        this.yytext.setLength(0);
        this.text.mark();
        token = -1;
        while (token < 0 && (c = this.text.read()) != 0) {
            if (c <= 32 || c == 127) continue;
            if (c == 34 || c == 39) {
                int delim = c;
                boolean more = true;
                while (more && (c = this.text.read()) > 0) {
                    block1 : switch (c) {
                        case 0: {
                            throw new ParseException("Unterminated character or string constant");
                        }
                        case 34: {
                            more = delim != c;
                            break;
                        }
                        case 39: {
                            more = delim != c;
                            break;
                        }
                        case 92: {
                            switch (c) {
                                case 114: {
                                    c = 13;
                                    break block1;
                                }
                                case 110: {
                                    c = 10;
                                    break block1;
                                }
                                case 102: {
                                    c = 12;
                                    break block1;
                                }
                                case 116: {
                                    c = 9;
                                    break block1;
                                }
                            }
                            break;
                        }
                    }
                    if (!more) continue;
                    this.yytext.append((char)c);
                }
                token = 259;
                continue;
            }
            if (DELIMS.indexOf(c) >= 0) {
                this.yytext.append((char)c);
                token = c;
                continue;
            }
            this.yytext.append((char)c);
            while ((c = this.text.read()) > 0 && c > 32 && c != 127 && DELIMS.indexOf(c) < 0) {
                if (c == 92 && (c = this.text.read()) == 0) {
                    throw new ParseException("Unterminated backslash escape");
                }
                this.yytext.append((char)c);
            }
            if (c != 0) {
                this.text.backup();
            }
            try {
                long num = Long.parseLong(this.yytext.toString());
                token = 260;
            }
            catch (NumberFormatException nfe) {
                token = 258;
            }
        }
        if (c == 0 && token < 0) {
            token = 0;
            this.lval = null;
        } else {
            Object object = this.lval = this.yytext.length() == 0 ? (String)null : this.yytext.toString();
        }
        if (this.parsestate.getDebugLevel() > 0) {
            this.dumptoken(token, (String)this.lval);
        }
        return token;
    }

    void dumptoken(int token, String lval) throws ParseException {
        String stoken;
        if (token < 127) {
            stoken = Character.toString((char)token);
        } else {
            switch (token) {
                case 259: {
                    stoken = '\"' + lval + '\"';
                    break;
                }
                case 260: {
                    stoken = lval;
                    break;
                }
                case 261: {
                    stoken = lval;
                    break;
                }
                case 262: {
                    stoken = lval;
                    break;
                }
                case 258: {
                    stoken = lval;
                    break;
                }
                default: {
                    stoken = "X" + Integer.toString(token);
                }
            }
        }
        System.err.println("TOKEN = |" + stoken + "|");
    }

    static int tohex(int c) throws ParseException {
        if (c >= 97 && c <= 102) {
            return c - 97 + 10;
        }
        if (c >= 65 && c <= 70) {
            return c - 65 + 10;
        }
        if (c >= 48 && c <= 57) {
            return c - 48;
        }
        return -1;
    }

    @Override
    public Object getLVal() {
        return this.lval;
    }

    @Override
    public void yyerror(String s) {
        System.err.println("CEParser.yyerror: " + s + "; parse failed at char: " + this.charno + "; near: ");
        String context = this.getInput();
        int show = context.length() < 20 ? context.length() : 20;
        System.err.println(context.substring(context.length() - show) + "^");
        new Exception().printStackTrace(System.err);
    }

    static class TextStream {
        String text = null;
        int mark = 0;
        int next = 0;
        int textlen = 0;

        public String around() {
            String prefix = this.text.substring(this.mark - 10, this.mark);
            String suffix = this.text.substring(this.mark, this.mark + 10);
            return prefix + "|" + suffix;
        }

        public void setText(String text) {
            this.textlen = text.length();
            this.text = text + '\u0000';
        }

        public String getText() {
            return this.text.substring(0, this.textlen);
        }

        public String toString() {
            return this.getText();
        }

        int peek() {
            return this.text.charAt(this.next);
        }

        void backup() {
            this.next = this.next <= 0 ? 0 : --this.next;
        }

        int read() {
            char c = this.text.charAt(this.next);
            if (c != '\u0000') {
                ++this.next;
            }
            return c;
        }

        void mark() {
            this.mark = this.next;
        }
    }
}

