/*
 * Decompiled with CFR 0.152.
 */
package dap4.servlet;

import dap4.cdmshared.CDMUtil;
import dap4.cdmshared.NodeMap;
import dap4.core.data.DataDataset;
import dap4.core.data.DataException;
import dap4.core.data.DataVariable;
import dap4.core.dmr.DapAtomicVariable;
import dap4.core.dmr.DapAttribute;
import dap4.core.dmr.DapDataset;
import dap4.core.dmr.DapDimension;
import dap4.core.dmr.DapEnum;
import dap4.core.dmr.DapFactory;
import dap4.core.dmr.DapFactoryDMR;
import dap4.core.dmr.DapGroup;
import dap4.core.dmr.DapMap;
import dap4.core.dmr.DapNode;
import dap4.core.dmr.DapSequence;
import dap4.core.dmr.DapStructure;
import dap4.core.dmr.DapType;
import dap4.core.dmr.DapVariable;
import dap4.core.util.DapContext;
import dap4.core.util.DapException;
import dap4.core.util.DapSort;
import dap4.core.util.DapUtil;
import dap4.dap4shared.AbstractDSP;
import dap4.dap4shared.AbstractData;
import dap4.dap4shared.DSP;
import dap4.servlet.CDMDataAtomic;
import dap4.servlet.CDMDataCompoundArray;
import dap4.servlet.CDMDataDataset;
import dap4.servlet.CDMDataStructure;
import dap4.servlet.DapLog;
import java.io.IOException;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ucar.ma2.Array;
import ucar.ma2.ArrayStructure;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.nc2.Attribute;
import ucar.nc2.CDMNode;
import ucar.nc2.CDMSort;
import ucar.nc2.Dimension;
import ucar.nc2.EnumTypedef;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFileWriter;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.StructureDS;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.jni.netcdf.Nc4Iosp;

public class CDMDSP
extends AbstractDSP {
    protected static final boolean DEBUG = false;
    protected static final Object FACTORYKEY = DapFactory.class;
    protected static final String SYNTHETICTAG = ".syn";
    protected static final String DAPVERSION = "4.0";
    protected static final String DMRVERSION = "1.0";
    protected static final Class NC4CLASS = Nc4Iosp.class;
    protected static Set<NetcdfDataset.Enhance> ENHANCEMENT = EnumSet.of(NetcdfDataset.Enhance.CoordSystems);
    protected static boolean nc4loaded = false;
    protected NetcdfDataset ncfile = null;
    protected DapDataset dmr = null;
    protected DapFactory factory = null;
    protected NodeMap nodemap = new NodeMap();
    protected boolean closed = false;
    protected CDMDataDataset data = null;

    public static void loadNc4Iosp() throws DapException {
        if (nc4loaded) {
            return;
        }
        nc4loaded = true;
        if (!NetcdfFile.iospRegistered((Class)NC4CLASS)) {
            try {
                NetcdfFile.registerIOProvider((Class)NC4CLASS, (boolean)false);
                Nc4Iosp.setLibraryAndPath(null, (String)"netcdf");
            }
            catch (Throwable e) {
                DapLog.error("Cant load IOSP Nc4Iosp");
                throw new DapException(e.getMessage(), e.getCause());
            }
        }
    }

    public CDMDSP() {
    }

    public CDMDSP(String path) throws DapException {
        this(path, null);
    }

    public CDMDSP(String path, DapContext cxt) throws DapException {
        super(path, (Object)cxt);
        this.ncfile = (NetcdfDataset)this.createNetcdfFile();
        if (this.ncfile == null) {
            throw new DapException("CDMDSP: cannot open: " + path);
        }
        this.factory = (DapFactory)cxt.get(FACTORYKEY);
        if (this.factory == null) {
            this.factory = new DapFactoryDMR();
        }
        this.build();
        this.buildDataDataset();
    }

    public boolean match(String path, DapContext context) {
        return path.indexOf(SYNTHETICTAG) < 0;
    }

    public DSP open(String path) throws DapException {
        return this.open(path, new DapContext());
    }

    public DSP open(String path, DapContext context) throws DapException {
        return new CDMDSP(path, context);
    }

    public void close() {
        try {
            if (this.ncfile != null) {
                this.ncfile.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public DataDataset getDataDataset() {
        return this.data;
    }

    public NetcdfDataset getNetcdfDataset() {
        return this.ncfile;
    }

    public void setDataDataset(CDMDataDataset data) {
        this.data = data;
    }

    public CDMNode getCDMNode(DapNode dapnode) {
        return this.nodemap.get(dapnode);
    }

    protected void recordNode(CDMNode cdmnode, DapNode dapnode) {
        CDMSort sort = cdmnode.getSort();
        switch (sort) {
            case VARIABLE: 
            case STRUCTURE: 
            case SEQUENCE: {
                Variable basev = CDMUtil.unwrap((Variable)((Variable)cdmnode));
                assert (basev != null) : "Unwrap() failed";
                cdmnode = basev;
            }
        }
        this.nodemap.put(dapnode, cdmnode);
    }

    protected DapNode lookupNode(CDMNode cdmnode) {
        CDMSort sort = cdmnode.getSort();
        if (sort == CDMSort.VARIABLE || sort == CDMSort.STRUCTURE) {
            Variable basev = CDMUtil.unwrap((Variable)((Variable)cdmnode));
            assert (basev != null) : "Unwrap() failed";
            cdmnode = basev;
        }
        return this.nodemap.get(cdmnode);
    }

    public void build() throws DapException {
        if (this.dmr != null) {
            return;
        }
        try {
            this.dmr = (DapDataset)this.newNode(DapSort.DATASET);
            this.recordNode((CDMNode)this.ncfile.getRootGroup(), (DapNode)this.dmr);
            String name = this.ncfile.getLocation();
            name = DapUtil.canonicalpath((String)name, (boolean)false);
            int index = name.lastIndexOf(47);
            if (index >= 0) {
                name = name.substring(index + 1, name.length());
            }
            this.dmr.setShortName(name);
            this.dmr.setDataset(this.dmr);
            this.dmr.setDapVersion(DAPVERSION);
            this.dmr.setDMRVersion(DMRVERSION);
            this.dmr.setBase(DapUtil.canonicalpath((String)this.ncfile.getLocation(), (boolean)false));
            this.dmr.setNS("http://xml.opendap.org/ns/DAP/4.0#");
            this.fillgroup((DapGroup)this.dmr, this.ncfile.getRootGroup());
            this.dmr.sort();
            this.processmappedvariables(this.ncfile.getRootGroup());
            super.setDataset(this.dmr);
        }
        catch (DapException e) {
            throw new DapException((Throwable)e);
        }
    }

    protected void fillgroup(DapGroup dapgroup, Group cdmgroup) throws DapException {
        for (Dimension cdmdim : cdmgroup.getDimensions()) {
            DapDimension dapdim = this.builddim(cdmdim);
        }
        for (EnumTypedef cdmenum : cdmgroup.getEnumTypedefs()) {
            String name = cdmenum.getShortName();
            DapEnum dapenum = this.buildenum(cdmenum);
            dapenum.setShortName(name);
            dapgroup.addDecl((DapNode)dapenum);
        }
        for (Variable cdmvar : cdmgroup.getVariables()) {
            DapNode newvar = this.buildvariable(cdmvar, (DapNode)dapgroup);
        }
        for (Group subgroup : cdmgroup.getGroups()) {
            DapGroup newgroup = this.buildgroup(subgroup);
            dapgroup.addDecl((DapNode)newgroup);
        }
        this.buildattributes((DapNode)dapgroup, cdmgroup.getAttributes());
    }

    protected DapDimension builddim(Dimension cdmdim) throws DapException {
        boolean shared;
        DapDimension dapdim = null;
        long cdmsize = this.dapsize(cdmdim);
        String name = cdmdim.getShortName();
        if (name != null && name.length() == 0) {
            name = null;
        }
        if (!(shared = cdmdim.isShared())) {
            dapdim = (DapDimension)this.newNode(DapSort.DIMENSION);
            if (cdmdim.isVariableLength()) {
                dapdim.setSize(-1L);
            } else {
                dapdim.setSize(cdmsize);
            }
            this.dmr.addDecl((DapNode)dapdim);
        } else {
            dapdim = (DapDimension)this.newNode(DapSort.DIMENSION);
            dapdim.setShortName(name);
            dapdim.setSize(cdmsize);
            dapdim.setShared(true);
            Group cdmparent = cdmdim.getGroup();
            DapGroup dapparent = (DapGroup)this.lookupNode((CDMNode)cdmparent);
            assert (dapparent != null);
            dapparent.addDecl((DapNode)dapdim);
        }
        this.recordNode((CDMNode)cdmdim, (DapNode)dapdim);
        return dapdim;
    }

    protected DapEnum buildenum(EnumTypedef cdmenum) throws DapException {
        DapEnum dapenum = (DapEnum)this.newNode(DapSort.ENUMERATION);
        this.recordNode((CDMNode)cdmenum, (DapNode)dapenum);
        dapenum.setShortName(cdmenum.getShortName());
        switch (cdmenum.getBaseType()) {
            case ENUM1: {
                dapenum.setBaseType(DapType.INT8);
                break;
            }
            case ENUM2: {
                dapenum.setBaseType(DapType.INT16);
                break;
            }
            default: {
                dapenum.setBaseType(DapType.INT32);
            }
        }
        Map ecvalues = cdmenum.getMap();
        for (Integer ecval : ecvalues.keySet()) {
            String name = (String)ecvalues.get(ecval);
            assert (name != null);
            int value = ecval;
            dapenum.addEnumConst(name, new Long(value));
        }
        return dapenum;
    }

    protected DapNode buildvariable(Variable cdmvar, DapNode parent) throws DapException {
        cdmvar = CDMUtil.unwrap((Variable)cdmvar);
        List cdmdims = cdmvar.getDimensions();
        return this.buildvariable(cdmvar, cdmdims, parent);
    }

    protected DapNode buildvariable(Variable cdmbasevar, List<Dimension> cdmdims, DapNode parent) throws DapException {
        DapStructure dapvar = null;
        if (cdmdims != null && cdmdims.size() > 0 && cdmdims.get(cdmdims.size() - 1).isVariableLength()) {
            dapvar = this.buildsequence(cdmbasevar);
        } else {
            block0 : switch (cdmbasevar.getSort()) {
                case VARIABLE: {
                    switch (cdmbasevar.getDataType()) {
                        case ENUM1: 
                        case ENUM2: 
                        case ENUM4: {
                            dapvar = this.buildenumvar(cdmbasevar);
                            break block0;
                        }
                        case OPAQUE: {
                            dapvar = this.buildopaquevar(cdmbasevar);
                            break block0;
                        }
                        case STRING: {
                            dapvar = this.buildstringvar(cdmbasevar);
                            break block0;
                        }
                        case STRUCTURE: {
                            dapvar = this.buildstructvar(cdmbasevar);
                            break block0;
                        }
                    }
                    dapvar = this.buildatomicvar(cdmbasevar);
                    break;
                }
                case STRUCTURE: {
                    dapvar = this.buildstructvar(cdmbasevar);
                    break;
                }
                default: {
                    assert (false) : "Internal Error";
                    break;
                }
            }
        }
        if (parent != null) {
            switch (parent.getSort()) {
                case GROUP: 
                case DATASET: {
                    ((DapGroup)parent).addDecl((DapNode)dapvar);
                    break;
                }
                case STRUCTURE: 
                case SEQUENCE: {
                    ((DapStructure)parent).addField((DapNode)dapvar);
                    break;
                }
                default: {
                    assert (false) : "Internal error";
                    break;
                }
            }
        }
        this.builddimrefs((DapVariable)dapvar, cdmdims);
        return dapvar;
    }

    protected DapAtomicVariable buildatomicvar(Variable cdmvar) throws DapException {
        DapType basetype = CDMUtil.cdmtype2daptype((DataType)cdmvar.getDataType(), (boolean)cdmvar.isUnsigned());
        if (basetype == null) {
            throw new DapException("DapFile: illegal CDM variable base type: " + cdmvar.getDataType());
        }
        DapAtomicVariable dapvar = (DapAtomicVariable)this.newNode(DapSort.ATOMICVARIABLE);
        dapvar.setShortName(cdmvar.getShortName());
        dapvar.setBaseType(basetype);
        this.recordNode((CDMNode)cdmvar, (DapNode)dapvar);
        this.buildattributes((DapNode)dapvar, cdmvar.getAttributes());
        return dapvar;
    }

    protected DapAtomicVariable buildopaquevar(Variable cdmvar) throws DapException {
        assert (cdmvar.getDataType() == DataType.OPAQUE) : "Internal error";
        DapAtomicVariable dapvar = (DapAtomicVariable)this.newNode(DapSort.ATOMICVARIABLE);
        this.recordNode((CDMNode)cdmvar, (DapNode)dapvar);
        dapvar.setShortName(cdmvar.getShortName());
        dapvar.setBaseType(DapType.OPAQUE);
        this.buildattributes((DapNode)dapvar, cdmvar.getAttributes());
        return dapvar;
    }

    protected DapAtomicVariable buildstringvar(Variable cdmvar) throws DapException {
        assert (cdmvar.getDataType() == DataType.STRING) : "Internal error";
        DapAtomicVariable dapvar = (DapAtomicVariable)this.newNode(DapSort.ATOMICVARIABLE);
        this.recordNode((CDMNode)cdmvar, (DapNode)dapvar);
        dapvar.setShortName(cdmvar.getShortName());
        dapvar.setBaseType(DapType.STRING);
        this.buildattributes((DapNode)dapvar, cdmvar.getAttributes());
        return dapvar;
    }

    protected DapAtomicVariable buildenumvar(Variable cdmvar) throws DapException {
        assert (cdmvar.getDataType() == DataType.ENUM1 || cdmvar.getDataType() == DataType.ENUM2 || cdmvar.getDataType() == DataType.ENUM4) : "Internal error";
        DapAtomicVariable dapvar = (DapAtomicVariable)this.newNode(DapSort.ATOMICVARIABLE);
        this.recordNode((CDMNode)cdmvar, (DapNode)dapvar);
        dapvar.setShortName(cdmvar.getShortName());
        EnumTypedef enumdef = cdmvar.getEnumTypedef();
        DapEnum dapenum = (DapEnum)this.lookupNode((CDMNode)enumdef);
        assert (dapenum != null);
        dapvar.setBaseType((DapType)dapenum);
        this.buildattributes((DapNode)dapvar, cdmvar.getAttributes());
        return dapvar;
    }

    protected DapStructure buildstructvar(Variable cdmvar) throws DapException {
        assert (cdmvar.getDataType() == DataType.STRUCTURE) : "Internal error";
        DapStructure dapvar = (DapStructure)this.newNode(DapSort.STRUCTURE);
        this.recordNode((CDMNode)cdmvar, (DapNode)dapvar);
        dapvar.setShortName(cdmvar.getShortName());
        Structure structvar = (Structure)cdmvar;
        for (CDMNode node : structvar.getVariables()) {
            Variable var = (Variable)node;
            this.buildvariable(var, (DapNode)dapvar);
        }
        this.buildattributes((DapNode)dapvar, cdmvar.getAttributes());
        return dapvar;
    }

    protected DapSequence buildsequence(Variable cdmbasevar) throws DapException {
        DapSequence seq = (DapSequence)this.newNode(DapSort.SEQUENCE);
        this.recordNode((CDMNode)cdmbasevar, (DapNode)seq);
        seq.setShortName(cdmbasevar.getShortName());
        DapVariable field = (DapVariable)this.buildvariable(cdmbasevar, null, (DapNode)seq);
        return seq;
    }

    protected void buildattributes(DapNode node, List<Attribute> attributes) throws DapException {
        for (Attribute attr : attributes) {
            if (this.suppress(attr.getShortName())) continue;
            DapAttribute dapattr = this.buildattribute(attr);
            node.addAttribute(dapattr);
        }
    }

    protected DapAttribute buildattribute(Attribute attr) throws DapException {
        DapAttribute dapattr = (DapAttribute)this.newNode(DapSort.ATTRIBUTE);
        this.recordNode((CDMNode)attr, (DapNode)dapattr);
        dapattr.setShortName(attr.getShortName());
        DapType basetype = CDMUtil.cdmtype2daptype((DataType)attr.getDataType(), (boolean)attr.isUnsigned());
        if (basetype == null) {
            throw new DapException("DapFile: illegal CDM variable attribute type: " + attr.getDataType());
        }
        dapattr.setBaseType(basetype);
        Array values = attr.getValues();
        if (!this.validatecdmtype(attr.getDataType(), attr.isUnsigned(), values.getElementType())) {
            throw new DapException("DapFile: attr type versus attribute data mismatch: " + values.getElementType());
        }
        IndexIterator iter = values.getIndexIterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            dapattr.addValue(o);
        }
        return dapattr;
    }

    protected void builddimrefs(DapVariable dapvar, List<Dimension> cdmdims) throws DapException {
        if (cdmdims == null || cdmdims.size() == 0) {
            return;
        }
        for (Dimension cdmdim : cdmdims) {
            DapDimension dapdim = null;
            if (cdmdim.isShared()) {
                Dimension declareddim = this.finddimdecl(cdmdim);
                dapdim = (DapDimension)this.lookupNode((CDMNode)declareddim);
            } else {
                if (cdmdim.isVariableLength()) continue;
                dapdim = this.builddim(cdmdim);
            }
            assert (dapdim != null) : "Internal error";
            dapvar.addDimension(dapdim);
        }
    }

    protected void processmappedvariables(Group g) throws DapException {
        for (Variable v0 : g.getVariables()) {
            Variable cdmvar = CDMUtil.unwrap((Variable)v0);
            if (cdmvar == null) {
                throw new DapException("NetcdfDataset synthetic variable: " + v0);
            }
            DapNode dapvar = this.lookupNode((CDMNode)cdmvar);
            if (dapvar == null) {
                throw new DapException("Unknown variable: " + cdmvar);
            }
            if (!(dapvar instanceof DapVariable)) {
                throw new DapException("CDMVariable not mapping to dap variable: " + cdmvar);
            }
            this.buildmaps((DapVariable)dapvar, v0);
        }
    }

    protected void buildmaps(DapVariable dapvar, Variable var) throws DapException {
        List css = null;
        if (var.getSort() == CDMSort.VARIABLE) {
            VariableDS vds = (VariableDS)var;
            css = vds.getCoordinateSystems();
        } else {
            StructureDS sds = (StructureDS)var;
            css = sds.getCoordinateSystems();
        }
        if (css != null && css.size() > 0) {
            CoordinateSystem coordsystems = (CoordinateSystem)css.get(0);
            for (CoordinateAxis axis : coordsystems.getCoordinateAxes()) {
                Variable v;
                VariableDS vds = (VariableDS)axis.getOriginalVariable();
                if (vds == null || (v = CDMUtil.unwrap((Variable)vds)) == null) continue;
                DapVariable mapvar = (DapVariable)this.lookupNode((CDMNode)v);
                if (mapvar == null) {
                    throw new DapException("Illegal map variable:" + v.toString());
                }
                if (mapvar.getSort() != DapSort.ATOMICVARIABLE) {
                    throw new DapException("Non-atomic map variable:" + v.toString());
                }
                if (mapvar.isTopLevel()) continue;
                DapVariable parent = (DapVariable)mapvar.getContainer();
                assert (parent.getSort() == DapSort.STRUCTURE);
                if (dapvar == parent) continue;
                DapMap map = (DapMap)this.newNode(DapSort.MAP);
                map.setVariable((DapAtomicVariable)mapvar);
                dapvar.addMap(map);
            }
        }
    }

    protected DapGroup buildgroup(Group cdmgroup) throws DapException {
        DapGroup dapgroup = (DapGroup)this.newNode(DapSort.GROUP);
        this.recordNode((CDMNode)cdmgroup, (DapNode)dapgroup);
        dapgroup.setShortName(cdmgroup.getShortName());
        this.fillgroup(dapgroup, cdmgroup);
        return dapgroup;
    }

    protected DapNode newNode(DapSort sort) {
        DapNode node = (DapNode)this.factory.newNode(sort);
        if (this.dmr != null) {
            node.setDataset(this.dmr);
        }
        return node;
    }

    protected long dapsize(Dimension cdmdim) {
        if (cdmdim.isVariableLength()) {
            return -1L;
        }
        return cdmdim.getLength();
    }

    protected boolean validatecdmtype(DataType datatype, boolean unsigned, Class typeclass) {
        switch (datatype) {
            case CHAR: {
                return typeclass == Character.TYPE;
            }
            case BYTE: {
                if (unsigned) {
                    return typeclass == Short.TYPE;
                }
                return typeclass == Byte.TYPE;
            }
            case SHORT: {
                if (unsigned) {
                    return typeclass == Integer.TYPE;
                }
                return typeclass == Short.TYPE;
            }
            case INT: {
                if (unsigned) {
                    return typeclass == Long.TYPE;
                }
                return typeclass == Integer.TYPE;
            }
            case LONG: {
                if (unsigned) {
                    return typeclass == Long.TYPE;
                }
                return typeclass == Long.TYPE;
            }
            case FLOAT: {
                return typeclass == Float.TYPE;
            }
            case DOUBLE: {
                return typeclass == Double.TYPE;
            }
            case STRING: {
                return typeclass == String.class;
            }
            case OPAQUE: {
                return typeclass == Byte[].class;
            }
            case ENUM1: {
                return typeclass == Byte.TYPE;
            }
            case ENUM2: {
                return typeclass == Short.TYPE;
            }
            case ENUM4: {
                return typeclass == Integer.TYPE;
            }
        }
        return false;
    }

    protected Dimension finddimdecl(Dimension dimref) {
        for (Map.Entry entry : this.nodemap.getCDMMap().entrySet()) {
            Dimension d;
            if (((CDMNode)entry.getValue()).getSort() != CDMSort.DIMENSION || !this.isdeclfor(d = (Dimension)entry.getValue(), dimref)) continue;
            return d;
        }
        return null;
    }

    protected boolean isdeclfor(Dimension decl, Dimension ref) {
        if (!decl.getShortName().equals(ref.getShortName())) {
            return false;
        }
        if (decl.getLength() != ref.getLength()) {
            return false;
        }
        String dprefix = decl.getGroup().getFullName();
        String rprefix = ref.getGroup().getFullName();
        return dprefix.equals(rprefix);
    }

    protected DataDataset buildDataDataset() throws DataException {
        List cdmvars = this.ncfile.getVariables();
        CDMDataDataset dds = new CDMDataDataset(this, this.dmr);
        for (Variable v : cdmvars) {
            DapVariable dv = (DapVariable)this.nodemap.get((CDMNode)v);
            if (dv == null) {
                throw new DataException("Unknown cdm variable: " + v.getShortName());
            }
            DataVariable cdv = this.buildData(dv);
            dds.addVariable(cdv);
        }
        return dds;
    }

    protected DataVariable buildData(DapVariable dap) throws DataException {
        Variable cdmv = null;
        AbstractData dv = null;
        List dimset = dap.getDimensions();
        long product = dap.getCount();
        cdmv = (Variable)this.nodemap.get((DapNode)dap);
        if (cdmv == null) {
            throw new DataException("Node has no cdm match: " + dap.getShortName());
        }
        switch (dap.getSort()) {
            case ATOMICVARIABLE: {
                try {
                    Array array = cdmv.read();
                    dv = new CDMDataAtomic(this, (DapAtomicVariable)dap, array);
                    break;
                }
                catch (IOException ioe) {
                    throw new DataException((Throwable)ioe);
                }
            }
            case STRUCTURE: {
                ArrayStructure array;
                DapStructure ds = (DapStructure)dap;
                try {
                    array = (ArrayStructure)cdmv.read();
                }
                catch (IOException ioe) {
                    throw new DataException((Throwable)ioe);
                }
                if (ds.getRank() == 0) {
                    CDMDataStructure cds = new CDMDataStructure(this, ds, null, 0L, array.getStructureData(0));
                    dv = cds;
                    break;
                }
                CDMDataCompoundArray cdca = new CDMDataCompoundArray(this, (DapVariable)ds, array);
                dv = cdca;
                break;
            }
            case SEQUENCE: {
                throw new DataException("Sequence not yet supported");
            }
            default: {
                throw new DataException("Unexpected DapNode: " + dap.getSort());
            }
        }
        return dv;
    }

    protected NetcdfFile createNetcdfFile() throws DapException {
        try {
            String extension;
            this.path = DapUtil.canonicalpath((String)this.path, (boolean)false);
            int dotpos = this.path.lastIndexOf(46);
            NetcdfDataset ncfile = null;
            if (dotpos > 0 && dotpos + 1 < this.path.length() && (extension = this.path.substring(dotpos + 1, this.path.length())).equals("nc")) {
                CDMDSP.loadNc4Iosp();
                Nc4Iosp nc4Iosp = new Nc4Iosp(NetcdfFileWriter.Version.netcdf4);
                ncfile = nc4Iosp.open(this.path);
                ncfile = new NetcdfDataset((NetcdfFile)ncfile, ENHANCEMENT);
                return ncfile;
            }
            ncfile = NetcdfDataset.openDataset((String)this.path, ENHANCEMENT, (int)-1, null, null);
            return ncfile;
        }
        catch (Exception e) {
            return null;
        }
    }

    protected boolean suppress(String attrname) {
        if (attrname.startsWith("_Coord")) {
            return true;
        }
        return attrname.equals("_Unsigned");
    }
}

