/*
 * Decompiled with CFR 0.152.
 */
package dap4.servlet;

import dap4.core.data.DataException;
import dap4.core.data.DataStructure;
import dap4.core.data.DataVariable;
import dap4.core.dmr.DapAtomicVariable;
import dap4.core.dmr.DapNode;
import dap4.core.dmr.DapStructure;
import dap4.core.dmr.DapVariable;
import dap4.dap4shared.AbstractData;
import dap4.servlet.CDMDSP;
import dap4.servlet.CDMDataAtomic;
import dap4.servlet.CDMDataCompoundArray;
import java.util.Arrays;
import java.util.List;
import ucar.ma2.Array;
import ucar.ma2.ArrayStructure;
import ucar.ma2.StructureData;
import ucar.ma2.StructureMembers;

public class CDMDataStructure
extends AbstractData
implements DataStructure {
    protected CDMDSP dsp = null;
    protected CDMDataCompoundArray parent;
    protected long recno;
    protected byte[] checksum = null;
    protected DapStructure dapstruct = null;
    StructureData cdmdata = null;
    DataVariable[] fieldcache = null;
    List<StructureMembers.Member> members = null;

    public CDMDataStructure(CDMDSP dsp, DapStructure dap, CDMDataCompoundArray cdv, long recno, StructureData data) throws DataException {
        super((DapNode)dap);
        this.dsp = dsp;
        this.parent = cdv;
        this.recno = recno;
        this.dapstruct = dap;
        this.cdmdata = data;
        this.members = this.cdmdata.getMembers();
        this.fieldcache = new DataVariable[this.members.size()];
        Arrays.fill(this.fieldcache, null);
    }

    public DataVariable readfield(String name) throws DataException {
        StructureMembers.Member member = this.cdmdata.findMember(name);
        return this.readfield(member);
    }

    public DataVariable readfield(int i) throws DataException {
        if (i < 0 || i >= this.members.size()) {
            throw new DataException("readfield: index out of bounds: " + i);
        }
        return this.readfield(this.members.get(i));
    }

    protected DataVariable readfield(StructureMembers.Member member) throws DataException {
        int index = this.members.indexOf(member);
        DapVariable field = this.dapstruct.getField(index);
        if (this.fieldcache[index] == null) {
            Array array = this.cdmdata.getArray(member);
            switch (array.getDataType()) {
                case SEQUENCE: 
                case STRUCTURE: {
                    this.fieldcache[index] = new CDMDataCompoundArray(this.dsp, field, (ArrayStructure)array);
                    break;
                }
                default: {
                    this.fieldcache[index] = new CDMDataAtomic(this.dsp, (DapAtomicVariable)field, array);
                }
            }
        }
        return this.fieldcache[index];
    }
}

