/*
 * Decompiled with CFR 0.152.
 */
package dap4.servlet;

import dap4.core.util.DapException;
import dap4.dap4shared.DSP;
import dap4.servlet.CDMDSP;
import java.util.ArrayList;
import java.util.List;

public abstract class DSPFactory {
    static List<Class> dspRegistry = new ArrayList<Class>();

    public static void registerDSP(String className) throws DapException {
        try {
            Class<?> klass = DSPFactory.class.getClassLoader().loadClass(className);
            DSPFactory.registerDSP(klass);
        }
        catch (ClassNotFoundException e) {
            throw new DapException((Throwable)e);
        }
    }

    public static void registerDSP(Class klass) throws DapException {
        DSPFactory.registerDSP(klass, false);
    }

    public static synchronized void registerDSP(Class klass, boolean last) throws DapException {
        try {
            int pos = dspRegistry.indexOf(klass);
            DSP dsp = (DSP)klass.newInstance();
            if (pos >= 0) {
                dspRegistry.set(pos, klass);
            } else if (!last) {
                dspRegistry.add(0, klass);
            } else {
                dspRegistry.add(klass);
            }
        }
        catch (IllegalAccessException e1) {
            throw new DapException((Throwable)e1);
        }
        catch (InstantiationException e2) {
            throw new DapException((Throwable)e2);
        }
    }

    public static synchronized boolean dspRegistered(Class klass) {
        return dspRegistry.contains(klass);
    }

    public static synchronized void dspUnregister(Class klass) {
        dspRegistry.remove(klass);
    }

    public static synchronized DSP create(String path) throws DapException {
        for (int i = 0; i < dspRegistry.size(); ++i) {
            DSP dsp;
            Class testclass = dspRegistry.get(i);
            try {
                dsp = (DSP)testclass.newInstance();
            }
            catch (Exception e) {
                throw new DapException((Throwable)e);
            }
            if (!dsp.match(path, null)) continue;
            return dsp.open(path);
        }
        return null;
    }

    static {
        try {
            DSPFactory.registerDSP(CDMDSP.class);
        }
        catch (DapException dapException) {
            // empty catch block
        }
    }
}

