/*
 * Decompiled with CFR 0.152.
 */
package dap4.ce.parser;

import dap4.ce.parser.CEAST;
import dap4.ce.parser.CELexer;
import dap4.ce.parser.CEParserBody;
import dap4.core.dmr.DapDataset;
import dap4.core.dmr.DapDimension;
import dap4.core.dmr.parser.ParseException;
import dap4.core.util.DapException;
import dap4.core.util.DapSort;
import dap4.core.util.Slice;
import java.util.HashMap;
import java.util.Map;

public class CEParser
extends CEParserBody {
    static final long UNDEFINED = -1L;
    protected DapDataset template = null;
    protected Map<String, Slice> dimdefs = new HashMap<String, Slice>();
    protected CEAST constraint = null;

    public CEParser(DapDataset template) throws ParseException {
        super(null);
        CELexer lexer = new CELexer(this);
        this.setLexer(lexer);
        this.template = template;
    }

    public CEAST getConstraint() {
        return this.constraint;
    }

    public boolean parse(String document) throws ParseException {
        ((CELexer)this.getLexer()).setText(document);
        return super.parse();
    }

    @Override
    CEAST constraint(CEAST.NodeList clauses) throws ParseException {
        CEAST node = new CEAST(CEAST.Sort.CONSTRAINT);
        node.clauses = clauses;
        node.dimdefs = this.dimdefs;
        this.constraint = node;
        return node;
    }

    @Override
    CEAST projection(CEAST segmenttree) throws ParseException {
        CEAST node = new CEAST(CEAST.Sort.PROJECTION);
        node.tree = segmenttree;
        return node;
    }

    @Override
    CEAST segmenttree(CEAST parent, CEAST segment) {
        if (parent == null) {
            parent = segment;
        } else {
            parent.addSegment(segment);
            parent.isleaf = false;
        }
        return parent;
    }

    @Override
    CEAST segmenttree(CEAST parent, CEAST.NodeList forest) {
        assert (parent != null);
        parent.isleaf = false;
        for (CEAST node : forest) {
            parent.addSegment(node);
        }
        return parent;
    }

    @Override
    CEAST segment(String name, CEAST.SliceList slices) throws ParseException {
        CEAST node = new CEAST(CEAST.Sort.SEGMENT);
        node.name = name;
        node.slices = slices == null ? new CEAST.SliceList() : slices;
        return node;
    }

    @Override
    Slice slice(int state, String sfirst, String send, String sstride) throws ParseException {
        Slice x;
        long first = 0L;
        long last = -1L;
        long stride = 1L;
        try {
            if (sfirst != null) {
                first = Long.parseLong(sfirst);
            }
            if (send != null) {
                last = Long.parseLong(send);
            }
            if (sstride != null) {
                stride = Long.parseLong(sstride);
            }
        }
        catch (NumberFormatException nfe) {
            throw new ParseException(String.format("Illegal slice: [%s:%s:%s]", sfirst, send, sstride));
        }
        try {
            x = new Slice(first, last, stride);
        }
        catch (DapException de) {
            throw new ParseException((Throwable)de);
        }
        try {
            switch (state) {
                case 0: {
                    x.setConstrained(Boolean.valueOf(false));
                    break;
                }
                case 1: {
                    x.setIndices(x.getFirst(), x.getFirst(), 1L);
                    break;
                }
                case 2: {
                    x.setIndices(x.getFirst(), x.getLast(), 1L);
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
                default: {
                    assert (false) : "Illegal slice case";
                    break;
                }
            }
        }
        catch (DapException de) {
            throw new ParseException((Throwable)de);
        }
        return x;
    }

    @Override
    void dimredef(String name, Slice slice) throws ParseException {
        DapDimension dim;
        if (this.dimdefs.containsKey(name)) {
            throw new ParseException("Multiply defined shared dim: " + name);
        }
        try {
            dim = (DapDimension)this.template.getDataset().findByFQN(name, DapSort.DIMENSION);
        }
        catch (DapException de) {
            throw new ParseException((Throwable)de);
        }
        if (dim == null) {
            throw new ParseException("Attempt to redefine a non-existent shared dimension: " + name);
        }
        try {
            if (slice.incomplete()) {
                slice.complete(dim);
            }
            slice.validate();
        }
        catch (DapException de) {
            throw new ParseException((Throwable)de);
        }
        if (slice.getLast() >= dim.getSize()) {
            throw new ParseException("Slice is inconsistent with the underlying shared dimension: " + name);
        }
        this.dimdefs.put(name, slice);
    }

    @Override
    CEAST selection(CEAST projection, CEAST filter) throws ParseException {
        CEAST node = new CEAST(CEAST.Sort.SELECTION);
        return node;
    }

    @Override
    CEAST conjunction(CEAST lhs, CEAST rhs) throws ParseException {
        CEAST node = new CEAST(CEAST.Sort.EXPR);
        return node;
    }

    @Override
    CEAST negation(CEAST lhs) throws ParseException {
        CEAST node = new CEAST(CEAST.Sort.EXPR);
        return node;
    }

    @Override
    CEAST predicate(CEAST.Operator op, Object lhs, Object rhs) throws ParseException {
        CEAST node = new CEAST(CEAST.Sort.EXPR);
        return node;
    }

    @Override
    CEAST predicaterange(CEAST.Operator op1, CEAST.Operator op2, Object lhs, Object mid, Object rhs) throws ParseException {
        CEAST node = new CEAST(CEAST.Sort.EXPR);
        return node;
    }

    @Override
    CEAST constant(CEAST.Constant sort, String value) throws ParseException {
        CEAST con = new CEAST(CEAST.Sort.CONSTANT);
        con.kind = sort;
        switch (sort) {
            case STRING: {
                con.value = value;
                break;
            }
            case LONG: {
                try {
                    con.value = Long.parseLong(value);
                    break;
                }
                catch (NumberFormatException nfe) {
                    throw new ParseException((Throwable)nfe);
                }
            }
            case DOUBLE: {
                try {
                    con.value = Double.parseDouble(value);
                    break;
                }
                catch (NumberFormatException nfe) {
                    throw new ParseException((Throwable)nfe);
                }
            }
            case BOOLEAN: {
                if (value.equals("0") || value.equalsIgnoreCase("false")) {
                    con.value = Boolean.FALSE;
                    break;
                }
                if (value.equals("1") || value.equalsIgnoreCase("true")) {
                    con.value = Boolean.TRUE;
                    break;
                }
                throw new ParseException("Malformed boolean constant: " + value);
            }
            default: {
                throw new ParseException("Unknown constant kind: " + (Object)((Object)sort));
            }
        }
        return con;
    }

    @Override
    CEAST.NodeList nodelist(CEAST.NodeList list, CEAST ast) {
        if (list == null) {
            list = new CEAST.NodeList();
        }
        if (ast != null) {
            list.add(ast);
        }
        return list;
    }

    @Override
    CEAST.SliceList slicelist(CEAST.SliceList list, Slice slice) {
        if (list == null) {
            list = new CEAST.SliceList();
        }
        if (slice != null) {
            list.add(slice);
        }
        return list;
    }

    @Override
    CEAST.StringList stringlist(CEAST.StringList list, String string) {
        if (list == null) {
            list = new CEAST.StringList();
        }
        if (string != null) {
            list.add(string);
        }
        return list;
    }
}

