/*
 * Decompiled with CFR 0.152.
 */
package dap4.servlet;

import dap4.core.dmr.ErrorResponse;
import dap4.core.util.DapException;
import dap4.core.util.DapUtil;
import dap4.dap4shared.RequestMode;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ChunkWriter
extends OutputStream {
    static final int MAXCHUNKSIZE = 0xFFFFFF;
    static final int SIZEOF_INTEGER = 4;
    public static final byte[] CRLF8 = DapUtil.extract((ByteBuffer)DapUtil.UTF8.encode("\r\n"));
    OutputStream output = null;
    State state = State.INITIAL;
    int maxbuffersize = 0xFFFFFF;
    ByteBuffer chunk = null;
    ByteBuffer header = null;
    ByteOrder order = null;
    RequestMode mode = null;
    byte[] dmr8 = null;

    public ChunkWriter(OutputStream output, RequestMode mode, ByteOrder order) throws IOException {
        this.output = output;
        this.setOrder(order);
        this.setMode(mode);
        this.header = ByteBuffer.allocate(4).order(this.getOrder());
    }

    public RequestMode getMode() {
        return this.mode;
    }

    public void setMode(RequestMode mode) {
        this.mode = mode;
    }

    public void setBufferSize(int maxsize) {
        if (maxsize < 0 || maxsize > 0xFFFFFF) {
            return;
        }
        this.maxbuffersize = maxsize;
    }

    public ByteOrder getOrder() {
        return this.order;
    }

    public void setOrder(ByteOrder order) {
        this.order = order;
    }

    public void writeDSR(String dsr) throws IOException {
        char c;
        int len;
        if (this.state != State.INITIAL) {
            throw new DapException("Attempt to write DSR twice");
        }
        if (dsr == null) {
            throw new DapException("Attempt to write empty DSR");
        }
        for (len = dsr.length(); len > 0 && ((c = dsr.charAt(len - 1)) == '\r' || c == '\n'); --len) {
        }
        if (dsr.length() == 0) {
            throw new DapException("Attempt to write empty DSR");
        }
        dsr = dsr.substring(0, len) + "\r\n";
        byte[] dsr8 = DapUtil.extract((ByteBuffer)DapUtil.UTF8.encode(dsr));
        this.sendDXR(dsr8);
        this.state = State.END;
    }

    public void writeDMR(String dmr) throws IOException {
        char c;
        int len;
        if (this.state != State.INITIAL) {
            throw new DapException("Attempt to write DMR twice");
        }
        if (dmr == null) {
            throw new DapException("Attempt to write empty DMR");
        }
        for (len = dmr.length(); len > 0 && ((c = dmr.charAt(len - 1)) == '\r' || c == '\n'); --len) {
        }
        if (dmr.length() == 0) {
            throw new DapException("Attempt to write empty DMR");
        }
        dmr = dmr.substring(0, len) + "\r\n";
        this.dmr8 = DapUtil.extract((ByteBuffer)DapUtil.UTF8.encode(dmr));
        this.state = State.DMR;
    }

    void sendDXR(byte[] dxr8) throws IOException {
        if (dxr8 == null || dxr8.length == 0) {
            return;
        }
        if (this.mode == RequestMode.DMR || this.mode == RequestMode.DSR) {
            this.state = State.END;
        } else {
            int flags = 0;
            if (this.order == ByteOrder.LITTLE_ENDIAN) {
                flags |= 4;
            }
            ChunkWriter.chunkheader(dxr8.length, flags, this.header);
            this.output.write(DapUtil.extract((ByteBuffer)this.header));
            this.state = State.DATA;
        }
        this.output.write(dxr8);
        this.output.flush();
    }

    public void writeError(int httpcode, String msg, String cxt, String other) throws IOException {
        this.dmr8 = null;
        ErrorResponse response = new ErrorResponse(httpcode, msg, cxt, other);
        String errorbody = response.buildXML();
        byte[] errbody8 = DapUtil.extract((ByteBuffer)DapUtil.UTF8.encode(errorbody));
        if (this.mode == RequestMode.DMR) {
            this.sendDXR(errbody8);
        } else {
            this.chunk.clear();
            int flags = 3;
            ChunkWriter.chunkheader(errbody8.length, flags, this.header);
            this.output.write(DapUtil.extract((ByteBuffer)this.header));
            this.output.write(errbody8);
            this.output.flush();
        }
        this.state = State.ERROR;
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
        if (this.dmr8 != null) {
            this.sendDXR(this.dmr8);
            this.dmr8 = null;
        }
        if (this.mode == RequestMode.DMR) {
            return;
        }
        if (this.chunk == null || this.chunk.position() == 0) {
            return;
        }
        this.verifystate();
        int buffersize = this.chunk.position();
        this.state = State.DATA;
        int flags = 1;
        this.writeChunk(flags);
        this.state = State.END;
        this.output.flush();
    }

    void writeChunk(int flags) throws IOException {
        if (this.chunk == null) {
            this.chunk = ByteBuffer.allocate(this.maxbuffersize);
        }
        int buffersize = this.chunk.position();
        ChunkWriter.chunkheader(buffersize, flags, this.header);
        this.output.write(DapUtil.extract((ByteBuffer)this.header));
        if (buffersize > 0) {
            this.output.write(this.chunk.array(), 0, buffersize);
        }
        this.chunk.clear();
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(int b) throws IOException {
        byte[] buf = new byte[]{(byte)(b & 0xFF)};
        this.write(buf, 0, 1);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.verifystate();
        if (this.chunk == null) {
            this.chunk = ByteBuffer.allocate(this.maxbuffersize).order(this.getOrder());
        }
        if (this.state == State.DMR) {
            this.chunk.clear();
            this.state = State.DATA;
        }
        assert (this.state == State.DATA);
        if (b.length < off + len) {
            throw new BufferUnderflowException();
        }
        int left = len;
        int offset = off;
        while (left > 0) {
            int towrite;
            int avail = this.chunk.remaining();
            do {
                if (avail == 0) {
                    this.writeChunk(0);
                    avail = this.chunk.remaining();
                }
                towrite = left < avail ? left : avail;
                this.chunk.put(b, off, towrite);
                avail -= towrite;
            } while ((left -= towrite) > 0);
        }
    }

    public static void chunkheader(int length, int flags, ByteBuffer hdrbuf) throws DapException {
        if (length > 0xFFFFFF || length < 0) {
            throw new DapException("Illegal chunk size: " + length);
        }
        int hdr = flags << 24 | length;
        hdrbuf.clear();
        hdrbuf.putInt(hdr);
    }

    void verifystate() throws DapException {
        switch (this.state) {
            case INITIAL: {
                throw new DapException("Attempt to write data before DMR");
            }
            case END: {
                throw new DapException("Attempt to write data after END");
            }
            case ERROR: {
                throw new DapException("Attempt to write data after ERROR");
            }
        }
    }

    static enum State {
        ERROR,
        END,
        DATA,
        DMR,
        INITIAL;

    }
}

