/*
 * Decompiled with CFR 0.152.
 */
package dap4.servlet;

import dap4.ce.CEConstraint;
import dap4.core.dmr.DapAtomicVariable;
import dap4.core.dmr.DapAttribute;
import dap4.core.dmr.DapDataset;
import dap4.core.dmr.DapDimension;
import dap4.core.dmr.DapEnum;
import dap4.core.dmr.DapGroup;
import dap4.core.dmr.DapMap;
import dap4.core.dmr.DapNode;
import dap4.core.dmr.DapStructure;
import dap4.core.dmr.DapType;
import dap4.core.dmr.DapVariable;
import dap4.core.util.DapException;
import dap4.core.util.DapSort;
import dap4.core.util.Escape;
import dap4.core.util.IndentWriter;
import dap4.core.util.Slice;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;

public class DMRPrint {
    protected static final int NILFLAGS = 0;
    protected static final int PERLINE = 1;
    protected static final int NONAME = 2;
    protected static final int NONNIL = 4;
    protected PrintWriter writer = null;
    protected IndentWriter printer = null;

    public DMRPrint() {
    }

    public DMRPrint(PrintWriter writer) {
        this();
        this.writer = writer;
        this.printer = new IndentWriter((Writer)writer);
    }

    public void flush() {
        this.printer.flush();
    }

    public void close() {
        this.flush();
    }

    public void printDMR(DapDataset dataset) throws IOException {
        CEConstraint ce = CEConstraint.getUniversal(dataset);
        this.printDMR(ce);
    }

    public void printDMR(CEConstraint ce) throws IOException {
        this.printer.setIndent(0);
        this.print((DapNode)ce.getDMR(), ce);
        this.printer.eol();
    }

    void print(DapNode node, CEConstraint ce) throws IOException {
        if (node == null) {
            return;
        }
        DapSort sort = node.getSort();
        String dmrname = sort.getName();
        switch (sort) {
            case DATASET: 
            case GROUP: {
                if (!ce.references(node)) break;
                DapGroup group = (DapGroup)node;
                this.printer.marginPrint("<" + dmrname);
                int flags = sort == DapSort.DATASET ? 1 : 0;
                this.printXMLAttributes(node, ce, flags);
                this.printer.println(">");
                this.printer.indent();
                if (group.getDimensions().size() > 0) {
                    for (DapNode subnode : group.getDimensions()) {
                        if (!ce.references(subnode)) continue;
                        this.print(subnode, ce);
                        this.printer.eol();
                    }
                }
                if (group.getEnums().size() > 0) {
                    for (DapNode subnode : group.getEnums()) {
                        if (!ce.references(subnode)) continue;
                        this.print(subnode, ce);
                        this.printer.eol();
                    }
                }
                if (group.getVariables().size() > 0) {
                    for (DapNode subnode : group.getVariables()) {
                        if (!ce.references(subnode)) continue;
                        this.print(subnode, ce);
                        this.printer.eol();
                    }
                }
                this.printMetadata(node, ce);
                if (group.getGroups().size() > 0) {
                    for (DapNode subnode : group.getGroups()) {
                        if (!ce.references(subnode)) continue;
                        this.print(subnode, ce);
                        this.printer.eol();
                    }
                }
                this.printer.outdent();
                this.printer.marginPrint("</" + dmrname + ">");
                break;
            }
            case DIMENSION: {
                DapDimension dim;
                if (!ce.references(node) || !(dim = (DapDimension)node).isShared()) break;
                this.printer.marginPrint("<" + dmrname);
                this.printXMLAttributes(node, ce, 0);
                if (DMRPrint.hasMetadata(node)) {
                    this.printer.println(">");
                    this.printMetadata(node, ce);
                    this.printer.marginPrint("</" + dmrname + ">");
                    break;
                }
                this.printer.print("/>");
                break;
            }
            case ENUMERATION: {
                if (!ce.references(node)) break;
                DapEnum en = (DapEnum)node;
                this.printer.marginPrint("<" + dmrname);
                this.printXMLAttributes((DapNode)en, ce, 0);
                this.printer.println(">");
                this.printer.indent();
                List econstnames = en.getNames();
                for (String econst : econstnames) {
                    Long value = en.lookup(econst);
                    assert (value != null);
                    this.printer.marginPrintln(String.format("<EnumConst name=\"%s\" value=\"%s\"/>", Escape.entityEscape((String)econst), value.toString()));
                }
                this.printMetadata(node, ce);
                this.printer.outdent();
                this.printer.marginPrint("</" + dmrname + ">");
                break;
            }
            case STRUCTURE: 
            case SEQUENCE: {
                if (!ce.references(node)) break;
                DapStructure struct = (DapStructure)node;
                this.printer.marginPrint("<" + dmrname);
                this.printXMLAttributes(node, ce, 0);
                this.printer.println(">");
                this.printer.indent();
                for (DapVariable field : struct.getFields()) {
                    if (!ce.references((DapNode)field)) continue;
                    this.print((DapNode)field, ce);
                    this.printer.eol();
                }
                this.printDimrefs((DapVariable)struct, ce);
                this.printMetadata(node, ce);
                this.printMaps((DapVariable)struct, ce);
                this.printer.outdent();
                this.printer.marginPrint("</" + dmrname + ">");
                break;
            }
            case ATOMICVARIABLE: {
                if (!ce.references(node)) break;
                DapAtomicVariable var = (DapAtomicVariable)node;
                DapType basetype = var.getBaseType();
                this.printer.marginPrint("<" + basetype.getAtomicType().name());
                this.printXMLAttributes(node, ce, 0);
                if (DMRPrint.hasMetadata(node) || DMRPrint.hasDimensions((DapVariable)var) || DMRPrint.hasMaps((DapVariable)var)) {
                    this.printer.println(">");
                    this.printer.indent();
                    if (DMRPrint.hasDimensions((DapVariable)var)) {
                        this.printDimrefs((DapVariable)var, ce);
                    }
                    if (DMRPrint.hasMetadata((DapNode)var)) {
                        this.printMetadata((DapNode)var, ce);
                    }
                    if (DMRPrint.hasMaps((DapVariable)var)) {
                        this.printMaps((DapVariable)var, ce);
                    }
                    this.printer.outdent();
                    this.printer.marginPrint("</" + basetype.getAtomicType().name() + ">");
                    break;
                }
                this.printer.print("/>");
                break;
            }
            default: {
                assert (false) : "Unexpected sort: " + sort.name();
                break;
            }
        }
    }

    void printXMLAttributes(DapNode node, CEConstraint ce, int flags) throws IOException {
        String name;
        if ((flags & 1) != 0) {
            this.printer.indent(2);
        }
        if ((name = node.getShortName()) != null && (flags & 2) == 0) {
            name = node.getShortName();
            this.printXMLAttribute("name", name, flags);
        }
        switch (node.getSort()) {
            case DATASET: {
                DapDataset dataset = (DapDataset)node;
                this.printXMLAttribute("dapVersion", dataset.getDapVersion(), flags);
                this.printXMLAttribute("dmrVersion", dataset.getDMRVersion(), flags);
                this.printXMLAttribute("xmlns", "http://xml.opendap.org/ns/DAP/4.0#", flags);
                this.printXMLAttribute("xmlns:dap", "http://xml.opendap.org/ns/DAP/4.0#", flags);
                break;
            }
            case DIMENSION: {
                long size;
                DapDimension orig = (DapDimension)node;
                if (!orig.isShared()) break;
                DapDimension actual = ce.getRedefDim(orig);
                if (actual == null) {
                    actual = orig;
                }
                if ((size = actual.getSize()) == -1L) {
                    this.printXMLAttribute("size", "*", flags);
                    break;
                }
                this.printXMLAttribute("size", Long.toString(size), flags);
                break;
            }
            case ENUMERATION: {
                this.printXMLAttribute("basetype", ((DapEnum)node).getBaseType().getTypeName(), flags);
                break;
            }
            case ATOMICVARIABLE: {
                DapAtomicVariable atom = (DapAtomicVariable)node;
                DapType basetype = atom.getBaseType();
                if (!basetype.isEnumType()) break;
                this.printXMLAttribute("enum", basetype.getTypeName(), flags);
                break;
            }
            case ATTRIBUTE: {
                DapAttribute attr = (DapAttribute)node;
                DapType basetype = attr.getBaseType();
                this.printXMLAttribute("type", basetype.getTypeName(), flags);
                if (!attr.getBaseType().isEnumType()) break;
                this.printXMLAttribute("enum", basetype.getTypeName(), flags);
                break;
            }
        }
        if ((flags & 1) != 0) {
            this.printer.outdent(2);
        }
    }

    void printXMLAttribute(String name, String value, int flags) throws DapException {
        if (name == null) {
            return;
        }
        if ((flags & 4) == 0 && (value == null || value.length() == 0)) {
            return;
        }
        if ((flags & 1) != 0) {
            this.printer.eol();
            this.printer.margin();
        }
        this.printer.print(" " + name + "=");
        this.printer.print("\"");
        if (value != null) {
            value = Escape.entityEscape((String)value);
            this.printer.print(value);
        }
        this.printer.print("\"");
    }

    void printMetadata(DapNode node, CEConstraint ce) throws IOException {
        Map attributes = node.getAttributes();
        if (attributes.size() == 0) {
            return;
        }
        for (String key : attributes.keySet()) {
            DapAttribute attr = (DapAttribute)attributes.get(key);
            assert (attr != null);
            switch (attr.getSort()) {
                case ATTRIBUTE: {
                    this.printAttribute(attr, ce);
                    break;
                }
                case ATTRIBUTESET: {
                    this.printContainerAttribute(attr, ce);
                    break;
                }
                case OTHERXML: {
                    this.printOtherXML(attr, ce);
                }
            }
        }
    }

    void printContainerAttribute(DapAttribute attr, CEConstraint ce) {
    }

    void printOtherXML(DapAttribute attr, CEConstraint ce) {
    }

    void printAttribute(DapAttribute attr, CEConstraint ce) throws IOException {
        this.printer.marginPrint("<Attribute");
        this.printXMLAttributes((DapNode)attr, ce, 0);
        List values = attr.getValues();
        this.printer.println(">");
        if (values == null) {
            throw new DapException("Attribute with no values:" + attr.getFQN());
        }
        this.printer.indent();
        if (values.size() == 1) {
            this.printer.marginPrintln(String.format("<Value value=\"%s\"/>", DMRPrint.getPrintValue(values.get(0))));
        } else {
            this.printer.marginPrintln("<Value>");
            this.printer.indent();
            for (Object value : values) {
                this.printer.marginPrint(DMRPrint.getPrintValue(value));
                this.printer.eol();
            }
            this.printer.outdent();
            this.printer.marginPrintln("</Value>");
        }
        this.printer.outdent();
        this.printer.marginPrintln("</Attribute>");
    }

    void printDimrefs(DapVariable var, CEConstraint ce) throws DapException {
        if (var.getRank() == 0) {
            return;
        }
        List<Slice> slices = ce.getVariableSlices(var);
        if (slices == null) {
            throw new DapException("Unknown variable: " + var);
        }
        assert (var.getRank() == slices.size());
        for (int i = 0; i < var.getRank(); ++i) {
            this.printer.marginPrint("<Dim");
            Slice slice = slices.get(i);
            assert (slices != null);
            if (slice.isConstrained().booleanValue()) {
                long size = slice.getCount();
                this.printXMLAttribute("size", Long.toString(size), 0);
            } else {
                DapDimension dim = var.getDimension(i);
                if (ce.getRedefDim(dim) != null) {
                    dim = ce.getRedefDim(dim);
                }
                if (dim.isShared()) {
                    String fqn = dim.getFQN();
                    assert (fqn != null) : "Illegal Dimension reference";
                    this.printXMLAttribute("name", fqn, 0);
                } else {
                    this.printXMLAttribute("size", Integer.toString((int)dim.getSize()), 0);
                }
            }
            this.printer.println("/>");
        }
    }

    void printMaps(DapVariable parent, CEConstraint ce) throws IOException {
        List maps = parent.getMaps();
        if (maps.size() == 0) {
            return;
        }
        for (DapMap map : maps) {
            this.printer.marginPrint("<Map");
            String name = map.getFQN();
            assert (name != null) : "Illegal <Map> reference";
            this.printXMLAttribute("name", name, 0);
            this.printXMLAttributes((DapNode)map, ce, 2);
            if (DMRPrint.hasMetadata((DapNode)map)) {
                this.printer.println(">");
                this.printer.indent();
                this.printMetadata((DapNode)map, ce);
                this.printer.outdent();
                this.printer.marginPrintln("</Map>");
                continue;
            }
            this.printer.println("/>");
        }
    }

    protected static String getPrintValue(Object value) {
        if (value instanceof String) {
            return Escape.entityEscape((String)((String)value));
        }
        return value.toString();
    }

    protected static boolean hasMetadata(DapNode node) {
        return node.getAttributes().size() > 0;
    }

    protected static boolean hasMaps(DapVariable var) {
        return var.getMaps().size() > 0;
    }

    protected static boolean hasDimensions(DapVariable var) {
        return var.getDimensions().size() > 0;
    }
}

