/*
 * Decompiled with CFR 0.152.
 */
package dap4.servlet;

import dap4.dap4shared.DSP;
import dap4.servlet.DSPFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public abstract class DapCache {
    static final int MAXFILES = 100;
    protected static List<DSP> lru = new ArrayList<DSP>();

    public static synchronized DSP open(String path) throws IOException {
        int lrusize = lru.size();
        for (int i = lrusize - 1; i >= 0; --i) {
            DSP dsp = lru.get(i);
            if (dsp.getPath() != path) continue;
            lru.remove(i);
            lru.add(dsp);
            return dsp;
        }
        if (lrusize == 100) {
            lru.remove(0);
        }
        DSP dsp = DSPFactory.create(path);
        lru.add(dsp);
        return dsp;
    }
}

