/*
 * Decompiled with CFR 0.152.
 */
package dap4.servlet;

import dap4.core.util.DapException;
import dap4.core.util.DapUtil;
import dap4.core.util.Escape;
import dap4.core.util.ResponseFormat;
import dap4.dap4shared.RequestMode;
import dap4.servlet.DapLog;
import dap4.servlet.ServletInfo;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DapRequest {
    ServletInfo svcinfo = null;
    HttpServletRequest request = null;
    HttpServletResponse response = null;
    String url = null;
    String originalurl = null;
    String contextpath = null;
    String fullpath = null;
    String servletpath = null;
    String datasetpath = null;
    String querystring = null;
    RequestMode mode = null;
    ResponseFormat format = null;
    Map<String, String> queries = new HashMap<String, String>();

    public DapRequest(ServletInfo svcinfo, HttpServletRequest request, HttpServletResponse response) throws DapException {
        this.svcinfo = svcinfo;
        this.request = request;
        this.response = response;
        try {
            this.parse();
        }
        catch (IOException ioe) {
            throw new DapException((Throwable)ioe);
        }
    }

    protected void parse() throws IOException {
        String servletname;
        this.url = this.request.getRequestURL().toString();
        this.querystring = this.request.getQueryString();
        this.originalurl = this.querystring == null ? this.url : this.url + "?" + this.querystring;
        this.contextpath = this.relpath(this.request.getContextPath());
        this.servletpath = this.relpath(this.request.getServletPath());
        if (this.servletpath == null) {
            this.servletpath = "";
        }
        if (this.servletpath.startsWith(servletname = this.svcinfo.getServletname())) {
            this.datasetpath = this.servletpath.substring(servletname.length(), this.servletpath.length());
            this.servletpath = servletname;
        } else {
            this.datasetpath = this.servletpath;
            this.servletpath = "";
        }
        this.datasetpath = DapUtil.nullify((String)DapUtil.canonicalpath((String)this.datasetpath, (boolean)true));
        this.mode = null;
        if (this.datasetpath == null) {
            this.mode = RequestMode.CAPABILITIES;
        } else {
            String[] segments = this.datasetpath.split("/");
            if (segments.length > 0 && segments[0].length() > 0) {
                String endofpath = segments[segments.length - 1];
                String[] pieces = endofpath.split("[.]");
                int modepos = 0;
                for (int i = pieces.length - 1; i >= 1; --i) {
                    String ext = pieces[i];
                    RequestMode mode = RequestMode.modeFor((String)ext);
                    ResponseFormat format = ResponseFormat.formatFor((String)ext);
                    if (mode != null) {
                        this.mode = mode;
                        modepos = i;
                        break;
                    }
                    if (format == null) continue;
                    if (this.format != null) {
                        throw new DapException("Multiple response formats specified: " + ext).setCode(400);
                    }
                    this.format = format;
                }
                if (modepos > 0) {
                    StringBuilder buf = new StringBuilder();
                    for (int i = 0; i < modepos; ++i) {
                        if (i > 0) {
                            buf.append(".");
                        }
                        buf.append(pieces[i]);
                    }
                    this.datasetpath = buf.toString();
                } else {
                    this.datasetpath = endofpath;
                }
                if (this.mode == null) {
                    this.mode = RequestMode.DSR;
                }
            }
        }
        if (this.querystring != null && this.querystring.length() > 0) {
            String[] pieces;
            for (String piece : pieces = this.querystring.split("&")) {
                String[] pair = piece.split("=");
                String name = Escape.urlDecode((String)pair[0]);
                name = name.toLowerCase();
                String value = pair.length == 2 ? Escape.urlDecode((String)pair[1]) : "";
                this.queries.put(name, value);
            }
        }
        DapLog.debug("DapRequest: resourcedir=" + this.getResourcePath());
        DapLog.debug("DapRequest: extension=" + (this.mode == null ? "null" : this.mode.extension()));
        DapLog.debug("DapRequest: servletpath=" + this.servletpath);
        DapLog.debug("DapRequest: datasetpath=" + this.datasetpath);
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public OutputStream getOutputStream() throws IOException {
        return this.response.getOutputStream();
    }

    public String getURL() {
        return this.url;
    }

    public String getOriginalURL() {
        return this.originalurl;
    }

    public String getDataset() {
        return this.datasetpath;
    }

    public String getServletPath() {
        return this.servletpath;
    }

    public RequestMode getMode() {
        return this.mode;
    }

    public ResponseFormat getFormat() {
        return this.format;
    }

    public void setResponseHeader(String name, String value) {
        this.response.setHeader(name, value);
    }

    public String queryLookup(String name) {
        return this.queries.get(name.toLowerCase());
    }

    public String getResourcePath() {
        return this.svcinfo.getResourcePath();
    }

    String relpath(String path) {
        return DapUtil.canonicalpath((String)path, (boolean)true);
    }
}

