/*
 * Decompiled with CFR 0.152.
 */
package dap4.servlet;

import dap4.ce.CEConstraint;
import dap4.core.dmr.DapAtomicVariable;
import dap4.core.dmr.DapDataset;
import dap4.core.dmr.DapNode;
import dap4.core.dmr.DapStructure;
import dap4.core.dmr.DapType;
import dap4.core.dmr.DapVariable;
import dap4.core.util.DapException;
import dap4.core.util.DapSort;
import dap4.core.util.Odometer;
import dap4.core.util.Slice;
import dap4.servlet.ChunkWriter;
import dap4.servlet.DMRPrint;
import dap4.servlet.DapSerializer;
import dap4.servlet.RandomValue;
import dap4.servlet.SerialWriter;
import dap4.servlet.Value;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteOrder;
import java.util.List;

public class Generator
extends DapSerializer {
    static final boolean PARSEDEBUG = false;
    static final boolean DEBUG = false;
    static final String LBRACE = "{";
    static final String RBRACE = "}";
    static final int DEFALTCACHELIMIT = 4;
    static final ByteOrder DEFAULTORDER = ByteOrder.LITTLE_ENDIAN;
    static final String DATADIR = "tests/src/test/data";
    static final String TESTSRC = "tests/src/test/data/resources/testfiles";
    static final String SERIALEXT = ".ser";
    static final String SRCEXT = ".dmr.ser";
    static final String DSTEXT = ".dap.ser";
    Value.ValueSource source = null;
    protected Value values = null;
    protected ByteArrayOutputStream stream = null;
    protected byte[] serialization = null;
    protected ChunkWriter cw = null;
    protected CEConstraint ce = null;

    public Generator(Value.ValueSource src) throws DapException {
        if (src == null) {
            src = Value.ValueSource.RANDOM;
        }
        switch (src) {
            default: 
        }
        this.values = new RandomValue();
        SerialWriter.DEBUG = false;
    }

    public void generate(DapDataset dmr, CEConstraint ce, ChunkWriter cw) throws DapException {
        this.dmr = dmr;
        this.cw = cw;
        this.ce = ce;
        this.order = cw.getOrder();
        this.generate();
    }

    protected void generate() throws DapException {
        try {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            DMRPrint dp = new DMRPrint(pw);
            dp.print((DapNode)this.dmr, this.ce);
            pw.close();
            sw.close();
            String tmp = sw.toString();
            this.cw.writeDMR(tmp);
            this.cw.flush();
            this.writer = new SerialWriter(this.cw, this.order);
            this.generateData();
        }
        catch (Exception e) {
            throw new DapException((Throwable)e);
        }
    }

    protected void generateData() throws DapException {
        this.writer.startDataset();
        for (DapVariable var : this.dmr.getTopVariables()) {
            if (!this.ce.references((DapNode)var)) continue;
            this.generateVar(var);
        }
        this.writer.endDataset();
    }

    protected void generateVar(DapVariable dapvar) throws DapException {
        this.writer.startVariable();
        if (dapvar.getSort() == DapSort.ATOMICVARIABLE) {
            this.generateAtomicVar(dapvar);
        } else {
            this.generateStructureVar(dapvar);
        }
        try {
            this.writer.endVariable();
        }
        catch (IOException ioe) {
            throw new DapException((Throwable)ioe);
        }
    }

    protected void generateAtomicVar(DapVariable dapvar) throws DapException {
        DapType basetype = ((DapAtomicVariable)dapvar).getBaseType();
        Odometer.ScalarOdometer odom = null;
        if (dapvar.getRank() == 0) {
            odom = Odometer.getScalarOdometer();
        } else {
            List<Slice> slices = this.ce.getVariableSlices(dapvar);
            odom = new Odometer(slices, dapvar.getDimensions());
        }
        while (odom.hasNext()) {
            Object value = this.values.nextValue(basetype);
            try {
                this.writer.writeObject(basetype, value);
            }
            catch (IOException ioe) {
                throw new DapException((Throwable)ioe);
            }
            odom.next();
        }
    }

    void generateStructureVar(DapVariable dapvar) throws DapException {
        DapStructure struct = (DapStructure)dapvar;
        List fields = struct.getFields();
        Odometer.ScalarOdometer odom = null;
        if (dapvar.getRank() == 0) {
            odom = Odometer.getScalarOdometer();
        } else {
            List<Slice> slices = this.ce.getVariableSlices(dapvar);
            odom = new Odometer(slices, struct.getDimensions());
        }
        while (odom.hasNext()) {
            for (int i = 0; i < fields.size(); ++i) {
                DapVariable field = (DapVariable)fields.get(i);
                this.generateVar(field);
            }
            odom.next();
        }
    }
}

