/*
 * Decompiled with CFR 0.152.
 */
package dap4.servlet;

import dap4.core.dmr.AtomicType;
import dap4.core.dmr.DapEnum;
import dap4.core.dmr.DapType;
import dap4.core.util.DapException;
import dap4.servlet.Value;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Random;

public class RandomValue
extends Value {
    static final long SEED = 37L;
    Random random = new Random(37L);
    static final String[] protocols = new String[]{"http", "https"};
    static final String legal = "abcdefghijklmnoqqrstuvwxyzABCDEFGHIJKLMNOQQRSTUVWXYZ0123456789_";

    @Override
    public Value.ValueSource source() {
        return Value.ValueSource.RANDOM;
    }

    @Override
    public Object nextValue(DapType basetype) throws DapException {
        AtomicType atomtype = basetype.getAtomicType();
        long l = 0L;
        if (atomtype.isIntegerType()) {
            l = this.random.nextInt(5000);
            if (atomtype.isUnsigned()) {
                BigInteger bi = BigInteger.valueOf(l);
                bi = bi.and(MASK);
                l = bi.longValue();
            }
        }
        switch (atomtype) {
            case Int8: 
            case UInt8: {
                return new Byte((byte)(l & 0xFFL));
            }
            case Int16: {
                return new Short((short)l);
            }
            case UInt16: {
                return new Short((short)(l & 0xFFFFL));
            }
            case Int32: {
                return new Integer((int)l);
            }
            case UInt32: {
                return new Integer((int)(l & 0xFFFFFFFFFFFFFFFFL));
            }
            case Int64: 
            case UInt64: {
                return new Long(l);
            }
            case Float32: {
                return new Float(this.random.nextFloat());
            }
            case Float64: {
                return new Double(this.random.nextDouble());
            }
            case Char: {
                return Character.valueOf(this.nextString(this.random, 1, 32, 127).charAt(0));
            }
            case String: {
                return this.nextString(this.random, 10, 32, 127);
            }
            case URL: {
                return this.nextURL();
            }
            case Opaque: {
                int length = 2 + this.random.nextInt(8) * 2;
                byte[] bytes = new byte[length];
                this.random.nextBytes(bytes);
                return ByteBuffer.wrap(bytes);
            }
            case Enum: {
                return this.nextEnum((DapEnum)basetype);
            }
        }
        throw new DapException("Unexpected type: " + basetype);
    }

    Object nextEnum(DapEnum en) {
        long l;
        AtomicType basetype = en.getBaseType().getAtomicType();
        List ecnames = en.getNames();
        BigInteger[] econsts = new BigInteger[ecnames.size()];
        for (int i = 0; i < econsts.length; ++i) {
            l = en.lookup((String)ecnames.get(i));
            econsts[i] = BigInteger.valueOf(l);
            if (basetype != AtomicType.UInt64) continue;
            econsts[i] = econsts[i].and(MASK);
        }
        int index = this.random.nextInt(econsts.length);
        l = econsts[index].longValue();
        Number val = null;
        switch (basetype) {
            case Int8: {
                val = new Byte((byte)l);
                break;
            }
            case UInt8: {
                val = new Byte((byte)(l & 0xFFL));
                break;
            }
            case Int16: {
                val = new Short((short)l);
                break;
            }
            case UInt16: {
                val = new Short((short)(l & 0xFFFFL));
                break;
            }
            case Int32: {
                val = new Integer((int)l);
                break;
            }
            case UInt32: {
                val = new Integer((int)(l & 0xFFFFFFFFL));
                break;
            }
            case Int64: {
                val = new Long(l);
                break;
            }
            case UInt64: {
                val = new Long(l);
            }
        }
        return val;
    }

    String nextString(Random random, int maxlength, int min, int max) {
        int length = random.nextInt(maxlength);
        if (length == 0) {
            length = 1;
        }
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            int c = random.nextInt(max - min) + min;
            buf.append((char)c);
        }
        return buf.toString();
    }

    String nextURL() {
        int c;
        int j;
        int i;
        StringBuilder url = new StringBuilder();
        url.append(protocols[this.random.nextInt(protocols.length)]);
        url.append("://");
        for (i = 0; i < 3; ++i) {
            if (i > 0) {
                url.append(".");
            }
            for (j = 0; j < 8; ++j) {
                while (legal.indexOf(c = this.random.nextInt(122)) < 0) {
                }
                url.append((char)c);
            }
        }
        if (this.random.nextBoolean()) {
            url.append(String.format(":%d", this.random.nextInt(5000) + 1));
        }
        for (i = 0; i < 4; ++i) {
            url.append("/");
            for (j = 0; j < 8; ++j) {
                while (legal.indexOf(c = this.random.nextInt(122)) < 0) {
                }
                url.append((char)c);
            }
        }
        return url.toString();
    }
}

