/*
 * Decompiled with CFR 0.152.
 */
package dap4.servlet;

import dap4.core.util.DapException;
import dap4.core.util.DapUtil;
import java.io.File;
import java.util.Set;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServlet;

public class ServletInfo {
    public static final String RESOURCEDIRNAME = "resources";
    HttpServlet servlet = null;
    ServletConfig servletconfig = null;
    ServletContext servletcontext = null;
    String servletname = null;
    String resourcedir = null;

    public ServletInfo(HttpServlet sv) throws DapException {
        this.servlet = sv;
        this.servletconfig = sv.getServletConfig();
        if (this.servletconfig == null) {
            throw new DapException("Cannot locate servlet config object");
        }
        this.servletcontext = this.servletconfig.getServletContext();
        this.servletname = this.servletconfig.getServletName();
        if (this.servletconfig != null) {
            Set x1 = this.servletcontext.getResourcePaths("/");
            String x2 = this.servletcontext.getRealPath("/WEB-INF");
            this.resourcedir = this.servletcontext.getRealPath("/WEB-INF/resources");
        } else {
            this.resourcedir = null;
        }
        this.resourcedir = DapUtil.nullify((String)DapUtil.canonicalpath((String)this.resourcedir, (boolean)false));
        if (this.resourcedir == null) {
            throw new DapException("Cannot locate servlet resources directory").setCode(404);
        }
        File f = new File(this.resourcedir);
        if (!(f.exists() && f.isDirectory() && f.canRead())) {
            throw new DapException("Cannot read servlet resources directory: " + f).setCode(404);
        }
    }

    public HttpServlet getServlet() {
        return this.servlet;
    }

    public ServletConfig getServletconfig() {
        return this.servletconfig;
    }

    public ServletContext getServletcontext() {
        return this.servletcontext;
    }

    public String getServletname() {
        return this.servletname;
    }

    public String getResourcePath() {
        return this.resourcedir;
    }
}

