/*
 * Decompiled with CFR 0.152.
 */
package dap4.ce;

import dap4.ce.CEAST;
import dap4.ce.CEConstraint;
import dap4.core.dmr.DapDataset;
import dap4.core.dmr.DapDimension;
import dap4.core.dmr.DapNode;
import dap4.core.dmr.DapSequence;
import dap4.core.dmr.DapStructure;
import dap4.core.dmr.DapVariable;
import dap4.core.util.DapException;
import dap4.core.util.DapSort;
import dap4.core.util.Slice;
import java.util.EnumSet;
import java.util.List;
import java.util.Stack;

public class CECompiler {
    protected Stack<DapVariable> scopestack = null;
    protected DapDataset dataset = null;
    protected CEConstraint ce = null;
    protected CEAST root = null;

    public CEConstraint compile(DapDataset template, CEAST root) throws DapException {
        this.dataset = template;
        this.root = root;
        this.ce = new CEConstraint(this.dataset);
        this.scopestack = new Stack();
        this.compileAST(root);
        return this.ce;
    }

    protected void compileAST(CEAST ast) throws DapException {
        switch (ast.sort) {
            case CONSTRAINT: {
                for (CEAST clause : ast.clauses) {
                    this.compileAST(clause);
                }
                this.ce.expand();
                this.ce.finish();
                break;
            }
            case PROJECTION: {
                this.scopestack.clear();
                this.compileAST(ast.tree);
                break;
            }
            case SEGMENT: {
                this.compilesegment(ast);
                break;
            }
            case SELECTION: {
                this.scopestack.clear();
                this.compileselection(ast);
                break;
            }
            case DEFINE: {
                this.dimredef(ast);
                break;
            }
            default: {
                assert (false) : "uknown CEAST node type";
                break;
            }
        }
    }

    protected void compileselection(CEAST ast) throws DapException {
        DapVariable var = this.compilesegment(ast.projection);
        if (var.getSort() != DapSort.SEQUENCE) {
            throw new DapException("Attempt to apply a filter to a non-sequence variable: " + var.getFQN());
        }
        this.compilefilter((DapSequence)var, ast.filter);
        ast.toString();
        this.ce.setFilter(var, ast.filter);
    }

    protected DapVariable compilesegment(CEAST ast) throws DapException {
        DapVariable parent = this.getParent();
        DapVariable node = null;
        if (parent == null) {
            List matches = this.dataset.findByFQN(ast.name, EnumSet.of(DapSort.ATOMICVARIABLE, DapSort.SEQUENCE, DapSort.STRUCTURE));
            if (matches.size() > 1) {
                throw new DapException("Multiply defined variable name: " + ast.name);
            }
            if (matches.size() == 0) {
                throw new DapException("Undefined variable name: " + ast.name);
            }
            node = (DapNode)matches.get(0);
        } else if (parent.getSort() == DapSort.STRUCTURE) {
            DapStructure struct = (DapStructure)parent;
            node = struct.findByName(ast.name);
        } else if (parent.getSort() == DapSort.SEQUENCE) {
            DapSequence seq = (DapSequence)parent;
            node = seq.findByName(ast.name);
        } else {
            throw new DapException("Attempt to treat non-structure object as structure: " + parent.getFQN());
        }
        if (node == null) {
            throw new DapException("Constraint expression does not reference a known field: " + ast.name);
        }
        if (!(node instanceof DapVariable)) {
            throw new DapException("Attempt to use non-variable in projection: " + node.getFQN());
        }
        DapVariable var = node;
        this.ce.addVariable(var, ast.slices);
        this.scopestack.push(var);
        return var;
    }

    public void compilefilter(DapSequence seq, CEAST expr) throws DapException {
        if (expr == null) {
            return;
        }
        if (expr.sort == CEAST.Sort.SEGMENT) {
            if (expr.subnodes != null) {
                throw new DapException("compilefilter: Non-simple segment:" + expr.name);
            }
            DapVariable field = seq.findByName(expr.name);
            if (field == null) {
                throw new DapException("compilefilter: Unknown filter variable:" + expr.name);
            }
            expr.field = field;
        } else if (expr.sort == CEAST.Sort.EXPR) {
            if (expr.lhs != null) {
                this.compilefilter(seq, expr.lhs);
            }
            if (expr.rhs != null) {
                this.compilefilter(seq, expr.rhs);
            }
            if (expr.lhs != null && expr.rhs != null) {
                boolean rightvar;
                boolean leftvar = expr.lhs.sort == CEAST.Sort.SEGMENT;
                boolean bl = rightvar = expr.rhs.sort == CEAST.Sort.SEGMENT;
                if (rightvar && !leftvar) {
                    CEAST tmp = expr.lhs;
                    expr.lhs = expr.rhs;
                    expr.rhs = tmp;
                    switch (expr.op) {
                        case LT: {
                            expr.op = CEAST.Operator.GT;
                            break;
                        }
                        case LE: {
                            expr.op = CEAST.Operator.GE;
                            break;
                        }
                        case GT: {
                            expr.op = CEAST.Operator.LT;
                            break;
                        }
                        case GE: {
                            expr.op = CEAST.Operator.LE;
                            break;
                        }
                    }
                }
            }
        } else {
            if (expr.sort == CEAST.Sort.CONSTANT) {
                return;
            }
            throw new DapException("compilefilter: Unexpected node type:" + (Object)((Object)expr.sort));
        }
    }

    protected void dimredef(CEAST node) throws DapException {
        DapDimension dim = (DapDimension)this.dataset.findByFQN(node.name, DapSort.DIMENSION);
        if (dim == null) {
            throw new DapException("Constraint dim redef: no dimension name: " + node.name);
        }
        Slice slice = node.slice;
        slice.finish();
        this.ce.addRedef(dim, slice);
    }

    DapVariable getParent() {
        if (this.scopestack.size() > 0) {
            return this.scopestack.peek();
        }
        return null;
    }
}

