/*
 * Decompiled with CFR 0.152.
 */
package dap4.servlet;

import dap4.core.util.DapContext;
import dap4.core.util.DapException;
import dap4.dap4shared.DSP;
import dap4.servlet.CDMDSP;
import dap4.servlet.SynDSP;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public abstract class DSPFactory {
    static List<Class> dspRegistry = new ArrayList<Class>();

    public static void registerDSP(String className) throws DapException {
        try {
            Class<?> klass = DSPFactory.class.getClassLoader().loadClass(className);
            DSPFactory.registerDSP(klass);
        }
        catch (ClassNotFoundException e) {
            throw new DapException((Throwable)e);
        }
    }

    public static void registerDSP(Class klass) {
        DSPFactory.registerDSP(klass, false);
    }

    public static synchronized void registerDSP(Class klass, boolean last) {
        int pos = dspRegistry.indexOf(klass);
        if (pos < 0) {
            if (last) {
                dspRegistry.add(klass);
            } else {
                dspRegistry.add(0, klass);
            }
        }
    }

    public static synchronized boolean dspRegistered(Class klass) {
        return dspRegistry.contains(klass);
    }

    public static synchronized void dspUnregister(Class klass) {
        dspRegistry.remove(klass);
    }

    public static synchronized DSP create(String path) throws DapException {
        for (int i = 0; i < dspRegistry.size(); ++i) {
            try {
                Class testclass = dspRegistry.get(i);
                Method match = testclass.getMethod("match", String.class, DapContext.class);
                boolean ismatch = (Boolean)match.invoke(null, path, null);
                if (!ismatch) continue;
                DSP dsp = (DSP)testclass.newInstance();
                return dsp.open(path);
            }
            catch (Exception e) {
                throw new DapException((Throwable)e);
            }
        }
        return null;
    }

    static {
        DSPFactory.registerDSP(SynDSP.class, true);
        DSPFactory.registerDSP(CDMDSP.class, true);
    }
}

