/*
 * Decompiled with CFR 0.152.
 */
package dap4.servlet;

import dap4.core.dmr.AtomicType;
import dap4.core.dmr.DapEnum;
import dap4.core.dmr.DapType;
import dap4.core.util.DapException;
import dap4.dap4shared.Dap4Util;
import dap4.servlet.Value;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Random;

public class RandomValue
extends Value {
    static final long SEED = 37L;
    protected Random random = new Random(37L);
    protected boolean asciionly = true;
    static final String[] protocols = new String[]{"http", "https"};
    static final String legal = "abcdefghijklmnoqqrstuvwxyzABCDEFGHIJKLMNOQQRSTUVWXYZ0123456789_";

    @Override
    public void setASCII(boolean tf) {
        this.asciionly = tf;
    }

    @Override
    public Value.ValueSource source() {
        return Value.ValueSource.RANDOM;
    }

    @Override
    public Object nextValue(DapType basetype) throws DapException {
        Object value = null;
        AtomicType atomtype = basetype.getAtomicType();
        if (atomtype.isIntegerType()) {
            value = this.nextInteger(basetype);
        } else if (atomtype.isFloatType()) {
            value = this.nextFloat(basetype);
        } else {
            switch (atomtype) {
                case Int8: 
                case UInt8: 
                case Int16: 
                case UInt16: 
                case Int32: 
                case UInt32: 
                case Int64: 
                case UInt64: {
                    value = this.nextInteger(basetype);
                    break;
                }
                case Float32: 
                case Float64: {
                    value = this.nextFloat(basetype);
                    break;
                }
                case Char: {
                    value = Character.valueOf(this.nextString(this.random, 1, 32, 127).charAt(0));
                    break;
                }
                case String: {
                    value = this.nextString(this.random, 10, 32, 127);
                    break;
                }
                case URL: {
                    value = this.nextURL();
                    break;
                }
                case Opaque: {
                    int length = 2 + this.random.nextInt(8) * 2;
                    byte[] bytes = new byte[length];
                    this.random.nextBytes(bytes);
                    value = ByteBuffer.wrap(bytes);
                    break;
                }
                case Enum: {
                    value = this.nextEnum((DapEnum)basetype);
                    break;
                }
                default: {
                    throw new DapException("Unexpected type: " + basetype);
                }
            }
        }
        return value;
    }

    public Object nextInteger(DapType basetype) throws DapException {
        AtomicType atomtype = basetype.getAtomicType();
        if (!atomtype.isIntegerType()) {
            throw new DapException("Unexpected type: " + basetype);
        }
        boolean unsigned = atomtype.isUnsigned();
        int bits = 8 * Dap4Util.daptypeSize((AtomicType)atomtype);
        switch (atomtype) {
            case Int8: {
                return (byte)(this.random.nextInt(256) - 128);
            }
            case UInt8: {
                return (byte)(this.random.nextInt(256) & 0xFF);
            }
            case Int16: {
                return (short)(this.random.nextInt(65536) - 32768);
            }
            case UInt16: {
                return (short)this.random.nextInt(65536);
            }
            case Int32: {
                return this.random.nextInt();
            }
            case UInt32: {
                long l = this.random.nextLong();
                return (int)(l &= 0xFFFFFFFFFFFFFFFFL);
            }
            case Int64: {
                return this.random.nextLong();
            }
            case UInt64: {
                return new BigInteger(64, this.random);
            }
        }
        throw new DapException("Unexpected type: " + basetype);
    }

    public Object nextFloat(DapType basetype) throws DapException {
        AtomicType atomtype = basetype.getAtomicType();
        switch (atomtype) {
            case Float32: {
                return Float.valueOf(this.random.nextFloat());
            }
            case Float64: {
                return this.random.nextDouble();
            }
        }
        throw new DapException("Unexpected type: " + basetype);
    }

    Object nextEnum(DapEnum en) {
        long l;
        AtomicType basetype = en.getBaseType().getAtomicType();
        List ecnames = en.getNames();
        BigInteger[] econsts = new BigInteger[ecnames.size()];
        for (int i = 0; i < econsts.length; ++i) {
            l = en.lookup((String)ecnames.get(i));
            econsts[i] = BigInteger.valueOf(l);
            if (basetype != AtomicType.UInt64) continue;
            econsts[i] = econsts[i].and(MASK);
        }
        int index = this.random.nextInt(econsts.length);
        l = econsts[index].longValue();
        Number val = null;
        switch (basetype) {
            case Int8: {
                val = new Byte((byte)l);
                break;
            }
            case UInt8: {
                val = new Byte((byte)(l & 0xFFL));
                break;
            }
            case Int16: {
                val = new Short((short)l);
                break;
            }
            case UInt16: {
                val = new Short((short)(l & 0xFFFFL));
                break;
            }
            case Int32: {
                val = new Integer((int)l);
                break;
            }
            case UInt32: {
                val = new Integer((int)(l & 0xFFFFFFFFL));
                break;
            }
            case Int64: {
                val = new Long(l);
                break;
            }
            case UInt64: {
                val = new Long(l);
            }
        }
        return val;
    }

    String nextString(Random random, int maxlength, int min, int max) {
        int length = random.nextInt(maxlength) + 1;
        StringBuilder buf = new StringBuilder();
        if (this.asciionly && max > 127) {
            max = 127;
        }
        int range = max + 1 - min;
        for (int i = 0; i < length; ++i) {
            int c = random.nextInt(range);
            buf.append((char)(c += min));
        }
        return buf.toString();
    }

    String nextURL() {
        int c;
        int j;
        int i;
        StringBuilder url = new StringBuilder();
        url.append(protocols[this.random.nextInt(protocols.length)]);
        url.append("://");
        for (i = 0; i < 3; ++i) {
            if (i > 0) {
                url.append(".");
            }
            for (j = 0; j < 8; ++j) {
                while (legal.indexOf(c = this.random.nextInt(122)) < 0) {
                }
                url.append((char)c);
            }
        }
        if (this.random.nextBoolean()) {
            url.append(String.format(":%d", this.random.nextInt(5000) + 1));
        }
        for (i = 0; i < 4; ++i) {
            url.append("/");
            for (j = 0; j < 8; ++j) {
                while (legal.indexOf(c = this.random.nextInt(122)) < 0) {
                }
                url.append((char)c);
            }
        }
        return url.toString();
    }

    @Override
    public int nextCount(int max) throws DapException {
        int min = 1;
        if (max < min || min < 1) {
            throw new DapException("bad range");
        }
        int range = max + 1 - min;
        int n = this.random.nextInt(range);
        return n += min;
    }
}

