/*
 * Decompiled with CFR 0.152.
 */
package dap4.servlet;

import dap4.core.dmr.AtomicType;
import dap4.core.dmr.DapType;
import dap4.core.util.DapDump;
import dap4.core.util.DapException;
import dap4.core.util.DapUtil;
import dap4.core.util.Escape;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.zip.CRC32;
import java.util.zip.Checksum;

public class SerialWriter {
    public static boolean DEBUG = false;
    static final int MAXINTOBJECTSIZE = 8;
    static final int MAXFLOATOBJECTSIZE = 4;
    static final int MAXDOUBLEOBJECTSIZE = 8;
    static final ByteOrder NETWORK_ORDER = ByteOrder.BIG_ENDIAN;
    static final ByteOrder NATIVE_ORDER = ByteOrder.nativeOrder();
    static final int COUNTSIZE = 8;
    protected ByteOrder order = null;
    protected OutputStream output = null;
    protected int depth = 0;
    protected Checksum checksum;
    protected boolean checksumming = true;
    protected boolean serialize = true;
    protected StringBuilder lastchecksum = new StringBuilder();
    protected ByteBuffer longbuffer = null;

    public SerialWriter(OutputStream output, ByteOrder order) {
        this.output = output;
        this.order = order;
        this.longbuffer = ByteBuffer.allocate(8).order(order);
        if ("CRC32".equalsIgnoreCase("CRC32")) {
            this.checksum = new CRC32();
        } else assert (false) : "No such checksum algorithm: CRC32";
    }

    public void computeChecksums(boolean tf) {
        this.checksumming = tf;
    }

    public void noSerialize(boolean tf) {
        this.serialize = !tf;
    }

    public String getLastChecksum() {
        return this.lastchecksum.toString();
    }

    public ByteBuffer encodeObject(DapType vtype, Object value) throws IOException {
        return SerialWriter.encodeObject(vtype, value, this.order);
    }

    public static ByteBuffer encodeObject(DapType vtype, Object value, ByteOrder order) throws IOException {
        AtomicType atomtype = vtype.getPrimitiveType();
        int total = AtomicType.getSize((AtomicType)atomtype);
        ByteBuffer buf = null;
        if (atomtype.isFixedSize()) {
            buf = ByteBuffer.allocate(total).order(order);
        }
        switch (atomtype) {
            case Char: {
                byte b = (byte)(0xFFL & (long)((Character)value).charValue());
                buf.put(b);
                break;
            }
            case UInt8: 
            case Int8: {
                buf.put((Byte)value);
                break;
            }
            case Int16: 
            case UInt16: {
                buf.putShort((Short)value);
                break;
            }
            case Int32: 
            case UInt32: {
                buf.putInt(((Number)value).intValue());
                break;
            }
            case Int64: 
            case UInt64: {
                buf.putLong(((Number)value).longValue());
                break;
            }
            case Float32: {
                buf.putFloat(((Number)value).floatValue());
                break;
            }
            case Float64: {
                buf.putDouble(((Number)value).doubleValue());
                break;
            }
            case URL: 
            case String: {
                String content = value.toString();
                byte[] bytes = content.getBytes(DapUtil.UTF8);
                buf = ByteBuffer.allocate(bytes.length + 8).order(order);
                buf.putLong(bytes.length);
                buf.put(bytes);
                break;
            }
            case Opaque: {
                ByteBuffer opaquedata = (ByteBuffer)value;
                int size = opaquedata.remaining();
                buf = ByteBuffer.allocate(size + 8).order(order);
                buf.putLong(size);
                buf.put(opaquedata);
                break;
            }
            case Enum: {
                assert (false) : "Unexpected ENUM type";
            }
            default: {
                throw new DapException("Unknown type: " + vtype.getTypeName());
            }
        }
        return buf;
    }

    public ByteBuffer encodeArray(DapType vtype, Object values) throws IOException {
        AtomicType atomtype = vtype.getPrimitiveType();
        int count = Array.getLength(values);
        int total = AtomicType.getSize((AtomicType)atomtype) * count;
        ByteBuffer buf = null;
        if (atomtype.isFixedSize()) {
            buf = ByteBuffer.allocate(total).order(this.order);
        }
        switch (atomtype) {
            case Char: {
                char[] datac = (char[])values;
                for (int i = 0; i < datac.length; ++i) {
                    byte b = (byte)(0xFFL & (long)datac[i]);
                    buf.put(b);
                }
                break;
            }
            case UInt8: 
            case Int8: {
                byte[] data8 = (byte[])values;
                buf.put(data8);
                break;
            }
            case Int16: 
            case UInt16: {
                short[] data16 = (short[])values;
                buf.asShortBuffer().put(data16);
                buf.position(total);
                break;
            }
            case Int32: 
            case UInt32: {
                int[] data32 = (int[])values;
                buf.asIntBuffer().put(data32);
                buf.position(total);
                break;
            }
            case Int64: 
            case UInt64: {
                long[] data64 = (long[])values;
                buf.asLongBuffer().put(data64);
                buf.position(total);
                break;
            }
            case Float32: {
                float[] dataf = (float[])values;
                buf.asFloatBuffer().put(dataf);
                buf.position(total);
                break;
            }
            case Float64: {
                double[] datad = (double[])values;
                buf.asDoubleBuffer().put(datad);
                buf.position(total);
                break;
            }
            case URL: 
            case String: {
                byte[] bytes;
                String content;
                int i;
                String[] datas = (String[])values;
                total = 0;
                for (i = 0; i < datas.length; ++i) {
                    content = datas[i];
                    bytes = content.getBytes(DapUtil.UTF8);
                    total += bytes.length + 8;
                }
                buf = ByteBuffer.allocate(total).order(this.order);
                for (i = 0; i < datas.length; ++i) {
                    content = datas[i];
                    bytes = content.getBytes(DapUtil.UTF8);
                    buf.putLong(bytes.length);
                    buf.put(bytes);
                }
                break;
            }
            case Opaque: {
                int i;
                ByteBuffer[] datao = (ByteBuffer[])values;
                total = 0;
                int size = 0;
                ByteBuffer opaquedata = null;
                for (i = 0; i < datao.length; ++i) {
                    opaquedata = datao[i];
                    size = opaquedata.remaining();
                    total += size + 8;
                }
                buf = ByteBuffer.allocate(total).order(this.order);
                for (i = 0; i < datao.length; ++i) {
                    opaquedata = datao[i];
                    size = opaquedata.remaining();
                    buf.putLong(size);
                    int savepos = opaquedata.position();
                    buf.put(opaquedata);
                    opaquedata.position(savepos);
                }
                break;
            }
            case Enum: {
                assert (false) : "Unexpected ENUM type";
            }
            default: {
                throw new DapException("Unknown type: " + vtype.getTypeName());
            }
        }
        return buf;
    }

    public void startGroup() {
    }

    public void endGroup() {
    }

    public void startVariable() {
        if (this.depth == 0) {
            this.checksum.reset();
        }
        ++this.depth;
    }

    public void endVariable() throws IOException {
        --this.depth;
        if (this.depth == 0 && this.checksumming) {
            long digest = this.checksum.getValue();
            this.longbuffer.clear();
            this.longbuffer.putLong(digest);
            byte[] csum = this.longbuffer.array();
            this.lastchecksum.setLength(0);
            for (int i = 0; i < 4; ++i) {
                this.lastchecksum.append(Escape.toHex((int)(csum[i] & 0xFF)));
            }
            if (DEBUG) {
                System.err.print("checksum = " + this.lastchecksum.toString());
                System.err.println();
            }
            this.output.write(csum, 0, 4);
        }
    }

    public void writeObject(DapType daptype, Object value) throws IOException {
        ByteBuffer buf = this.encodeObject(daptype, value);
        byte[] bytes = buf.array();
        int len = buf.position();
        if (this.checksumming) {
            this.checksum.update(bytes, 0, len);
        }
        if (DEBUG) {
            DapDump.dumpbytes((ByteBuffer)buf);
        }
        this.output.write(bytes, 0, len);
        if (DEBUG) {
            System.err.printf("%s: ", daptype.getShortName());
            for (int i = 0; i < len; ++i) {
                byte x = bytes[i];
                System.err.printf("%02x", x & 0xFF);
            }
            System.err.println();
        }
    }

    public void writeCount(long count) throws IOException {
        this.longbuffer.clear();
        this.longbuffer.putLong(count);
        byte[] countbuf = this.longbuffer.array();
        int len = this.longbuffer.position();
        this.output.write(countbuf, 0, len);
        if (DEBUG) {
            System.err.printf("count: %d\n", count);
        }
    }

    public void writeArray(DapType daptype, Object values) throws IOException {
        int count = Array.getLength(values);
        ByteBuffer buf = this.encodeArray(daptype, values);
        byte[] bytes = buf.array();
        int len = buf.position();
        if (this.checksumming) {
            this.checksum.update(bytes, 0, len);
        }
        this.output.write(bytes, 0, len);
        if (DEBUG) {
            System.err.printf("%s: ", daptype.getShortName());
            for (int i = 0; i < len; ++i) {
                byte x = this.order == ByteOrder.BIG_ENDIAN ? bytes[i] : bytes[len - 1 - i];
                System.err.printf("%02x", x & 0xFF);
            }
            System.err.println();
        }
    }

    public void writeBytes(byte[] bytes) throws IOException {
        this.output.write(bytes);
        if (this.checksumming) {
            this.checksum.update(bytes, 0, bytes.length);
        }
    }
}

