/*
 * Decompiled with CFR 0.152.
 */
package dap4.servlet;

import dap4.core.util.DapContext;
import dap4.core.util.DapDump;
import dap4.core.util.DapException;
import dap4.core.util.DapUtil;
import dap4.dap4shared.ChunkInputStream;
import dap4.dap4shared.D4DSP;
import dap4.dap4shared.DSP;
import dap4.dap4shared.RequestMode;
import dap4.servlet.ChunkWriter;
import dap4.servlet.Generator;
import dap4.servlet.Value;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class SynDSP
extends D4DSP {
    protected static final String[] SYNEXTENSIONS = new String[]{".dmr", ".syn"};
    protected byte[] raw = null;

    public SynDSP() {
        this.setOrder(ByteOrder.nativeOrder());
    }

    public static boolean match(String path, DapContext context) {
        for (String ext : SYNEXTENSIONS) {
            if (!path.endsWith(ext)) continue;
            return true;
        }
        return false;
    }

    public void close() {
    }

    public DSP open(String path, DapContext context) throws DapException {
        String document;
        this.setPath(path);
        try {
            FileInputStream stream = new FileInputStream(path);
            document = DapUtil.readtextfile((InputStream)stream);
            stream.close();
        }
        catch (IOException ioe) {
            throw new DapException((Throwable)ioe);
        }
        this.dmr = this.parseDMR(document);
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ChunkWriter cw = new ChunkWriter(bos, RequestMode.DAP, ByteOrder.nativeOrder());
            Generator generator = new Generator(this.dmr, Value.ValueSource.RANDOM);
            generator.generate(null, cw);
            cw.close();
            bos.close();
            byte[] raw = bos.toByteArray();
            if (DEBUG) {
                DapDump.dumpbytes((ByteBuffer)ByteBuffer.wrap(raw).order(this.order), (boolean)true);
            }
            ByteArrayInputStream bis = new ByteArrayInputStream(raw);
            ChunkInputStream crdr = new ChunkInputStream((InputStream)bis, RequestMode.DAP, this.getOrder());
            String dmr2 = crdr.readDMR();
            this.raw = DapUtil.readbinaryfile((InputStream)crdr);
            super.build(this.dmr, this.raw, this.getOrder());
            return this;
        }
        catch (IOException ioe) {
            throw new DapException((Throwable)ioe);
        }
    }
}

