/*
 * Decompiled with CFR 0.152.
 */
package dap4.servlet;

import dap4.core.data.DataCompound;
import dap4.core.data.DataCompoundArray;
import dap4.core.data.DataException;
import dap4.core.data.DataSort;
import dap4.core.dmr.DapNode;
import dap4.core.dmr.DapStructure;
import dap4.core.dmr.DapVariable;
import dap4.core.util.DapException;
import dap4.core.util.DapSort;
import dap4.core.util.DapUtil;
import dap4.core.util.Odometer;
import dap4.core.util.Slice;
import dap4.dap4shared.AbstractDataVariable;
import dap4.servlet.CDMDSP;
import dap4.servlet.CDMDataStructure;
import java.util.Arrays;
import java.util.List;
import ucar.ma2.ArrayStructure;
import ucar.ma2.StructureData;
import ucar.nc2.Variable;

public class CDMDataCompoundArray
extends AbstractDataVariable
implements DataCompoundArray {
    protected CDMDSP dsp = null;
    protected Variable cdmvar = null;
    protected DataCompound[] instances = null;
    protected ArrayStructure array = null;
    protected int[] shape = null;
    protected long nelems = 0L;

    public CDMDataCompoundArray(CDMDSP dsp, DapVariable dv, ArrayStructure array) throws DataException {
        super((DapNode)dv);
        this.dsp = dsp;
        this.template = dv;
        this.cdmvar = (Variable)dsp.getCDMNode((DapNode)dv);
        this.array = array;
        this.shape = array.getShape();
        if (this.shape.length == 0) {
            this.shape = null;
        }
        this.nelems = 1L;
        if (this.shape != null) {
            for (int i = 0; i < this.shape.length; ++i) {
                this.nelems *= (long)this.shape[i];
            }
        }
        this.instances = new DataCompound[(int)this.nelems];
        Arrays.fill(this.instances, null);
    }

    public DataSort getElementSort() {
        if (this.getTemplate().getSort() == DapSort.SEQUENCE) {
            return DataSort.SEQUENCE;
        }
        return DataSort.STRUCTURE;
    }

    public long getCount() {
        return this.nelems;
    }

    public DataCompound read(long index) throws DataException {
        if (this.instances[(int)index] == null) {
            this.instances[(int)index] = new CDMDataStructure(this.dsp, (DapStructure)this.getTemplate(), this, index, this.array.getStructureData((int)index));
        }
        return this.instances[(int)index];
    }

    public void read(List<Slice> slices, DataCompound[] result) throws DataException {
        Odometer odom;
        long count = DapUtil.sliceProduct(slices);
        if (count > (long)result.length) {
            throw new DataException("read(slices,result): result is too short");
        }
        try {
            odom = Odometer.factory(slices, (List)((DapVariable)this.getTemplate()).getDimensions(), (boolean)false);
        }
        catch (DapException de) {
            throw new DataException((Throwable)de);
        }
        int i = 0;
        while (odom.hasNext()) {
            long offset = odom.next();
            int ioffset = (int)offset;
            if (this.instances[ioffset] == null) {
                StructureData data = this.array.getStructureData(ioffset);
                this.instances[ioffset] = new CDMDataStructure(this.dsp, (DapStructure)this.getTemplate(), this, offset, data);
            }
            result[i] = this.instances[ioffset];
            ++i;
        }
    }
}

