/*
 * Decompiled with CFR 0.152.
 */
package dap4.servlet;

import dap4.core.util.DapException;
import dap4.core.util.DapUtil;
import dap4.dap4shared.XURI;
import dap4.servlet.URLMap;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.SortedMap;
import java.util.TreeMap;

public class URLMapDefault
implements URLMap {
    SortedMap<String, String> url2path = new TreeMap<String, String>();
    SortedMap<String, String> path2url = new TreeMap<String, String>();

    @Override
    public void addEntry(String urlpath, String fileprefix) throws DapException {
        String urlprefix = DapUtil.canonicalpath((String)urlpath);
        fileprefix = DapUtil.canonicalpath((String)fileprefix);
        this.url2path.put(urlprefix, fileprefix);
        this.path2url.put(fileprefix, urlprefix);
    }

    public void load(String filepath) throws IOException {
        String[] lines;
        try (FileInputStream is = new FileInputStream(filepath);){
            String content = DapUtil.readtextfile((InputStream)is);
            lines = content.split("[\n]");
        }
        for (String line : lines) {
            String[] pieces = line.split("[=]");
            if (pieces.length != 2) {
                throw new IOException("File: " + filepath + "; malformed line: " + line);
            }
            this.addEntry(pieces[0], pieces[1]);
        }
    }

    @Override
    public URLMap.Result mapURL(String urlpath) throws DapException {
        urlpath = DapUtil.canonicalpath((String)urlpath);
        URLMap.Result result = this.longestmatch(this.url2path, urlpath);
        return result;
    }

    @Override
    public URLMap.Result mapPath(String path) throws DapException {
        path = DapUtil.canonicalpath((String)path);
        URLMap.Result result = this.longestmatch(this.path2url, path);
        return result;
    }

    protected URLMap.Result longestmatch(SortedMap<String, String> map, String prefix) {
        URLMap.Result result = new URLMap.Result();
        String longestmatch = prefix;
        result.prefix = (String)map.get(prefix);
        if (result.prefix == null) {
            SortedMap<String, String> submap = map.headMap(prefix);
            if (submap.size() == 0) {
                return null;
            }
            longestmatch = submap.lastKey();
            result.prefix = (String)submap.get(longestmatch);
        }
        result.suffix = prefix.substring(longestmatch.length(), prefix.length());
        return result;
    }

    protected StringBuilder canonURL(XURI xurl) {
        String proto = xurl.getLeadProtocol();
        String host = xurl.getHost();
        String path = DapUtil.canonicalpath((String)xurl.getPath());
        StringBuilder urlbuf = new StringBuilder();
        if (proto != null && proto.length() > 0) {
            urlbuf.append(proto + "://");
        }
        urlbuf.append(host);
        if (path == null) {
            path = "";
        }
        urlbuf.append("/" + path);
        return urlbuf;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        for (String url : this.url2path.keySet()) {
            buf.append(url + " <=> " + (String)this.url2path.get(url));
        }
        return buf.toString();
    }
}

