/*
 * Decompiled with CFR 0.152.
 */
package dap4.servlet;

import dap4.core.util.DapException;
import dap4.core.util.DapUtil;
import dap4.core.util.Escape;
import dap4.core.util.ResponseFormat;
import dap4.dap4shared.RequestMode;
import dap4.servlet.DapLog;
import dap4.servlet.ServletInfo;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DapRequest {
    protected ServletInfo svcinfo = null;
    protected HttpServletRequest request = null;
    protected HttpServletResponse response = null;
    protected String url = null;
    protected String servletpath = null;
    protected String contextpath = null;
    protected String datasetpath = null;
    protected String querystring = null;
    protected String server = null;
    protected RequestMode mode = null;
    protected ResponseFormat format = null;
    protected Map<String, String> queries = new HashMap<String, String>();

    public DapRequest(ServletInfo svcinfo, HttpServletRequest request, HttpServletResponse response) throws DapException {
        this.svcinfo = svcinfo;
        this.request = request;
        this.response = response;
        try {
            this.parse();
        }
        catch (IOException ioe) {
            throw new DapException((Throwable)ioe);
        }
    }

    protected void parse() throws IOException {
        String[] pieces;
        this.url = this.request.getRequestURL().toString();
        this.querystring = this.request.getQueryString();
        this.servletpath = DapUtil.absolutize((String)this.request.getServletPath());
        this.contextpath = DapUtil.nullify((String)this.request.getContextPath());
        this.datasetpath = this.request.getPathInfo();
        this.datasetpath = DapUtil.canonicalpath((String)this.datasetpath);
        this.datasetpath = DapUtil.absolutize((String)this.datasetpath);
        String servletprefix = "/" + this.svcinfo.getServletname();
        if (this.servletpath != null && !this.servletpath.equals(servletprefix)) {
            if (!this.servletpath.startsWith(servletprefix)) {
                this.servletpath = servletprefix + this.servletpath;
            }
            this.datasetpath = this.servletpath.substring(servletprefix.length(), this.servletpath.length());
            this.datasetpath = DapUtil.canonicalpath((String)this.datasetpath);
        }
        this.servletpath = servletprefix;
        this.datasetpath = DapUtil.nullify((String)this.datasetpath);
        StringBuilder buf = new StringBuilder();
        buf.append(this.request.getScheme());
        buf.append("://");
        buf.append(this.request.getServerName());
        int port = this.request.getServerPort();
        if (port > 0) {
            buf.append(":");
            buf.append(port);
        }
        this.server = buf.toString();
        this.mode = null;
        if (this.datasetpath == null) {
            this.mode = RequestMode.CAPABILITIES;
            this.format = ResponseFormat.HTML;
        } else {
            pieces = this.datasetpath.split("[.]");
            int modepos = 0;
            for (int i = pieces.length - 1; i >= 1; --i) {
                String ext = pieces[i];
                RequestMode mode = RequestMode.modeFor((String)ext);
                ResponseFormat format = ResponseFormat.formatFor((String)ext);
                if (mode != null) {
                    this.mode = mode;
                    modepos = i;
                    break;
                }
                if (format == null) continue;
                if (this.format != null) {
                    throw new DapException("Multiple response formats specified: " + ext).setCode(400);
                }
                this.format = format;
            }
            if (modepos > 0) {
                this.datasetpath = DapUtil.join((String[])pieces, (String)".", (int)0, (int)modepos);
            }
        }
        if (this.mode == null) {
            this.mode = RequestMode.DSR;
        }
        if (this.format == null) {
            this.format = ResponseFormat.NONE;
        }
        buf.setLength(0);
        buf.append(this.server);
        if (this.servletpath != null) {
            buf.append(this.servletpath);
        }
        if (this.datasetpath != null) {
            buf.append(this.datasetpath);
        }
        this.url = buf.toString();
        if (this.querystring != null && this.querystring.length() > 0) {
            for (String piece : pieces = this.querystring.split("&")) {
                String[] pair = piece.split("=");
                String name = Escape.urlDecode((String)pair[0]);
                name = name.toLowerCase();
                String value = pair.length == 2 ? Escape.urlDecode((String)pair[1]) : "";
                this.queries.put(name, value);
            }
        }
        DapLog.debug("DapRequest: realrootdir=" + this.getRealPath(""));
        DapLog.debug("DapRequest: extension=" + (this.mode == null ? "null" : this.mode.extension()));
        DapLog.debug("DapRequest: servletpath=" + this.servletpath);
        DapLog.debug("DapRequest: datasetpath=" + this.datasetpath);
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public OutputStream getOutputStream() throws IOException {
        return this.response.getOutputStream();
    }

    public String getURL() {
        return this.url;
    }

    public String getOriginalURL() {
        return this.querystring == null ? this.url : this.url + "?" + this.querystring;
    }

    public String getDataset() {
        return this.datasetpath;
    }

    public String getServletPath() {
        return this.servletpath;
    }

    public String getURLPath() {
        return this.servletpath + (this.datasetpath == null ? "" : this.datasetpath);
    }

    public RequestMode getMode() {
        return this.mode;
    }

    public ResponseFormat getFormat() {
        return this.format;
    }

    public void setResponseHeader(String name, String value) {
        this.response.setHeader(name, value);
    }

    public String queryLookup(String name) {
        return this.queries.get(name.toLowerCase());
    }

    public String getRealPath(String virtual) {
        return this.svcinfo.getRealPath(virtual);
    }

    public String getPathInfo() {
        String path = this.request.getPathInfo();
        if (path == null) {
            path = "";
        }
        return path;
    }
}

