/*
 * Decompiled with CFR 0.152.
 */
package dap4.servlet;

import dap4.ce.CEConstraint;
import dap4.dap4shared.DSP;
import dap4.servlet.DSPFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public abstract class DapCache {
    static final int MAXFILES = 100;
    protected static List<DSP> lru = new ArrayList<DSP>();
    protected static DSPFactory factory = null;

    public static void setFactory(DSPFactory f) {
        factory = f;
    }

    public static DSPFactory getFactory() {
        return factory;
    }

    public static synchronized DSP open(String path) throws IOException {
        int lrusize = lru.size();
        for (int i = lrusize - 1; i >= 0; --i) {
            DSP dsp = lru.get(i);
            String dsppath = dsp.getPath();
            if (!dsppath.equals(path)) continue;
            lru.remove(i);
            lru.add(dsp);
            return dsp;
        }
        if (lrusize == 100) {
            lru.remove(0);
            CEConstraint.release(lru.get(0).getDMR());
        }
        DSP dsp = factory.create(path);
        lru.add(dsp);
        return dsp;
    }

    public static synchronized void flush() throws Exception {
        while (lru.size() > 0) {
            DSP dsp = lru.get(0);
            CEConstraint.release(dsp.getDMR());
            dsp.close();
            lru.remove(0);
        }
    }
}

