/*
 * Decompiled with CFR 0.152.
 */
package dap4.servlet;

import dap4.ce.CEAST;
import dap4.ce.CECompiler;
import dap4.ce.CEConstraint;
import dap4.ce.parser.CEParser;
import dap4.core.dmr.DapDataset;
import dap4.core.dmr.ErrorResponse;
import dap4.core.util.DapException;
import dap4.core.util.DapUtil;
import dap4.core.util.ResponseFormat;
import dap4.dap4shared.DSP;
import dap4.dap4shared.DapProtocol;
import dap4.dap4shared.RequestMode;
import dap4.servlet.ChunkWriter;
import dap4.servlet.DMRPrint;
import dap4.servlet.DapCache;
import dap4.servlet.DapDSR;
import dap4.servlet.DapLog;
import dap4.servlet.DapRequest;
import dap4.servlet.DapSerializer;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import javax.annotation.PostConstruct;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.ServletContextAware;

public abstract class DapController
implements ServletContextAware {
    public static final boolean DEBUG = false;
    public static final boolean PARSEDEBUG = false;
    protected static final String BIG_ENDIAN = "Big-Endian";
    protected static final String LITTLE_ENDIAN = "Little-Endian";
    protected static boolean IS_BIG_ENDIAN = ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN;
    protected static final String DMREXT = ".dmr";
    protected static final String DATAEXT = ".dap";
    protected static final String DSREXT = ".dsr";
    protected static final String[] ENDINGS = new String[]{".dmr", ".dap", ".dsr"};
    protected static final String FAVICON = "favicon.ico";
    public static final long DEFAULTBINARYWRITELIMIT = 100000000L;
    protected static DapCache cache = null;
    protected static long binarywritelimit = 100000000L;
    protected boolean compress = true;
    protected transient ByteOrder byteorder = ByteOrder.nativeOrder();
    protected transient DapDSR dsrbuilder = new DapDSR();
    protected transient String controllerpath = null;
    protected transient String resourcepath = null;
    protected transient ServletContext servletcontext = null;

    protected static void setCache(DapCache cache) {
        DapController.cache = cache;
    }

    protected static DapCache getCache() {
        return cache;
    }

    public static void setBinaryWritelimit(long limit) {
        binarywritelimit = limit;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletcontext = this.servletcontext;
    }

    public DapController(String controllerpath) {
        this.controllerpath = DapUtil.canonjoin((String)"", (String)controllerpath);
    }

    protected abstract void doFavicon(DapRequest var1, String var2) throws IOException;

    protected abstract void doCapabilities(DapRequest var1) throws IOException;

    protected abstract String getResourcePath(DapRequest var1, String var2) throws IOException;

    protected abstract long getBinaryWriteLimit();

    @PostConstruct
    public void init() throws ServletException {
        Logger logServerStartup = LoggerFactory.getLogger((String)"serverStartup");
        logServerStartup.info(this.getClass().getName() + " initialization start");
        try {
            System.setProperty("file.encoding", "UTF-8");
            Field charset = Charset.class.getDeclaredField("defaultCharset");
            charset.setAccessible(true);
            charset.set(null, null);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        DapController.setBinaryWritelimit(this.getBinaryWriteLimit());
    }

    public void handleRequest(HttpServletRequest req, HttpServletResponse res) throws IOException {
        DapLog.debug("doGet(): User-Agent = " + req.getHeader("User-Agent"));
        if (this.servletcontext == null) {
            this.servletcontext = req.getServletContext();
        }
        DapRequest drq = this.getRequestState(req, res);
        String url = req.getRequestURI().toString();
        String query = req.getQueryString();
        StringBuilder info = new StringBuilder("doGet():");
        info.append(" dataset = ");
        info.append(this.resourcepath);
        info.append(" url = ");
        info.append(url);
        if (query != null && query.length() >= 0) {
            info.append("?");
            info.append(query);
            DapLog.debug(info.toString());
        }
        if (url.endsWith(FAVICON)) {
            this.doFavicon(drq, FAVICON);
            return;
        }
        String datasetpath = DapUtil.nullify((String)drq.getDataset());
        try {
            if (datasetpath == null) {
                this.doCapabilities(drq);
            } else {
                RequestMode mode = drq.getMode();
                if (mode == null) {
                    throw new DapException("Unrecognized request extension").setCode(400);
                }
                switch (mode) {
                    case DMR: {
                        this.doDMR(drq);
                        break;
                    }
                    case DAP: {
                        this.doData(drq);
                        break;
                    }
                    case DSR: {
                        this.doDSR(drq);
                        break;
                    }
                    default: {
                        throw new DapException("Unrecognized request extension").setCode(400);
                    }
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            int code = 400;
            if (t instanceof FileNotFoundException) {
                code = 404;
            } else if (t instanceof UnsupportedOperationException) {
                code = 403;
            } else if (t instanceof MalformedURLException) {
                code = 404;
            } else if (t instanceof IOException) {
                code = 400;
            } else if (t instanceof DapException) {
                code = ((DapException)t).getCode();
                if (code <= 0) {
                    code = 400;
                }
            } else {
                code = 500;
            }
            this.senderror(drq, code, t);
        }
    }

    protected void doDSR(DapRequest drq) throws IOException {
        try {
            String dsr = this.dsrbuilder.generate(drq.getURL());
            OutputStream out = drq.getOutputStream();
            this.addCommonHeaders(drq);
            ChunkWriter cw = new ChunkWriter(out, RequestMode.DSR, this.byteorder);
            cw.writeDSR(dsr);
            cw.close();
        }
        catch (IOException ioe) {
            throw new DapException("DSR generation error", (Throwable)ioe).setCode(500);
        }
    }

    protected void doDMR(DapRequest drq) throws IOException {
        DSP dsp = DapCache.open(drq.getResourcePath());
        DapDataset dmr = dsp.getDMR();
        CEConstraint ce = null;
        String sce = drq.queryLookup("dap4.ce");
        ce = this.buildconstraint(drq, sce, dmr);
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        DMRPrint dapprinter = new DMRPrint(pw);
        dapprinter.printDMR(ce, dmr);
        pw.close();
        sw.close();
        String sdmr = sw.toString();
        this.addCommonHeaders(drq);
        OutputStream out = drq.getOutputStream();
        ChunkWriter cw = new ChunkWriter(out, RequestMode.DMR, this.byteorder);
        cw.writeDMR(sdmr);
        cw.close();
    }

    protected void doData(DapRequest drq) throws IOException {
        DSP dsp = DapCache.open(drq.getResourcePath());
        if (dsp == null) {
            throw new IOException("No such file: " + drq.getResourcePath());
        }
        DapDataset dmr = dsp.getDMR();
        CEConstraint ce = null;
        String sce = drq.queryLookup("dap4.ce");
        ce = this.buildconstraint(drq, sce, dmr);
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        DMRPrint dapprinter = new DMRPrint(pw);
        dapprinter.printDMR(ce, dmr);
        pw.close();
        sw.close();
        String sdmr = sw.toString();
        OutputStream out = drq.getOutputStream();
        ChunkWriter cw = new ChunkWriter(out, RequestMode.DAP, this.byteorder);
        cw.setWriteLimit(binarywritelimit);
        cw.writeDMR(sdmr);
        cw.flush();
        this.addCommonHeaders(drq);
        DapSerializer writer = new DapSerializer(dsp, ce, cw, this.byteorder);
        writer.write(dsp.getDMR());
        cw.flush();
        cw.close();
    }

    protected void addCommonHeaders(DapRequest drq) throws IOException {
        DapProtocol.ContentType contentheaders;
        String header;
        ResponseFormat format = drq.getFormat();
        if (format == null) {
            format = ResponseFormat.NONE;
        }
        if ((header = (contentheaders = (DapProtocol.ContentType)DapProtocol.contenttypes.get(drq.getMode())).getFormat(format)) != null) {
            header = header + "; charset=utf-8";
            drq.setResponseHeader("Content-Type", header);
        } else {
            DapLog.error("Cannot determine response Content-Type");
        }
    }

    protected DapRequest getRequestState(HttpServletRequest rq, HttpServletResponse rsp) throws IOException {
        return new DapRequest(this, rq, rsp);
    }

    protected void senderror(DapRequest drq, int httpcode, Throwable t) throws IOException {
        if (httpcode == 0) {
            httpcode = 400;
        }
        ErrorResponse err = new ErrorResponse();
        err.setCode(httpcode);
        err.setMessage(t == null ? "Servlet Error" : t.getMessage());
        err.setContext(drq.getURL());
        String errormsg = err.buildXML();
        drq.getResponse().sendError(httpcode, errormsg);
    }

    protected CEConstraint buildconstraint(DapRequest drq, String sce, DapDataset dmr) throws IOException {
        if (sce == null || sce.length() == 0) {
            return CEConstraint.getUniversal(dmr);
        }
        CEParser ceparser = new CEParser(dmr);
        boolean parseok = ceparser.parse(sce);
        if (!parseok) {
            throw new IOException("Constraint Parse failed: " + sce);
        }
        CEAST root = ceparser.getConstraint();
        CECompiler compiler = new CECompiler();
        CEConstraint ce = compiler.compile(dmr, root);
        ce.expand();
        ce.finish();
        return ce;
    }
}

