/*
 * Decompiled with CFR 0.152.
 */
package dap4.servlet;

import dap4.core.util.DapException;
import dap4.core.util.DapUtil;
import dap4.core.util.Escape;
import dap4.core.util.ResponseFormat;
import dap4.dap4shared.RequestMode;
import dap4.servlet.DapController;
import dap4.servlet.DapLog;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DapRequest {
    public static final String WEBINFPATH = "/WEB-INF";
    public static final String RESOURCEDIRNAME = "resources";
    protected HttpServletRequest request = null;
    protected HttpServletResponse response = null;
    protected String url = null;
    protected String querystring = null;
    protected String datasetpath = null;
    protected String server = null;
    protected RequestMode mode = null;
    protected ResponseFormat format = null;
    protected Map<String, String> queries = new HashMap<String, String>();
    protected DapController controller = null;
    protected String controllerpath = null;
    protected String resourceroot = null;
    protected ServletContext servletcontext = null;

    public DapRequest(DapController controller, HttpServletRequest request, HttpServletResponse response) throws DapException {
        this.controller = controller;
        this.request = request;
        this.response = response;
        this.servletcontext = request.getServletContext();
        try {
            this.parse();
        }
        catch (IOException ioe) {
            throw new DapException((Throwable)ioe);
        }
    }

    protected void parse() throws IOException {
        String[] pieces;
        this.url = this.request.getRequestURL().toString();
        this.datasetpath = this.request.getPathInfo();
        this.querystring = this.request.getQueryString();
        this.controllerpath = DapUtil.absolutize((String)this.request.getServletPath());
        boolean found = true;
        try {
            URL rurl = this.servletcontext.getResource("");
            if (rurl == null || !rurl.getProtocol().equalsIgnoreCase("file")) {
                found = false;
            } else {
                this.resourceroot = rurl.getPath();
                File res = new File(this.resourceroot);
                found = res.canRead();
                this.resourceroot = res.getAbsolutePath();
            }
        }
        catch (MalformedURLException mue) {
            found = false;
        }
        if (!found) {
            throw new DapException("Resource root not found").setCode(404);
        }
        StringBuilder buf = new StringBuilder();
        buf.append(this.request.getScheme());
        buf.append("://");
        buf.append(this.request.getServerName());
        int port = this.request.getServerPort();
        if (port > 0) {
            buf.append(":");
            buf.append(port);
        }
        this.server = buf.toString();
        this.mode = null;
        if (this.datasetpath == null || this.datasetpath.length() == 0) {
            this.mode = RequestMode.CAPABILITIES;
            this.format = ResponseFormat.HTML;
        } else {
            pieces = this.datasetpath.split("[.]");
            int modepos = 0;
            for (int i = pieces.length - 1; i >= 1; --i) {
                String ext = pieces[i];
                RequestMode mode = RequestMode.modeFor((String)ext);
                ResponseFormat format = ResponseFormat.formatFor((String)ext);
                if (mode != null) {
                    this.mode = mode;
                    modepos = i;
                    break;
                }
                if (format == null) continue;
                if (this.format != null) {
                    throw new DapException("Multiple response formats specified: " + ext).setCode(400);
                }
                this.format = format;
            }
            if (modepos > 0) {
                this.datasetpath = DapUtil.join((String[])pieces, (String)".", (int)0, (int)modepos);
            }
        }
        if (this.mode == null) {
            this.mode = RequestMode.DSR;
        }
        if (this.format == null) {
            this.format = ResponseFormat.NONE;
        }
        buf.setLength(0);
        buf.append(this.server);
        if (this.controllerpath != null) {
            buf.append(this.controllerpath);
        }
        if (this.datasetpath != null) {
            buf.append(this.datasetpath);
        }
        this.url = buf.toString();
        if (this.querystring != null && this.querystring.length() > 0) {
            for (String piece : pieces = this.querystring.split("&")) {
                String[] pair = piece.split("=");
                String name = Escape.urlDecode((String)pair[0]);
                name = name.toLowerCase();
                String value = pair.length == 2 ? Escape.urlDecode((String)pair[1]) : "";
                this.queries.put(name, value);
            }
        }
        DapLog.debug("DapRequest: realrootdir=" + this.getResourceRoot());
        DapLog.debug("DapRequest: extension=" + (this.mode == null ? "null" : this.mode.extension()));
        DapLog.debug("DapRequest: servletpath=" + this.controllerpath);
        DapLog.debug("DapRequest: datasetpath=" + this.datasetpath);
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public OutputStream getOutputStream() throws IOException {
        return this.response.getOutputStream();
    }

    public String getURL() {
        return this.url;
    }

    public String getOriginalURL() {
        return this.querystring == null ? this.url : this.url + "?" + this.querystring;
    }

    public String getDataset() {
        return this.datasetpath;
    }

    public String getServer() {
        return this.server;
    }

    public String getControllerPath() {
        return this.controllerpath;
    }

    public String getURLPath() {
        return this.controllerpath + (this.datasetpath == null ? "" : this.datasetpath);
    }

    public RequestMode getMode() {
        return this.mode;
    }

    public ResponseFormat getFormat() {
        return this.format;
    }

    public void setResponseHeader(String name, String value) {
        this.response.setHeader(name, value);
    }

    public String queryLookup(String name) {
        return this.queries.get(name.toLowerCase());
    }

    public String getResourcePath() {
        return this.getResourcePath(this.getDatasetPath());
    }

    public String getResourcePath(String suffix) {
        return DapUtil.canonjoin((String)this.resourceroot, (String)suffix);
    }

    public String getResourceRoot() {
        return this.resourceroot;
    }

    public String getDatasetPath() {
        return this.datasetpath;
    }
}

