/*
 * Decompiled with CFR 0.152.
 */
package dap4.servlet;

import dap4.ce.CEConstraint;
import dap4.core.dmr.DapAtomicVariable;
import dap4.core.dmr.DapDataset;
import dap4.core.dmr.DapNode;
import dap4.core.dmr.DapSequence;
import dap4.core.dmr.DapStructure;
import dap4.core.dmr.DapType;
import dap4.core.dmr.DapVariable;
import dap4.core.util.DapException;
import dap4.core.util.DapSort;
import dap4.core.util.Odometer;
import dap4.core.util.ScalarOdometer;
import dap4.core.util.Slice;
import dap4.servlet.ChunkWriter;
import dap4.servlet.DMRPrint;
import dap4.servlet.DapSerializer;
import dap4.servlet.RandomValue;
import dap4.servlet.SerialWriter;
import dap4.servlet.Value;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteOrder;
import java.util.List;

public class Generator
extends DapSerializer {
    static final boolean DEBUG = false;
    static final String LBRACE = "{";
    static final String RBRACE = "}";
    static final int DEFALTCACHELIMIT = 4;
    static final ByteOrder DEFAULTORDER = ByteOrder.LITTLE_ENDIAN;
    static final String DATADIR = "d4tests/src/test/data";
    static final String TESTSRC = "d4tests/src/test/data/resources/testfiles";
    static final String SERIALEXT = ".ser";
    static final String SRCEXT = ".dmr.ser";
    static final String DSTEXT = ".dap.ser";
    static final int MAXROWS = 5;
    static int rowcount = 0;
    protected static boolean asciionly = true;
    protected Value values = null;
    protected ByteArrayOutputStream stream = null;
    protected ChunkWriter cw = null;
    protected boolean withdmr = true;
    protected DapDataset dmr = null;

    public static void setASCII(boolean tf) {
        asciionly = tf;
    }

    public static int getRowCount() {
        return rowcount;
    }

    public static void setRowCount(int count) {
        if (count >= 0) {
            rowcount = count;
        }
    }

    public Generator(DapDataset dmr, Value.ValueSource src) throws DapException {
        this.dmr = dmr;
        if (src == null) {
            src = Value.ValueSource.RANDOM;
        }
        switch (src) {
            default: 
        }
        this.values = new RandomValue();
        this.values.setASCII(asciionly);
        SerialWriter.DEBUG = false;
    }

    public void generate(CEConstraint ce, ChunkWriter cw) throws DapException {
        this.generate(ce, cw, true);
    }

    public void generate(CEConstraint ce, ChunkWriter cw, boolean withdmr) throws DapException {
        this.begin(ce, cw, withdmr);
        if (this.withdmr) {
            this.generateDMR(this.dmr);
        }
        this.dataset(this.dmr);
        this.end();
    }

    public void begin(CEConstraint ce, ChunkWriter cw, boolean withdmr) throws DapException {
        this.cw = cw;
        if (ce == null) {
            ce = CEConstraint.getUniversal(this.dmr);
        }
        this.ce = ce;
        this.order = cw.getOrder();
        this.withdmr = withdmr;
        this.writer = new SerialWriter(this.cw, this.order);
    }

    public void end() throws DapException {
    }

    public void generateDMR(DapDataset dmr) throws DapException {
        try {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            DMRPrint dp = new DMRPrint(pw);
            dp.print((DapNode)dmr, this.ce);
            pw.close();
            sw.close();
            String tmp = sw.toString();
            this.cw.writeDMR(tmp);
            this.cw.flush();
        }
        catch (Exception e) {
            throw new DapException((Throwable)e);
        }
    }

    public void dataset(DapDataset dmr) throws DapException {
        for (DapVariable var : this.dmr.getTopVariables()) {
            if (!this.ce.references((DapNode)var)) continue;
            this.variable(var);
        }
    }

    public void variable(DapVariable dapvar) throws DapException {
        this.writer.startVariable();
        if (dapvar.getSort() == DapSort.ATOMICVARIABLE) {
            this.atomicVariable((DapAtomicVariable)dapvar);
        } else if (dapvar.getSort() == DapSort.STRUCTURE) {
            this.structure((DapStructure)dapvar);
        } else if (dapvar.getSort() == DapSort.SEQUENCE) {
            this.sequence((DapSequence)dapvar);
        } else {
            throw new DapException("generate var: not a variable:" + dapvar.getFQN());
        }
        try {
            this.writer.endVariable();
        }
        catch (IOException ioe) {
            throw new DapException((Throwable)ioe);
        }
    }

    public void atomicVariable(DapAtomicVariable dapvar) throws DapException {
        DapType basetype = dapvar.getBaseType();
        ScalarOdometer odom = null;
        if (dapvar.getRank() == 0) {
            odom = new ScalarOdometer();
        } else {
            List<Slice> slices = this.ce.getConstrainedSlices((DapVariable)dapvar);
            odom = Odometer.factory(slices, (List)dapvar.getDimensions(), (boolean)false);
        }
        while (odom.hasNext()) {
            Object value = this.values.nextValue(basetype);
            try {
                assert (this.writer != null);
                this.writer.writeObject(basetype, value);
            }
            catch (IOException ioe) {
                throw new DapException((Throwable)ioe);
            }
            odom.next();
        }
    }

    public void structure(DapStructure struct) throws DapException {
        List fields = struct.getFields();
        ScalarOdometer odom = null;
        if (struct.getRank() == 0) {
            odom = new ScalarOdometer();
        } else {
            List<Slice> slices = this.ce.getConstrainedSlices((DapVariable)struct);
            odom = Odometer.factory(slices, (List)struct.getDimensions(), (boolean)false);
        }
        while (odom.hasNext()) {
            for (int i = 0; i < fields.size(); ++i) {
                DapVariable field = (DapVariable)fields.get(i);
                this.variable(field);
            }
            odom.next();
        }
    }

    public void sequence(DapSequence seq) throws DapException {
        List fields = seq.getFields();
        ScalarOdometer odom = null;
        if (seq.getRank() == 0) {
            odom = new ScalarOdometer();
        } else {
            List<Slice> slices = this.ce.getConstrainedSlices((DapVariable)seq);
            odom = Odometer.factory(slices, (List)seq.getDimensions(), (boolean)false);
        }
        try {
            while (odom.hasNext()) {
                int nrows = rowcount == 0 ? this.values.nextCount(5) : rowcount;
                this.writer.writeObject(DapType.INT64, nrows);
                for (int i = 0; i < nrows; ++i) {
                    for (int j = 0; j < fields.size(); ++j) {
                        DapVariable field = (DapVariable)fields.get(j);
                        this.variable(field);
                    }
                }
                odom.next();
            }
        }
        catch (IOException ioe) {
            throw new DapException((Throwable)ioe);
        }
    }
}

