/*
 * Decompiled with CFR 0.152.
 */
package dap4.dap4shared;

import dap4.core.data.DataDataset;
import dap4.core.data.DataException;
import dap4.core.dmr.DapDataset;
import dap4.core.util.DapContext;
import dap4.core.util.DapException;
import dap4.dap4shared.DSP;
import dap4.dap4shared.XURI;
import java.net.URISyntaxException;

public abstract class AbstractDSP
implements DSP {
    protected Object context = null;
    protected String path = null;
    protected XURI xuri = null;
    protected DapDataset dmr = null;

    public AbstractDSP() {
    }

    public AbstractDSP(String path, Object context) throws DapException {
        this();
        this.setPath(path);
        this.setContext(context);
    }

    @Override
    public abstract boolean match(String var1, DapContext var2);

    @Override
    public abstract DSP open(String var1, DapContext var2) throws DapException;

    @Override
    public abstract DSP open(String var1) throws DapException;

    @Override
    public abstract DataDataset getDataDataset();

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public Object getContext() {
        return this.context;
    }

    @Override
    public DapDataset getDMR() {
        return this.dmr;
    }

    protected void setDataset(DapDataset dataset) throws DapException {
        this.dmr = dataset;
        this.dmr.finish();
    }

    protected void setContext(Object context) {
        this.context = context;
    }

    protected void setPath(String path) throws DapException {
        this.path = path;
        try {
            this.xuri = new XURI(path);
        }
        catch (URISyntaxException use) {
            throw new DataException((Throwable)use);
        }
    }
}

