/*
 * Decompiled with CFR 0.152.
 */
package dap4.dap4shared;

import dap4.core.data.DataDataset;
import dap4.core.dmr.DapDataset;
import dap4.core.dmr.DapFactory;
import dap4.core.dmr.DapFactoryDMR;
import dap4.core.dmr.ErrorResponse;
import dap4.core.dmr.parser.Dap4Parser;
import dap4.core.util.DapContext;
import dap4.core.util.DapException;
import dap4.core.util.DapUtil;
import dap4.dap4shared.AbstractDSP;
import dap4.dap4shared.ChecksumMode;
import dap4.dap4shared.ChunkInputStream;
import dap4.dap4shared.D4DataDataset;
import dap4.dap4shared.DataCompiler;
import dap4.dap4shared.RequestMode;
import dap4.dap4shared.XURI;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.ByteBuffer;
import org.xml.sax.SAXException;
import ucar.httpclient.HTTPFactory;
import ucar.httpclient.HTTPMethod;

public class D4DSP
extends AbstractDSP {
    protected static final boolean PARSEDEBUG = false;
    protected static final boolean DEBUG = false;
    protected static final String DAPVERSION = "4.0";
    protected static final String DMRVERSION = "1.0";
    protected static final String DAP4PROTO = "dap4";
    protected static final String FILEPROTO = "file";
    protected static final String DMRSUFFIX = "dmr";
    protected static final String DATASUFFIX = "dap";
    protected static final String DSRSUFFIX = "dsr";
    protected static final String QUERYSTART = "?";
    protected static final String CONSTRAINTTAG = "dap4.ce";
    protected static final String CHECKSUMTAG = "checksum";
    protected static final String PROTOTAG = "protocol";
    protected static final int DFALTPRELOADSIZE = 50000;
    protected static final String[] DAPEXTENSIONS = new String[]{"dmr", "databuffer", "dds", "das", "ddx", "dods"};
    protected static final String[] DAP4EXTENSIONS = new String[]{"dmr", "databuffer"};
    protected boolean isfile = false;
    protected D4DataDataset d4data = null;
    protected boolean allowCompression = true;
    protected int preloadsize = 50000;
    protected String basece;
    protected ByteBuffer databuffer = null;

    public D4DSP() {
    }

    public D4DSP(String path, DapContext cxt) throws DapException {
        super(path, cxt);
    }

    public D4DSP(String path) throws DapException {
        super(path, null);
    }

    @Override
    public D4DSP open(String path) throws DapException {
        return this.open(path, null);
    }

    @Override
    public D4DSP open(String path, DapContext context) throws DapException {
        try {
            this.xuri = new XURI(path);
            this.isfile = this.xuri.getBaseProtocol().equals(FILEPROTO);
            this.build();
            return this;
        }
        catch (URISyntaxException use) {
            throw new DapException((Throwable)use);
        }
    }

    @Override
    public boolean match(String path, DapContext context) {
        try {
            XURI xuri = new XURI(path);
            return xuri.getLeadProtocol().equals(DAP4PROTO) || xuri.getParameters().get(PROTOTAG).equals(DAP4PROTO);
        }
        catch (URISyntaxException uRISyntaxException) {
            return false;
        }
    }

    @Override
    public void close() {
    }

    @Override
    public DataDataset getDataDataset() {
        return this.d4data;
    }

    public ByteBuffer getDatabuffer() {
        return this.databuffer;
    }

    public void setD4Dataset(D4DataDataset dds) {
        this.d4data = dds;
    }

    protected D4DSP build() throws DapException {
        if (!this.isfile) {
            this.readDMR();
        }
        this.readDATA();
        return this;
    }

    protected void readDAP(RequestMode mode) throws DapException {
        InputStream stream;
        String methodurl = null;
        if (this.isfile) {
            mode = RequestMode.DAP;
        } else {
            methodurl = mode == RequestMode.DMR ? D4DSP.buildURL(this.xuri.pureURI(), DMRSUFFIX, this.dmr, this.basece) : D4DSP.buildURL(this.xuri.pureURI(), DATASUFFIX, this.dmr, this.basece);
        }
        State cxt = new State();
        cxt.requestmode = mode;
        cxt.checksummode = ChecksumMode.modeFor(this.xuri.getParameters().get(CHECKSUMTAG));
        if (cxt.checksummode == null) {
            cxt.checksummode = ChecksumMode.DAP;
        }
        if (this.isfile) {
            File f = new File(this.xuri.getPath());
            if (!f.canRead()) {
                throw new DapException("File not readable: " + f);
            }
            try {
                stream = new FileInputStream(f);
            }
            catch (FileNotFoundException nsfe) {
                throw new DapException("File not found: " + f);
            }
        } else {
            stream = this.callServer(methodurl, cxt);
        }
        ChunkInputStream rdr = new ChunkInputStream(stream, cxt.requestmode, cxt.bigendian);
        try {
            if (cxt.requestmode == RequestMode.DAP) {
                this.parseDATA(cxt, rdr);
            } else {
                this.parseDMR(cxt, rdr);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new DapException(t);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException ioe) {}
        }
    }

    protected void readDMR() throws DapException {
        this.readDAP(RequestMode.DMR);
    }

    protected void readDATA() throws DapException {
        this.readDAP(RequestMode.DAP);
    }

    public void parseDMR(State cxt, ChunkInputStream reader) throws IOException {
        String text = reader.readDMR();
        Dap4Parser pushparser = new Dap4Parser((DapFactory)new DapFactoryDMR());
        try {
            if (!pushparser.parse(text)) {
                throw new DapException("DMR Parse failed");
            }
        }
        catch (SAXException se) {
            throw new DapException("DMR Parse failed", (Throwable)se);
        }
        this.dmr = pushparser.getDMR();
        ErrorResponse err = pushparser.getErrorResponse();
        if (err != null) {
            throw err.buildException();
        }
        if (this.dmr == null) {
            throw new DapException("DMR Parse failed: no DMR created");
        }
    }

    public void parseDATA(State cxt, ChunkInputStream reader) throws IOException {
        this.parseDMR(cxt, reader);
        byte[] bytes = DapUtil.readbinaryfile((InputStream)reader);
        this.databuffer = ByteBuffer.wrap(bytes).order(reader.getByteOrder());
        DataCompiler compiler = new DataCompiler(this, cxt.checksummode, this.databuffer);
        compiler.compile();
    }

    protected InputStream callServer(String methodurl, State context) throws DapException {
        try {
            URL url = new URL(methodurl);
        }
        catch (MalformedURLException mue) {
            throw new DapException("Malformed url: " + methodurl);
        }
        HTTPMethod method = null;
        long start = System.currentTimeMillis();
        long stop = 0L;
        try {
            context.status = 0;
            method = HTTPFactory.Get((String)methodurl);
            if (this.allowCompression) {
                method.setRequestHeader("Accept-Encoding", "deflate,gzip");
            }
            context.status = method.execute();
            if (context.status != 200) {
                String msg = method.getResponseAsString();
                throw new DapException("Request failure: " + method.getStatusText() + ": " + methodurl).setCode(context.status);
            }
            InputStream msg = method.getResponseAsStream();
            return msg;
        }
        catch (Exception e) {
            method.close();
            throw new DapException((Throwable)e);
        }
        finally {
            stop = System.currentTimeMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCapabilities(String url) throws IOException {
        String saveurl = this.xuri.getOriginal();
        this.setPath(url);
        String fdsurl = D4DSP.buildURL(this.xuri.pureURI(), DSRSUFFIX, null, null);
        long start = System.currentTimeMillis();
        State cxt = new State();
        cxt.requestmode = RequestMode.CAPABILITIES;
        try {
            String document;
            InputStream stream = this.callServer(fdsurl, cxt);
            byte[] bytes = DapUtil.readbinaryfile((InputStream)stream);
            String string = document = new String(bytes, DapUtil.UTF8);
            return string;
        }
        finally {
            this.setPath(saveurl);
        }
    }

    protected static String buildURL(String baseurl, String suffix, DapDataset template, String ce) {
        StringBuilder methodurl = new StringBuilder();
        methodurl.append(baseurl);
        if (suffix != null) {
            methodurl.append('.');
            methodurl.append(suffix);
        }
        if (ce != null && ce.length() > 0) {
            methodurl.append(QUERYSTART);
            methodurl.append(CONSTRAINTTAG);
            methodurl.append('=');
            methodurl.append(ce);
        }
        return methodurl.toString();
    }

    protected static class State {
        public RequestMode requestmode = null;
        public ChecksumMode checksummode = null;
        public int status = 200;
        public boolean bigendian = false;
    }
}

