/*
 * Decompiled with CFR 0.152.
 */
package dap4.dap4shared;

import dap4.core.data.DataCompound;
import dap4.core.data.DataCompoundArray;
import dap4.core.data.DataException;
import dap4.core.data.DataSort;
import dap4.core.dmr.DapVariable;
import dap4.core.util.DapException;
import dap4.core.util.DapSort;
import dap4.core.util.DapUtil;
import dap4.core.util.Odometer;
import dap4.core.util.Slice;
import dap4.dap4shared.D4DSP;
import dap4.dap4shared.D4DataVariable;
import java.util.ArrayList;
import java.util.List;

public class D4DataCompoundArray
extends D4DataVariable
implements DataCompoundArray {
    D4DSP dsp = null;
    long position = 0L;
    DapVariable dapvar = null;
    List<DataCompound> instances = new ArrayList<DataCompound>();

    public D4DataCompoundArray(D4DSP dsp, DapVariable dv) throws DataException {
        super(dsp, dv);
        this.dsp = dsp;
        this.dapvar = dv;
    }

    @Override
    public D4DSP getDSP() {
        return this.dsp;
    }

    public DapVariable getDapVariable() {
        return this.dapvar;
    }

    public void addElement(DataCompound di) {
        this.instances.add(di);
    }

    public DataSort getElementSort() {
        if (this.dapvar.getSort() == DapSort.SEQUENCE) {
            return DataSort.SEQUENCE;
        }
        return DataSort.STRUCTURE;
    }

    public long getCount() {
        return DapUtil.dimProduct((List)this.dapvar.getDimensions());
    }

    public void read(List<Slice> slices, DataCompound[] data) throws DataException {
        Odometer odom;
        try {
            odom = new Odometer(slices, ((DapVariable)this.getTemplate()).getDimensions());
        }
        catch (DapException de) {
            throw new DataException((Throwable)de);
        }
        assert (odom.index() <= (long)data.length);
        int i = 0;
        while (odom.hasNext()) {
            long offset = odom.index();
            data[i] = this.read(offset);
            odom.next();
            ++i;
        }
    }

    public DataCompound read(long index) throws DataException {
        if (index < 0L || index >= (long)this.instances.size()) {
            throw new DataException("D4DataCompoundArray.read(i): index out of range: " + index);
        }
        return this.instances.get((int)index);
    }
}

