/*
 * Decompiled with CFR 0.152.
 */
package dap4.dap4shared;

import dap4.core.data.DataCompound;
import dap4.core.dmr.AtomicType;
import dap4.core.dmr.DapAtomicVariable;
import dap4.core.dmr.DapDataset;
import dap4.core.dmr.DapSequence;
import dap4.core.dmr.DapStructure;
import dap4.core.dmr.DapType;
import dap4.core.dmr.DapVariable;
import dap4.core.util.DapException;
import dap4.core.util.DapSort;
import dap4.dap4shared.ChecksumMode;
import dap4.dap4shared.D4DSP;
import dap4.dap4shared.D4DataAtomic;
import dap4.dap4shared.D4DataCompoundArray;
import dap4.dap4shared.D4DataDataset;
import dap4.dap4shared.D4DataRecord;
import dap4.dap4shared.D4DataSequence;
import dap4.dap4shared.D4DataStructure;
import dap4.dap4shared.D4DataVariable;
import dap4.dap4shared.Dap4Util;
import dap4.dap4shared.RequestMode;
import java.nio.ByteBuffer;
import java.util.List;

public class DataCompiler {
    static final boolean DEBUG = false;
    static final boolean DUMP = false;
    public static final int COUNTSIZE = 8;
    static String LBRACE = "{";
    static String RBRACE = "}";
    static final String CHECKSUMATTRNAME = "_DAP4_Checksum_CRC32";
    static final int CHECKSUMSIZE = 4;
    D4DataDataset d4dataset = null;
    DapDataset dataset = null;
    ByteBuffer databuffer;
    ChecksumMode checksummode = null;
    D4DSP dsp;

    DataCompiler(D4DSP dsp, ChecksumMode checksummode, ByteBuffer databuffer) throws DapException {
        this.dsp = dsp;
        this.dataset = this.dsp.getDMR();
        this.databuffer = databuffer;
        this.checksummode = checksummode;
    }

    void compile() throws DapException {
        assert (this.dataset != null && this.databuffer != null);
        this.d4dataset = new D4DataDataset(this.dsp, this.dataset);
        for (DapVariable vv : this.dataset.getTopVariables()) {
            D4DataVariable array = this.compileVar(vv);
            this.d4dataset.addVariable(array);
        }
    }

    protected D4DataVariable compileVar(DapVariable dapvar) throws DapException {
        boolean isscalar;
        D4DataVariable array = null;
        boolean bl = isscalar = dapvar.getRank() == 0;
        if (dapvar.getSort() == DapSort.ATOMICVARIABLE) {
            array = this.compileAtomicVar(dapvar);
        } else if (dapvar.getSort() == DapSort.STRUCTURE) {
            array = isscalar ? this.compileStructure((DapStructure)dapvar, null, 0) : this.compileStructureArray(dapvar);
        } else if (dapvar.getSort() == DapSort.SEQUENCE) {
            array = isscalar ? this.compileSequence((DapSequence)dapvar, null, 0) : this.compileSequenceArray(dapvar);
        }
        if (dapvar.isTopLevel()) {
            byte[] checksum = this.getChecksum(this.databuffer);
            dapvar.setChecksum(checksum);
        }
        return array;
    }

    protected D4DataAtomic compileAtomicVar(DapVariable dapvar) throws DapException {
        long total;
        DapAtomicVariable atomvar = (DapAtomicVariable)dapvar;
        DapType daptype = atomvar.getBaseType();
        D4DataAtomic data = new D4DataAtomic(this.dsp, atomvar, this.databuffer.position());
        long dimproduct = data.getCount();
        if (!daptype.isEnumType() && !daptype.isFixedSize()) {
            int[] positions = new int[(int)dimproduct];
            int savepos = this.databuffer.position();
            total = DataCompiler.walkByteStrings(positions, this.databuffer);
            this.databuffer.position(savepos);
            data.setByteStringOffsets(total, positions);
        } else {
            total = dimproduct * (long)daptype.getSize();
        }
        DataCompiler.skip(this.databuffer, (int)total);
        return data;
    }

    D4DataCompoundArray compileStructureArray(DapVariable dapvar) throws DapException {
        D4DataCompoundArray structarray = new D4DataCompoundArray(this.dsp, dapvar);
        DapStructure struct = (DapStructure)dapvar;
        List dfields = struct.getFields();
        long dimproduct = structarray.getCount();
        int i = 0;
        while ((long)i < dimproduct) {
            D4DataStructure instance = this.compileStructure(struct, structarray, i);
            structarray.addElement((DataCompound)instance);
            ++i;
        }
        return structarray;
    }

    D4DataStructure compileStructure(DapStructure dapstruct, D4DataCompoundArray array, int index) throws DapException {
        D4DataStructure d4ds = new D4DataStructure(this.dsp, dapstruct, array, index);
        List dfields = dapstruct.getFields();
        for (int m = 0; m < dfields.size(); ++m) {
            DapVariable dfield = (DapVariable)dfields.get(m);
            D4DataVariable dvfield = this.compileVar(dfield);
            d4ds.addField(m, dvfield);
        }
        return d4ds;
    }

    D4DataCompoundArray compileSequenceArray(DapVariable dapvar) throws DapException {
        DapSequence dapseq = (DapSequence)dapvar;
        D4DataCompoundArray seqarray = new D4DataCompoundArray(this.dsp, (DapVariable)dapseq);
        long dimproduct = seqarray.getCount();
        int i = 0;
        while ((long)i < dimproduct) {
            D4DataSequence dseq = this.compileSequence(dapseq, seqarray, i);
            seqarray.addElement((DataCompound)dseq);
            ++i;
        }
        return seqarray;
    }

    D4DataSequence compileSequence(DapSequence dapseq, D4DataCompoundArray array, int index) throws DapException {
        int savepos = this.databuffer.position();
        List dfields = dapseq.getFields();
        long count = DataCompiler.getCount(this.databuffer);
        D4DataSequence seq = new D4DataSequence(this.dsp, dapseq, array, index);
        int r = 0;
        while ((long)r < count) {
            D4DataRecord rec = new D4DataRecord(this.dsp, (DapStructure)dapseq, seq, r);
            for (int m = 0; m < dfields.size(); ++m) {
                DapVariable dfield = (DapVariable)dfields.get(m);
                D4DataVariable dvfield = this.compileVar(dfield);
                rec.addField(m, dvfield);
            }
            ++r;
        }
        return seq;
    }

    protected byte[] getChecksum(ByteBuffer data) throws DapException {
        if (!ChecksumMode.enabled(RequestMode.DAP, this.checksummode)) {
            return null;
        }
        if (data.remaining() < 4) {
            throw new DapException("Short serialization: missing checksum");
        }
        byte[] checksum = new byte[4];
        data.get(checksum);
        return checksum;
    }

    protected static void skip(ByteBuffer data, int count) {
        data.position(data.position() + count);
    }

    protected static int getCount(ByteBuffer data) {
        long count = data.getLong();
        return (int)(count & 0xFFFFFFFFFFFFFFFFL);
    }

    protected static int computeTypeSize(DapType daptype) {
        AtomicType atype = daptype.getPrimitiveType();
        return Dap4Util.daptypeSize(atype);
    }

    protected static long walkByteStrings(int[] positions, ByteBuffer databuffer) {
        int count = positions.length;
        long total = 0L;
        int savepos = databuffer.position();
        for (int i = 0; i < count; ++i) {
            int pos;
            positions[i] = pos = databuffer.position();
            int size = DataCompiler.getCount(databuffer);
            total += 8L;
            total += (long)size;
            DataCompiler.skip(databuffer, size);
        }
        databuffer.position(savepos);
        return total;
    }
}

