/*
 * Decompiled with CFR 0.152.
 */
package dap4.dap4shared;

import dap4.dap4shared.RequestMode;

public enum ChecksumMode {
    DMR,
    DAP,
    ALL;


    public static boolean enabled(RequestMode rqm, ChecksumMode ckm) {
        switch (ckm) {
            case DMR: {
                return rqm == RequestMode.DMR;
            }
            case DAP: {
                return rqm == RequestMode.DAP;
            }
            case ALL: {
                return rqm == RequestMode.DMR || rqm == RequestMode.DMR;
            }
        }
        return false;
    }

    public static ChecksumMode modeFor(String s) {
        if (s == null || s.length() == 0) {
            return DAP;
        }
        for (ChecksumMode mode : ChecksumMode.values()) {
            if (!mode.name().equalsIgnoreCase(s)) continue;
            return mode;
        }
        return null;
    }
}

